/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.agent.impl;

import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.osgi.service.metatype.annotations.Option;

@ObjectClassDefinition(name="Apache Sling Distribution Agent - Forward Agents Factory", description="OSGi configuration factory for forward agents")
public @interface ForwardDistributionAgentFactoryConfig {
    @AttributeDefinition(name="Name", description="The name of the agent.")
    public String name() default "";

    @AttributeDefinition(name="Title", description="The display friendly title of the agent.")
    public String title() default "";

    @AttributeDefinition(name="Details", description="The display friendly details of the agent.")
    public String details() default "";

    @AttributeDefinition(name="Enabled", description="Whether or not to start the distribution agent.")
    public boolean enabled() default true;

    @AttributeDefinition(name="Service Name", description="The name of the service used to access the repository. If not set, the calling user ResourceResolver will be used")
    public String serviceName() default "";

    @AttributeDefinition(name="Log Level", description="The log level recorded in the transient log accessible via http.", options={@Option(label="debug", value="debug"), @Option(label="info", value="info"), @Option(label="warn", value="warn"), @Option(label="error", value="error")})
    public String log_level() default "info";

    @AttributeDefinition(cardinality=100, name="Allowed roots", description="If set the agent will allow only distribution requests under the specified roots.")
    public String[] allowed_roots();

    @AttributeDefinition(name="Queue Processing Enabled", description="Whether or not the distribution agent should process packages in the queues.")
    public boolean queue_processing_enabled() default true;

    @AttributeDefinition(cardinality=100, name="Importer Endpoints", description="List of endpoints to which packages are sent (imported). The list can be given as a map in case a queue should be configured for each endpoint, e.g. queueName=http://...")
    public String[] packageImporter_endpoints();

    @AttributeDefinition(cardinality=100, name="passive queues", description="List of queues that should be disabled.These queues will gather all the packages until they are removed explicitly.")
    public String[] passiveQueues();

    @AttributeDefinition(cardinality=100, name="Priority queues", description="List of priority queues that should used for specific paths.The selector format is  {queuePrefix}[|{mainQueueMatcher}]={pathMatcher}, e.g. french=/content/fr.*")
    public String[] priorityQueues();

    @AttributeDefinition(name="Retry Strategy", description="The strategy to apply after a certain number of failed retries.", options={@Option(label="none", value="none"), @Option(label="errorQueue", value="errorQueue")})
    public String retry_strategy() default "none";

    @AttributeDefinition(name="Retry attemps", description="The number of times to retry until the retry strategy is applied.")
    public int retry_attempts() default 100;

    @AttributeDefinition(name="Request Authorization Strategy", description="The target reference for the DistributionRequestAuthorizationStrategy used to authorize the access to distribution process,e.g. use target=(name=...) to bind to services by name.")
    public String requestAuthorizationStrategy_target() default "(name=default)";

    @AttributeDefinition(name="Transport Secret Provider", description="The target reference for the DistributionTransportSecretProvider used to obtain the credentials used for accessing the remote endpoints, e.g. use target=(name=...) to bind to services by name.")
    public String transportSecretProvider_target() default "(name=default)";

    @AttributeDefinition(name="Package Builder", description="The target reference for the DistributionPackageBuilder used to create distribution packages, e.g. use target=(name=...) to bind to services by name.")
    public String packageBuilder_target() default "(name=default)";

    @AttributeDefinition(name="Triggers", description="The target reference for DistributionTrigger used to trigger distribution, e.g. use target=(name=...) to bind to services by name.")
    public String triggers_target() default "(name=)";

    @AttributeDefinition(name="Queue provider", description="he queue provider implementation.", options={@Option(label="jobs", value="jobs"), @Option(label="resource", value="Resource Backed"), @Option(label="simple", value="In-memory"), @Option(label="simple-checkpoint", value="In-file")})
    public String queue_provider() default "jobs";

    @AttributeDefinition(name="Async delivery", description="Whether or not to use a separate delivery queue to maximize transport throughput when queue has more than 100 items")
    public boolean async_delivery() default false;

    @AttributeDefinition(name="HTTP connection timeout", description="The connection timeout for HTTP requests (in seconds).")
    public int http_conn_timeout() default 10;
}

