/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.journal.impl.subscriber;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.sling.distribution.journal.bookkeeper.BookKeeper;
import org.apache.sling.distribution.journal.messages.DiscoveryMessage;
import org.apache.sling.distribution.journal.messages.SubscriberConfig;
import org.apache.sling.distribution.journal.messages.SubscriberState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
class Announcer
implements Runnable,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Announcer.class);
    private final BookKeeper bookKeeper;
    private final Consumer<DiscoveryMessage> sender;
    private final String subSlingId;
    private final String subAgentName;
    private final Set<String> pubAgentNames;
    private final boolean editable;
    private final int maxRetries;
    private final ScheduledExecutorService executor;

    public Announcer(String subSlingId, String subAgentName, Set<String> pubAgentNames, Consumer<DiscoveryMessage> disSender, BookKeeper bookKeeper, int maxRetries, boolean editable, int announceDelay) {
        this.subSlingId = Objects.requireNonNull(subSlingId);
        this.subAgentName = Objects.requireNonNull(subAgentName);
        this.pubAgentNames = Objects.requireNonNull(pubAgentNames);
        this.sender = Objects.requireNonNull(disSender);
        this.bookKeeper = Objects.requireNonNull(bookKeeper);
        this.maxRetries = maxRetries;
        this.editable = editable;
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(this, 0L, announceDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        try {
            DiscoveryMessage msg = this.createDiscoveryMessage();
            LOG.debug("Sending discovery message {}", (Object)msg);
            this.sender.accept(msg);
        }
        catch (Exception e) {
            LOG.info("Failed to send discovery message for agent {}, {}", new Object[]{this.subAgentName, e.getMessage(), e});
        }
    }

    private DiscoveryMessage createDiscoveryMessage() {
        long offset = this.bookKeeper.loadOffset();
        SubscriberConfig subscriberConfiguration = SubscriberConfig.builder().editable(this.editable).maxRetries(this.maxRetries).build();
        List states = this.pubAgentNames.stream().map(pubAgentName -> this.subscriberState((String)pubAgentName, offset)).collect(Collectors.toList());
        return DiscoveryMessage.builder().subSlingId(this.subSlingId).subAgentName(this.subAgentName).subscriberConfiguration(subscriberConfiguration).subscriberStates(states).build();
    }

    private SubscriberState subscriberState(String pubAgentName, long offset) {
        int retries = this.bookKeeper.getRetries(pubAgentName);
        return SubscriberState.builder().pubAgentName(pubAgentName).retries(retries).offset(offset).build();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }
}

