/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.test;

import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.commons.JcrUtils;
import org.apache.jackrabbit.commons.jackrabbit.authorization.AccessControlUtils;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class Init {
    Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference
    SlingRepository slingRepository;

    @Activate
    public void activate() throws Exception {
        try {
            User defaultAgentUser;
            String defaultAgentUserName = "distribution-agent-user";
            String serviceUserName = "testDistributionUser";
            String distributorUserName = "testDistributorUser";
            Session session = this.slingRepository.loginAdministrative(null);
            JackrabbitSession jackrabittSession = (JackrabbitSession)session;
            UserManager userManager = jackrabittSession.getUserManager();
            User serviceUser = this.createOrGetServiceUser(userManager, "testDistributionUser");
            if (serviceUser != null) {
                AccessControlUtils.addAccessControlEntry((Session)session, (String)"/var/sling/distribution/packages", (Principal)serviceUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
                AccessControlUtils.addAccessControlEntry((Session)session, (String)"/content", (Principal)serviceUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
                AccessControlUtils.addAccessControlEntry((Session)session, null, (Principal)serviceUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
            }
            User distributorUser = this.createOrGetRegularUser(userManager, "testDistributorUser");
            JcrUtils.getOrCreateByPath((String)"/content", (String)"sling:Folder", (Session)session);
            if (distributorUser != null) {
                AccessControlUtils.addAccessControlEntry((Session)session, (String)"/var/sling/distribution/packages", (Principal)distributorUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
                AccessControlUtils.addAccessControlEntry((Session)session, (String)"/content", (Principal)distributorUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
                AccessControlUtils.addAccessControlEntry((Session)session, (String)"/libs/sling/distribution", (Principal)distributorUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
                AccessControlUtils.addAccessControlEntry((Session)session, null, (Principal)distributorUser.getPrincipal(), (String[])new String[]{"{http://www.jcp.org/jcr/1.0}all"}, (boolean)true);
            }
            if ((defaultAgentUser = this.createOrGetServiceUser(userManager, "distribution-agent-user")) != null) {
                distributorUser.getImpersonation().grantImpersonation(defaultAgentUser.getPrincipal());
                serviceUser.getImpersonation().grantImpersonation(defaultAgentUser.getPrincipal());
            }
            session.save();
            session.logout();
        }
        catch (Throwable t) {
            this.log.error("cannot create user", t);
        }
    }

    private User createOrGetServiceUser(UserManager userManager, String serviceUserName) throws RepositoryException {
        Authorizable serviceUser = userManager.getAuthorizable(serviceUserName);
        if (serviceUser == null) {
            try {
                serviceUser = userManager.createSystemUser(serviceUserName, null);
                this.log.info("created system user {}", (Object)serviceUserName);
            }
            catch (Throwable t) {
                serviceUser = userManager.createUser(serviceUserName, "123");
                this.log.info("created regular user {}", (Object)serviceUserName);
            }
        }
        return (User)serviceUser;
    }

    private User createOrGetRegularUser(UserManager userManager, String userName) throws RepositoryException {
        Authorizable serviceUser = userManager.getAuthorizable(userName);
        if (serviceUser == null) {
            serviceUser = userManager.createUser(userName, "123");
            this.log.info("created regular user {}", (Object)userName);
        }
        return (User)serviceUser;
    }

    protected void bindSlingRepository(SlingRepository slingRepository) {
        this.slingRepository = slingRepository;
    }

    protected void unbindSlingRepository(SlingRepository slingRepository) {
        if (this.slingRepository == slingRepository) {
            this.slingRepository = null;
        }
    }
}

