/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl;

import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.event.impl.EventingThreadPool;
import org.apache.sling.event.impl.support.Environment;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, property={"service.vendor=The Apache Software Foundation"}, service={EnvironmentComponent.class})
public class EnvironmentComponent {
    @Reference(service=EventingThreadPool.class, policyOption=ReferencePolicyOption.GREEDY)
    private ThreadPool threadPool;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingSettingsService settingsService;

    @Activate
    protected void activate() {
        Environment.APPLICATION_ID = this.settingsService.getSlingId();
        Environment.THREAD_POOL = this.threadPool;
    }

    @Deactivate
    protected void deactivate() {
        if (Environment.THREAD_POOL == this.threadPool) {
            Environment.THREAD_POOL = null;
        }
    }

    protected void bindThreadPool(EventingThreadPool etp) {
        this.threadPool = etp;
    }

    protected void unbindThreadPool(EventingThreadPool etp) {
        if (this.threadPool == etp) {
            this.threadPool = null;
        }
    }
}

