/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.impl.vlt.filter;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.fs.impl.AggregateManagerImpl;
import org.apache.sling.ide.filter.Filter;
import org.apache.sling.ide.filter.FilterResult;
import org.apache.sling.ide.transport.RepositoryPath;

public class VltFilter
implements Filter {
    private DefaultWorkspaceFilter filter;

    public VltFilter(InputStream in) throws IOException, ConfigurationException {
        if (in != null) {
            this.filter = new DefaultWorkspaceFilter();
            this.filter.load(in);
        } else {
            this.filter = AggregateManagerImpl.getDefaultWorkspaceFilter();
        }
    }

    public FilterResult filter(RepositoryPath repositoryPath) {
        String pathAsString = repositoryPath.asString();
        if (this.filter.contains(pathAsString)) {
            return FilterResult.ALLOW;
        }
        for (PathFilterSet pathFilterSet : this.filter.getFilterSets()) {
            if (!pathFilterSet.getRoot().startsWith(pathAsString)) continue;
            return FilterResult.PREREQUISITE;
        }
        return FilterResult.DENY;
    }
}

