/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.webconsole.internal;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"felix.inventory.printer.name=JCR Namespaces", "felix.inventory.printer.format=TEXT"})
public class NamespacesPrinter
implements InventoryPrinter {
    @Reference
    private SlingRepository slingRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(PrintWriter printWriter, Format format, boolean isZip) {
        Session session = null;
        try {
            session = this.slingRepository.loginAdministrative(null);
            NamespaceRegistry reg = session.getWorkspace().getNamespaceRegistry();
            List<String> globalPrefixes = Arrays.asList(reg.getPrefixes());
            List<String> localPrefixes = Arrays.asList(session.getNamespacePrefixes());
            Collections.sort(localPrefixes);
            for (String prefix : localPrefixes) {
                if (prefix.length() <= 0) continue;
                printWriter.printf("%10s = %s", prefix, session.getNamespaceURI(prefix));
                if (globalPrefixes.contains(prefix)) {
                    printWriter.print(" [global]");
                } else {
                    printWriter.print(" [local]");
                }
                printWriter.println();
            }
        }
        catch (RepositoryException e) {
            printWriter.println("Unable to output namespace mappings.");
            e.printStackTrace(printWriter);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }
}

