/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.validation;

import org.apache.sling.models.factory.InvalidModelException;
import org.apache.sling.validation.ValidationFailure;
import org.apache.sling.validation.ValidationResult;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class InvalidResourceException
extends InvalidModelException {
    private static final long serialVersionUID = -5134512515466089688L;
    private final ValidationResult result;
    private final String path;

    public InvalidResourceException(String message, ValidationResult result, String path) {
        super(message);
        this.result = result;
        this.path = path;
    }

    public ValidationResult getResult() {
        return this.result;
    }

    public String getPath() {
        return this.path;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder("Validation errors for ");
        builder.append("'" + this.path + "':");
        for (ValidationFailure failure : this.result.getFailures()) {
            builder.append("\n" + failure.getLocation() + ":" + failure.getMessage(null) + "\n\t");
        }
        return builder.toString();
    }
}

