/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.pipes.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.event.jobs.Job;
import org.apache.sling.pipes.BasePipe;
import org.apache.sling.pipes.CommandUtil;
import org.apache.sling.pipes.ExecutionResult;
import org.apache.sling.pipes.OutputWriter;
import org.apache.sling.pipes.Pipe;
import org.apache.sling.pipes.PipeBuilder;
import org.apache.sling.pipes.PipeExecutor;
import org.apache.sling.pipes.Plumber;
import org.apache.sling.pipes.internal.ACLPipe;
import org.apache.sling.pipes.internal.AuthorizablePipe;
import org.apache.sling.pipes.internal.FilterPipe;
import org.apache.sling.pipes.internal.JsonWriter;
import org.apache.sling.pipes.internal.MovePipe;
import org.apache.sling.pipes.internal.MultiPropertyPipe;
import org.apache.sling.pipes.internal.NotPipe;
import org.apache.sling.pipes.internal.PackagePipe;
import org.apache.sling.pipes.internal.PathPipe;
import org.apache.sling.pipes.internal.ReferencePipe;
import org.apache.sling.pipes.internal.RemovePipe;
import org.apache.sling.pipes.internal.ShallowReferencePipe;
import org.apache.sling.pipes.internal.TraversePipe;
import org.apache.sling.pipes.internal.WritePipe;
import org.apache.sling.pipes.internal.XPathPipe;
import org.apache.sling.pipes.internal.inputstream.CsvPipe;
import org.apache.sling.pipes.internal.inputstream.JsonPipe;
import org.apache.sling.pipes.internal.inputstream.RegexpPipe;
import org.apache.sling.pipes.internal.slingquery.ChildrenPipe;
import org.apache.sling.pipes.internal.slingquery.ClosestPipe;
import org.apache.sling.pipes.internal.slingquery.FindPipe;
import org.apache.sling.pipes.internal.slingquery.ParentPipe;
import org.apache.sling.pipes.internal.slingquery.ParentsPipe;
import org.apache.sling.pipes.internal.slingquery.SiblingsPipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeBuilderImpl
implements PipeBuilder {
    private static final Logger logger = LoggerFactory.getLogger(PipeBuilderImpl.class);
    private static final String[] DEFAULT_NAMES = new String[]{"one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten"};
    List<Step> steps;
    Map<String, Object> outputs;
    Step containerStep;
    Step currentStep;
    Plumber plumber;
    ResourceResolver resolver;

    PipeBuilderImpl(ResourceResolver resolver, Plumber plumber) {
        this.currentStep = this.containerStep = new Step("slingPipes/container");
        this.plumber = plumber;
        this.resolver = resolver;
    }

    @Override
    public PipeBuilder pipe(String type) {
        if (!this.plumber.isTypeRegistered(type)) {
            throw new IllegalArgumentException(type + " is not a registered pipe type");
        }
        if (this.steps == null) {
            this.steps = new ArrayList<Step>();
        }
        this.currentStep = new Step(type);
        this.steps.add(this.currentStep);
        return this;
    }

    PipeBuilder pipeWithExpr(String type, String expr) {
        try {
            this.pipe(type).expr(expr);
        }
        catch (IllegalAccessException e) {
            logger.error("exception while configuring {}", (Object)type, (Object)e);
        }
        return this;
    }

    @Override
    @PipeExecutor(command="mv", resourceType="slingPipes/mv", pipeClass=MovePipe.class, description="move current resource to expr (more on https://sling.apache.org/documentation/bundles/sling-pipes/writers.html)")
    public PipeBuilder mv(String expr) {
        return this.pipeWithExpr("slingPipes/mv", expr);
    }

    @Override
    @PipeExecutor(command="write", resourceType="slingPipes/write", pipeClass=WritePipe.class, description="write following key=value pairs to the current resource")
    public PipeBuilder write(Object ... conf) throws IllegalAccessException {
        PipeBuilder instance = this.pipe("slingPipes/write");
        if (conf.length > 0) {
            instance = instance.conf(conf);
        }
        return instance;
    }

    @Override
    @PipeExecutor(command="grep", resourceType="slingPipes/filter", pipeClass=FilterPipe.class, description="filter current resources with following key=value pairs")
    public PipeBuilder grep(Object ... conf) throws IllegalAccessException {
        return this.pipe("slingPipes/filter").conf(conf);
    }

    @Override
    @PipeExecutor(command="auth", resourceType="slingPipes/authorizable", pipeClass=AuthorizablePipe.class, description="convert current resource as authorizable")
    public PipeBuilder auth(Object ... conf) throws IllegalAccessException {
        return this.pipe("slingPipes/authorizable").conf(conf);
    }

    @Override
    @PipeExecutor(command="xpath", resourceType="slingPipes/xpath", pipeClass=XPathPipe.class, description="create following xpath query's result as output resources")
    public PipeBuilder xpath(String expr) {
        return this.pipeWithExpr("slingPipes/xpath", expr);
    }

    @Override
    @PipeExecutor(command="children", resourceType="slingPipes/children", pipeClass=ChildrenPipe.class, description="list current resource's immediate children")
    public PipeBuilder children(String expr) {
        return this.pipeWithExpr("slingPipes/children", expr);
    }

    @Override
    @PipeExecutor(command="rm", resourceType="slingPipes/rm", pipeClass=RemovePipe.class, description="remove current resource")
    public PipeBuilder rm() {
        return this.pipe("slingPipes/rm");
    }

    @Override
    @PipeExecutor(command="traverse", resourceType="slingPipes/traverse", pipeClass=TraversePipe.class, description="traverse current resource")
    public PipeBuilder traverse() {
        return this.pipe("slingPipes/traverse");
    }

    @Override
    @PipeExecutor(command="csv", resourceType="slingPipes/csv", pipeClass=CsvPipe.class, description="read expr's csv and output each line in the bindings")
    public PipeBuilder csv(String expr) {
        return this.pipeWithExpr("slingPipes/csv", expr);
    }

    @Override
    @PipeExecutor(command="json", resourceType="slingPipes/json", pipeClass=JsonPipe.class, description="read expr's json array and output each object in the bindings")
    public PipeBuilder json(String expr) {
        return this.pipeWithExpr("slingPipes/json", expr);
    }

    @Override
    @PipeExecutor(command="egrep", resourceType="slingPipes/egrep", pipeClass=RegexpPipe.class, description="read expr's txt and output each found pattern in the binding")
    public PipeBuilder egrep(String expr) {
        return this.pipeWithExpr("slingPipes/egrep", expr);
    }

    @Override
    @PipeExecutor(command="mkdir", resourceType="slingPipes/path", pipeClass=PathPipe.class, description="create expr path")
    public PipeBuilder mkdir(String expr) {
        return this.pipeWithExpr("slingPipes/path", expr);
    }

    @Override
    @PipeExecutor(command="echo", resourceType="slingPipes/base", pipeClass=BasePipe.class, description="output input's path")
    public PipeBuilder echo(String path) {
        try {
            this.pipe("slingPipes/base").path(path);
        }
        catch (IllegalAccessException e) {
            logger.error("error when calling echo {}", (Object)path, (Object)e);
        }
        return this;
    }

    @Override
    @PipeExecutor(command="parent", resourceType="slingPipes/parent", pipeClass=ParentPipe.class, description="return current's resource parent")
    public PipeBuilder parent() {
        return this.pipe("slingPipes/parent");
    }

    @Override
    @PipeExecutor(command="parents", resourceType="slingPipes/parents", pipeClass=ParentsPipe.class, description="return current's resource parents")
    public PipeBuilder parents(String expr) {
        return this.pipeWithExpr("slingPipes/parents", expr);
    }

    @Override
    @PipeExecutor(command="siblings", resourceType="slingPipes/siblings", pipeClass=SiblingsPipe.class, description="list current resource's siblings")
    public PipeBuilder siblings(String expr) {
        return this.pipeWithExpr("slingPipes/siblings", expr);
    }

    @Override
    @PipeExecutor(command="closest", resourceType="slingPipes/closest", pipeClass=ClosestPipe.class, description="return closest resource of the current")
    public PipeBuilder closest(String expr) {
        return this.pipeWithExpr("slingPipes/closest", expr);
    }

    @Override
    @PipeExecutor(command="$", resourceType="slingPipes/find", pipeClass=FindPipe.class, description="find resource from the current, with the given expression as a parameter")
    public PipeBuilder $(String expr) {
        return this.pipeWithExpr("slingPipes/find", expr);
    }

    @Override
    @PipeExecutor(command="ref", resourceType="slingPipes/reference", pipeClass=ReferencePipe.class, description="reference passed pipe")
    public PipeBuilder ref(String expr) {
        return this.pipeWithExpr("slingPipes/reference", expr);
    }

    @Override
    @PipeExecutor(command="shallowRef", resourceType="slingPipes/shallow", pipeClass=ShallowReferencePipe.class, description="shallow reference passed pipe, to be used for recursive usage")
    public PipeBuilder shallowRef(String expr) {
        return this.pipeWithExpr("slingPipes/shallow", expr);
    }

    @Override
    @PipeExecutor(command="mp", resourceType="slingPipes/multiProperty", pipeClass=MultiPropertyPipe.class, description="read MULTI property, and output each value in the bindings")
    public PipeBuilder mp() {
        return this.pipe("slingPipes/multiProperty");
    }

    @Override
    @PipeExecutor(command="pkg", resourceType="slingPipes/package", pipeClass=PackagePipe.class, description="package up current resource in given package")
    public PipeBuilder pkg(String expr) {
        try {
            this.pipeWithExpr("slingPipes/package", expr).with("filterCollectionMode", true);
        }
        catch (IllegalAccessException e) {
            logger.error("error when calling pkg", (Throwable)e);
        }
        return this;
    }

    @Override
    @PipeExecutor(command="not", resourceType="slingPipes/not", pipeClass=NotPipe.class, description="invert output: if input, return nothing, if no input, return single resource")
    public PipeBuilder not(String expr) {
        return this.pipeWithExpr("slingPipes/not", expr);
    }

    @Override
    public PipeBuilder with(Object ... params) throws IllegalAccessException {
        return this.writeToCurrentStep(null, true, params);
    }

    @Override
    public PipeBuilder withStrings(String ... params) {
        return this.writeToCurrentStep(null, false, params);
    }

    @Override
    public PipeBuilder conf(Object ... properties) throws IllegalAccessException {
        return this.writeToCurrentStep("conf", true, properties);
    }

    @Override
    public PipeBuilder bindings(Object ... bindings) throws IllegalAccessException {
        return this.writeToCurrentStep("additionalBindings", true, bindings);
    }

    @Override
    @PipeExecutor(command="acls", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="output each acls on the resource or  acls for authorizable in repository in bindings")
    public PipeBuilder acls() {
        return this.pipe("slingPipes/acl");
    }

    @Override
    @PipeExecutor(command="allow", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="sets allow acls on the resource")
    public PipeBuilder allow(String expr) throws IllegalAccessException {
        return this.pipeWithExpr("slingPipes/acl", expr).with("allow", "true");
    }

    @Override
    @PipeExecutor(command="deny", resourceType="slingPipes/acl", pipeClass=ACLPipe.class, description="sets deny acls on the resource")
    public PipeBuilder deny(String expr) throws IllegalAccessException {
        return this.pipeWithExpr("slingPipes/acl", expr).with("deny", "true");
    }

    PipeBuilder writeToCurrentStep(String name, boolean embed, Object ... params) {
        Map<String, Object> props;
        CommandUtil.checkArguments(params);
        Map<String, Object> map = props = name != null ? this.currentStep.confs.get(name) : this.currentStep.properties;
        if (props == null) {
            props = new HashMap<String, Object>();
            if (name != null) {
                this.currentStep.confs.put(name, props);
            }
        }
        CommandUtil.writeToMap(props, embed, params);
        return this;
    }

    @Override
    public PipeBuilder expr(String value) throws IllegalAccessException {
        return this.withStrings("expr", value);
    }

    @Override
    public PipeBuilder path(String value) throws IllegalAccessException {
        return this.with("path", value);
    }

    @Override
    public PipeBuilder name(String name) throws IllegalAccessException {
        this.currentStep.name = name;
        return this;
    }

    Resource createResource(ResourceResolver resolver, String path, String type, Map<String, Object> data) throws PersistenceException {
        if (data.keySet().stream().noneMatch(k -> k.contains("/"))) {
            return ResourceUtil.getOrCreateResource((ResourceResolver)resolver, (String)path, data, (String)type, (boolean)false);
        }
        String returnPath = "";
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (!entry.getKey().contains("/")) continue;
            String deepPath = String.join((CharSequence)"/", path, StringUtils.substringBeforeLast((String)entry.getKey(), (String)"/"));
            this.createResource(resolver, deepPath, type, Collections.singletonMap(StringUtils.substringAfterLast((String)entry.getKey(), (String)"/"), entry.getValue()));
            if (!returnPath.isEmpty() && returnPath.length() <= deepPath.length()) continue;
            returnPath = deepPath;
        }
        return resolver.getResource(returnPath);
    }

    @Override
    public PipeBuilder outputs(String ... keys) {
        this.outputs = new HashMap<String, Object>();
        CommandUtil.writeToMap(this.outputs, true, keys);
        return this;
    }

    @Override
    public Pipe build() throws PersistenceException {
        return this.build(this.plumber.generateUniquePath());
    }

    Resource persistStep(String path, String parentType, Step step) throws PersistenceException {
        Resource resource = this.createResource(this.resolver, path, parentType, step.properties);
        ModifiableValueMap mvm = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
        if (StringUtils.isNotBlank((CharSequence)step.name) && mvm != null) {
            mvm.put((Object)"name", (Object)step.name);
        }
        for (Map.Entry<String, Map<String, Object>> entry : step.confs.entrySet()) {
            this.createResource(this.resolver, path + "/" + entry.getKey(), "sling:Folder", entry.getValue());
            logger.debug("built pipe {}'s {} node", (Object)path, (Object)entry.getKey());
        }
        return resource;
    }

    @Override
    public Pipe build(String path) throws PersistenceException {
        Resource pipeResource = this.persistStep(path, "sling:Folder", this.containerStep);
        if (this.outputs != null) {
            ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)(path + "/" + "writer"), this.outputs, (String)"sling:Folder", (boolean)false);
        }
        int index = 0;
        for (Step step : this.steps) {
            String name;
            String string = name = DEFAULT_NAMES.length > index ? DEFAULT_NAMES[index] : Integer.toString(index);
            if (StringUtils.isNotBlank((CharSequence)step.name)) {
                name = step.name;
            }
            ++index;
            this.persistStep(path + "/" + "conf" + "/" + name, "sling:OrderedFolder", step);
        }
        this.resolver.commit();
        logger.debug("built pipe under {}", (Object)path);
        return this.plumber.getPipe(pipeResource);
    }

    @Override
    public ExecutionResult run() {
        return this.run(null);
    }

    @Override
    public ExecutionResult runWith(Object ... bindings) {
        CommandUtil.checkArguments(bindings);
        HashMap<String, Object> bindingsMap = new HashMap<String, Object>();
        CommandUtil.writeToMap(bindingsMap, true, bindings);
        return this.run(bindingsMap);
    }

    @Override
    public ExecutionResult run(Map<String, Object> bindings) {
        JsonWriter writer = new JsonWriter();
        try {
            writer.starts();
            Pipe pipe = this.build();
            return this.plumber.execute(this.resolver, pipe, bindings, (OutputWriter)writer, true);
        }
        catch (PersistenceException e) {
            logger.error("unable to build the pipe", (Throwable)e);
            return new ExecutionResult(writer);
        }
    }

    @Override
    public Job runAsync(Map<String, Object> bindings) throws PersistenceException {
        Pipe pipe = this.build();
        return this.plumber.executeAsync(this.resolver, pipe.getResource().getPath(), bindings);
    }

    @Override
    public ExecutionResult runParallel(int numThreads, Map<String, Object> additionalBindings) {
        this.containerStep.setType("slingPipes/manifold");
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("numThreads", numThreads);
        if (additionalBindings != null) {
            bindings.putAll(additionalBindings);
        }
        return this.run(bindings);
    }

    public class Step {
        String name;
        Map<String, Object> bindings;
        Map<String, Object> properties;
        Map<String, Map<String, Object>> confs = new HashMap<String, Map<String, Object>>();

        Step(String type) {
            this.properties = new HashMap<String, Object>();
            this.setType(type);
        }

        void setType(String type) {
            this.properties.put("sling:resourceType", type);
        }
    }
}

