/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.mapping;

import java.io.IOException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.resourceresolver.impl.ResourceResolverMetrics;
import org.apache.sling.resourceresolver.impl.mapping.AliasHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.apache.sling.resourceresolver.impl.mapping.MapEntriesHandler;
import org.apache.sling.resourceresolver.impl.mapping.MapEntry;
import org.apache.sling.resourceresolver.impl.mapping.MapEntryIterator;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.mapping.StringInterpolationProvider;
import org.apache.sling.resourceresolver.impl.mapping.VanityPathHandler;
import org.jetbrains.annotations.NotNull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries
implements MapEntriesHandler,
ResourceChangeListener,
ExternalResourceChangeListener {
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_CONTENT_SUFFIX = "/jcr:content";
    private static final String PROP_REG_EXP = "sling:match";
    public static final String PROP_REDIRECT_EXTERNAL = "sling:redirect";
    public static final String PROP_REDIRECT_EXTERNAL_STATUS = "sling:status";
    private static final String GLOBAL_LIST_KEY = "*";
    public static final String DEFAULT_MAP_ROOT = "/etc/map";
    public static final int DEFAULT_DEFAULT_VANITY_PATH_REDIRECT_STATUS = 302;
    private static final String JCR_SYSTEM_PATH = "/jcr:system";
    private static final String JCR_SYSTEM_PREFIX = "/jcr:system/";
    static final String ANY_SCHEME_HOST = "[^/]+/[^/]+";
    private final Logger log = LoggerFactory.getLogger(MapEntries.class);
    private volatile MapConfigurationProvider factory;
    private volatile ResourceResolver resolver;
    private volatile EventAdmin eventAdmin;
    private volatile ServiceRegistration<ResourceChangeListener> registration;
    private final Map<String, List<MapEntry>> resolveMapsMap;
    private final List<Map.Entry<String, ResourceChange.ChangeType>> resourceChangeQueueForAliases;
    private final List<Map.Entry<String, ResourceChange.ChangeType>> resourceChangeQueueForVanityPaths;
    private Collection<MapEntry> mapMaps;
    private final ReentrantLock initializing = new ReentrantLock();
    private final StringInterpolationProvider stringInterpolationProvider;
    AliasHandler ah;
    VanityPathHandler vph;
    private final Set<ResourceChange.ChangeType> RELEVANT_CHANGE_TYPES = Set.of(ResourceChange.ChangeType.ADDED, ResourceChange.ChangeType.CHANGED, ResourceChange.ChangeType.REMOVED);

    public MapEntries(MapConfigurationProvider factory, BundleContext bundleContext, EventAdmin eventAdmin, StringInterpolationProvider stringInterpolationProvider, Optional<ResourceResolverMetrics> metrics) throws LoginException, IOException {
        this.resolver = factory.getServiceResourceResolver(factory.getServiceUserAuthenticationInfo("mapping"));
        this.factory = factory;
        this.eventAdmin = eventAdmin;
        this.resolveMapsMap = new ConcurrentHashMap(Map.of(GLOBAL_LIST_KEY, List.of()));
        this.resourceChangeQueueForAliases = Collections.synchronizedList(new LinkedList());
        this.resourceChangeQueueForVanityPaths = Collections.synchronizedList(new LinkedList());
        this.mapMaps = Collections.emptyList();
        this.stringInterpolationProvider = stringInterpolationProvider;
        this.ah = new AliasHandler(this.factory, this.initializing, this::doUpdateConfiguration, this::sendChangeEvent, this::drainAliasQueue);
        this.ah.initializeAliases();
        this.registration = this.registerResourceChangeListener(bundleContext);
        this.vph = new VanityPathHandler(this.factory, this.resolveMapsMap, this.initializing, this::drainVanityPathQueue);
        this.vph.initializeVanityPaths();
        if (metrics.isPresent()) {
            metrics.get().setNumberOfDetectedConflictingAliasesSupplier(this.ah.detectedConflictingAliases::get);
            metrics.get().setNumberOfDetectedInvalidAliasesSupplier(this.ah.detectedInvalidAliases::get);
            metrics.get().setNumberOfResourcesWithAliasedChildrenSupplier(() -> this.ah.aliasMapsMap.size());
            metrics.get().setNumberOfResourcesWithAliasesOnStartupSupplier(this.ah.aliasResourcesOnStartup::get);
            metrics.get().setNumberOfResourcesWithVanityPathsOnStartupSupplier(this.vph.vanityResourcesOnStartup::get);
            metrics.get().setNumberOfVanityPathBloomFalsePositivesSupplier(this.vph.vanityPathBloomFalsePositives::get);
            metrics.get().setNumberOfVanityPathBloomNegativesSupplier(this.vph.vanityPathBloomNegatives::get);
            metrics.get().setNumberOfVanityPathLookupsSupplier(this.vph.vanityPathLookups::get);
            metrics.get().setNumberOfVanityPathsSupplier(this.vph.vanityCounter::get);
        }
    }

    private ServiceRegistration<ResourceChangeListener> registerResourceChangeListener(BundleContext bundleContext) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        String[] paths = new String[this.factory.getObservationPaths().length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.factory.getObservationPaths()[i].getPath();
        }
        ((Dictionary)props).put("resource.paths", paths);
        ((Dictionary)props).put("service.description", "Apache Sling Map Entries Observation");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        this.log.info("Registering for {}", (Object)Arrays.toString(this.factory.getObservationPaths()));
        this.resourceChangeQueueForAliases.clear();
        this.resourceChangeQueueForVanityPaths.clear();
        return bundleContext.registerService(ResourceChangeListener.class, (Object)this, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addResource(ChangeContext ctx, AtomicBoolean resolverRefreshed) {
        this.initializing.lock();
        try {
            Resource resource;
            this.refreshResolverIfNecessary(resolverRefreshed);
            Resource resource2 = resource = this.resolver != null ? this.resolver.getResource(ctx.path) : null;
            if (resource != null) {
                boolean vanityPathAdded = ctx.forVanityPath && this.vph.doAddVanity(resource);
                boolean aliasAdded = ctx.forAlias && this.ah.doAddAlias(resource);
                boolean bl = vanityPathAdded || aliasAdded;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.initializing.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateResource(ChangeContext ctx, AtomicBoolean resolverRefreshed) {
        this.initializing.lock();
        try {
            this.refreshResolverIfNecessary(resolverRefreshed);
            Resource resource = this.resolver != null ? this.resolver.getResource(ctx.path) : null;
            boolean isValidVanityPath = this.vph.isValidVanityPath(ctx.path);
            if (resource != null) {
                boolean vanityPathChanged = false;
                if (ctx.forVanityPath && isValidVanityPath) {
                    vanityPathChanged |= this.vph.doRemoveVanity(ctx.path);
                    Resource contentRsrc = null;
                    if (!resource.getName().equals(JCR_CONTENT)) {
                        contentRsrc = resource.getChild(JCR_CONTENT);
                    }
                    vanityPathChanged |= this.vph.doAddVanity(contentRsrc != null ? contentRsrc : resource);
                }
                boolean aliasChanged = ctx.forAlias && this.ah.doUpdateAlias(resource);
                boolean bl = vanityPathChanged || aliasChanged;
                return bl;
            }
        }
        finally {
            this.initializing.unlock();
        }
        return false;
    }

    private boolean removeResource(ChangeContext ctx, AtomicBoolean resolverRefreshed) {
        boolean vanityPathChanged = false;
        boolean aliasChanged = false;
        if (ctx.forAlias) {
            String pathPrefix = ctx.path + "/";
            for (String contentPath : this.ah.aliasMapsMap.keySet()) {
                if (!ctx.path.startsWith(contentPath + "/") && !ctx.path.equals(contentPath) && !contentPath.startsWith(pathPrefix)) continue;
                aliasChanged |= this.ah.removeAlias(this.resolver, contentPath, ctx.path, () -> this.refreshResolverIfNecessary(resolverRefreshed));
            }
        }
        if (ctx.forVanityPath) {
            String actualContentPath = this.getActualContentPath(ctx.path);
            String actualContentPathPrefix = actualContentPath + "/";
            for (String target : this.vph.getVanityPathMappings().keySet()) {
                if (!target.startsWith(actualContentPathPrefix) && !target.equals(actualContentPath)) continue;
                vanityPathChanged |= this.vph.removeVanityPath(target);
            }
        }
        return vanityPathChanged || aliasChanged;
    }

    private void doUpdateConfiguration() {
        ArrayList<MapEntry> globalResolveMap = new ArrayList<MapEntry>();
        TreeMap<String, MapEntry> newMapMaps = new TreeMap<String, MapEntry>();
        this.loadResolverMap(this.resolver, globalResolveMap, newMapMaps);
        this.loadConfiguration(this.factory, globalResolveMap);
        this.loadMapConfiguration(this.factory, newMapMaps);
        Collections.sort(globalResolveMap);
        this.resolveMapsMap.put(GLOBAL_LIST_KEY, globalResolveMap);
        this.mapMaps = Collections.unmodifiableSet(new TreeSet(newMapMaps.values()));
    }

    public void dispose() {
        boolean initLocked;
        if (this.ah != null) {
            this.ah.dispose();
            this.ah = null;
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        try {
            initLocked = this.initializing.tryLock(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            initLocked = false;
        }
        try {
            if (!initLocked) {
                this.log.warn("dispose: Could not acquire initialization lock within 10 seconds; ongoing initialization may fail");
            }
            ResourceResolver oldResolver = this.resolver;
            this.resolver = null;
            if (oldResolver != null) {
                oldResolver.close();
            } else {
                this.log.warn("dispose: ResourceResolver has already been cleared before; duplicate call to dispose ?");
            }
        }
        finally {
            if (initLocked) {
                this.initializing.unlock();
            }
        }
        this.factory = null;
        this.eventAdmin = null;
    }

    @Override
    @NotNull
    public List<MapEntry> getResolveMaps() {
        ArrayList<MapEntry> entries = new ArrayList<MapEntry>();
        for (List<MapEntry> list : this.resolveMapsMap.values()) {
            entries.addAll(list);
        }
        Collections.sort(entries);
        return Collections.unmodifiableList(entries);
    }

    @Override
    @NotNull
    public Iterator<MapEntry> getResolveMapsIterator(String requestPath) {
        String key = null;
        int firstIndex = requestPath.indexOf(47);
        int secondIndex = requestPath.indexOf(47, firstIndex + 1);
        if (secondIndex != -1) {
            key = requestPath.substring(secondIndex);
        }
        return new MapEntryIterator(key, this.resolveMapsMap.get(GLOBAL_LIST_KEY), this.vph::getCurrentMapEntryForVanityPath, this.factory.hasVanityPathPrecedence());
    }

    @Override
    @NotNull
    public Collection<MapEntry> getMapMaps() {
        return this.mapMaps;
    }

    @Override
    @NotNull
    public Map<String, List<String>> getVanityPathMappings() {
        return this.vph.getVanityPathMappings();
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getAliasMap(@NotNull String parentPath) {
        return this.ah.getAliasMap(parentPath);
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getAliasMap(@NotNull Resource parent) {
        return this.ah.getAliasMap(parent);
    }

    private void refreshResolverIfNecessary(AtomicBoolean resolverRefreshed) {
        if (resolverRefreshed.compareAndSet(false, true)) {
            this.resolver.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean handleConfigurationUpdate(String path, AtomicBoolean hasReloadedConfig, AtomicBoolean resolverRefreshed, boolean isDelete) {
        if (this.factory.isMapConfiguration(path) || isDelete && this.factory.getMapRoot().startsWith(path + "/")) {
            if (hasReloadedConfig.compareAndSet(false, true)) {
                this.initializing.lock();
                try {
                    if (this.resolver != null) {
                        this.refreshResolverIfNecessary(resolverRefreshed);
                        this.doUpdateConfiguration();
                    }
                }
                finally {
                    this.initializing.unlock();
                }
                return true;
            }
            return null;
        }
        return false;
    }

    public void onChange(List<ResourceChange> changes) {
        boolean ahInStartup = !this.ah.isReady();
        boolean vphInStartup = !this.vph.isReady();
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        boolean sendEvent = false;
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        for (ResourceChange rc : changes) {
            AbstractMap.SimpleEntry<String, ResourceChange.ChangeType> entry;
            ResourceChange.ChangeType type = rc.getType();
            String path = rc.getPath();
            this.log.debug("onChange, type={}, path={}", (Object)type, (Object)path);
            if (path.startsWith(JCR_SYSTEM_PREFIX)) continue;
            boolean queuedForAlias = false;
            boolean queuedForVanityPath = false;
            if (ahInStartup && this.RELEVANT_CHANGE_TYPES.contains(type)) {
                entry = new AbstractMap.SimpleEntry<String, ResourceChange.ChangeType>(path, type);
                this.log.trace("enqueued for aliases {}", entry);
                this.resourceChangeQueueForAliases.add(entry);
                queuedForAlias = true;
            }
            if (vphInStartup && this.RELEVANT_CHANGE_TYPES.contains(type)) {
                entry = new AbstractMap.SimpleEntry<String, ResourceChange.ChangeType>(path, type);
                this.log.trace("enqueued for vanity paths {}", entry);
                this.resourceChangeQueueForVanityPaths.add(entry);
                queuedForVanityPath = true;
            }
            if (queuedForAlias && queuedForVanityPath) continue;
            sendEvent |= this.handleResourceChange(new ChangeContext(type, path, !queuedForAlias, !queuedForVanityPath), resolverRefreshed, hasReloadedConfig);
        }
        if (sendEvent) {
            this.sendChangeEvent();
        }
    }

    private boolean handleResourceChange(ChangeContext ctx, AtomicBoolean resolverRefreshed, AtomicBoolean hasReloadedConfig) {
        Boolean result;
        boolean changed = false;
        if (ctx.type == ResourceChange.ChangeType.REMOVED) {
            Boolean result2 = this.handleConfigurationUpdate(ctx.path, hasReloadedConfig, resolverRefreshed, true);
            if (result2 != null) {
                changed = result2.booleanValue() ? true : (changed |= this.removeResource(ctx, resolverRefreshed));
            }
        } else if (ctx.type == ResourceChange.ChangeType.ADDED) {
            Boolean result3 = this.handleConfigurationUpdate(ctx.path, hasReloadedConfig, resolverRefreshed, false);
            if (result3 != null) {
                changed = result3.booleanValue() ? true : (changed |= this.addResource(ctx, resolverRefreshed));
            }
        } else if (ctx.type == ResourceChange.ChangeType.CHANGED && (result = this.handleConfigurationUpdate(ctx.path, hasReloadedConfig, resolverRefreshed, false)) != null) {
            changed = result.booleanValue() ? true : (changed |= this.updateResource(ctx, resolverRefreshed));
        }
        return changed;
    }

    private String getActualContentPath(String path) {
        String checkPath = path.endsWith(JCR_CONTENT_SUFFIX) ? ResourceUtil.getParent((String)path) : path;
        return checkPath;
    }

    private void sendChangeEvent() {
        EventAdmin local = this.eventAdmin;
        if (local != null) {
            Event event = new Event("org/apache/sling/api/resource/ResourceResolverMapping/CHANGED", (Dictionary)null);
            local.postEvent(event);
        }
    }

    private void loadResolverMap(ResourceResolver resolver, List<MapEntry> entries, Map<String, MapEntry> mapEntries) {
        Resource res = resolver.getResource(this.factory.getMapRoot());
        if (res != null) {
            this.gather(entries, mapEntries, res, "");
        }
    }

    private void gather(List<MapEntry> entries, Map<String, MapEntry> mapEntries, Resource parent, String parentPath) {
        Iterator children = parent.listChildren();
        while (children.hasNext()) {
            List<MapEntry> childMapEntries;
            String childPath;
            Resource child = (Resource)children.next();
            ValueMap vm = ResourceUtil.getValueMap((Resource)child);
            String name = (String)vm.get(PROP_REG_EXP, String.class);
            boolean trailingSlash = false;
            if (name == null) {
                name = child.getName().concat("/");
                trailingSlash = true;
            }
            if (!(childPath = parentPath.concat(name = this.stringInterpolationProvider.substitute(name))).endsWith("$")) {
                String childParent = childPath;
                if (!trailingSlash) {
                    childParent = childParent.concat("/");
                }
                this.gather(entries, mapEntries, child, childParent);
            }
            MapEntry childResolveEntry = null;
            try {
                childResolveEntry = MapEntry.createResolveEntry(childPath, child, trailingSlash);
            }
            catch (IllegalArgumentException iae) {
                this.log.debug("ignored entry due exception ", (Throwable)iae);
            }
            if (childResolveEntry != null) {
                entries.add(childResolveEntry);
            }
            if ((childMapEntries = MapEntry.createMapEntry(childPath, child, trailingSlash)) == null) continue;
            for (MapEntry mapEntry : childMapEntries) {
                this.addMapEntry(mapEntries, mapEntry.getPattern(), mapEntry.getRedirect()[0], mapEntry.getStatus());
            }
        }
    }

    private void loadConfiguration(MapConfigurationProvider factory, List<MapEntry> entries) {
        Mapping[] mappings;
        Map<String, String> virtuals = factory.getVirtualURLMap();
        if (virtuals != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String string;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(string = virtualEntry.getValue())) continue;
                String url = "^[^/]+/[^/]+" + extPath + "$";
                MapEntry mapEntry = this.getMapEntry(url, -1, string);
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
        if ((mappings = factory.getMappings()) != null) {
            HashMap<String, List> map = new HashMap<String, List>();
            for (Mapping mapping : mappings) {
                if (!mapping.mapsInbound()) continue;
                String url = mapping.getTo();
                String alias = mapping.getFrom();
                if (url.isEmpty()) continue;
                List aliasList = map.computeIfAbsent(url, k -> new ArrayList());
                aliasList.add(alias);
            }
            for (Map.Entry entry : map.entrySet()) {
                MapEntry mapEntry = this.getMapEntry(ANY_SCHEME_HOST + (String)entry.getKey(), -1, ((List)entry.getValue()).toArray(new String[0]));
                if (mapEntry == null) continue;
                entries.add(mapEntry);
            }
        }
    }

    private void loadMapConfiguration(MapConfigurationProvider factory, Map<String, MapEntry> entries) {
        Map<String, String> virtuals;
        Mapping[] mappings = factory.getMappings();
        if (mappings != null) {
            for (int i = mappings.length - 1; i >= 0; --i) {
                String alias;
                String url;
                Mapping mapping = mappings[i];
                if (!mapping.mapsOutbound() || (url = mapping.getTo()).equals(alias = mapping.getFrom())) continue;
                this.addMapEntry(entries, alias, url, -1);
            }
        }
        if ((virtuals = factory.getVirtualURLMap()) != null) {
            for (Map.Entry<String, String> virtualEntry : virtuals.entrySet()) {
                String intPath;
                String extPath = virtualEntry.getKey();
                if (extPath.equals(intPath = virtualEntry.getValue())) continue;
                String path = "^" + intPath + "$";
                this.addMapEntry(entries, path, extPath, -1);
            }
        }
    }

    private void addMapEntry(Map<String, MapEntry> entries, String path, String url, int status) {
        MapEntry entry = entries.get(path);
        if (entry == null) {
            entry = this.getMapEntry(path, status, url);
        } else {
            String[] redir = entry.getRedirect();
            String[] newRedir = new String[redir.length + 1];
            System.arraycopy(redir, 0, newRedir, 0, redir.length);
            newRedir[redir.length] = url;
            entry = this.getMapEntry(entry.getPattern(), entry.getStatus(), newRedir);
        }
        if (entry != null) {
            entries.put(path, entry);
        }
    }

    private MapEntry getMapEntry(String url, int status, String ... redirect) {
        try {
            return new MapEntry(url, status, false, 0L, redirect);
        }
        catch (IllegalArgumentException iae) {
            this.log.debug("ignored entry for {} due to exception", (Object)url, (Object)iae);
            return null;
        }
    }

    private boolean drainSpecificQueue(boolean isAlias, String message, List<Map.Entry<String, ResourceChange.ChangeType>> queue) {
        AtomicBoolean resolverRefreshed = new AtomicBoolean(false);
        AtomicBoolean hasReloadedConfig = new AtomicBoolean(false);
        boolean sendEvent = false;
        int count = 0;
        StopWatch sw = StopWatch.createStarted();
        while (!queue.isEmpty()) {
            ++count;
            Map.Entry<String, ResourceChange.ChangeType> entry = queue.remove(0);
            ResourceChange.ChangeType type = entry.getValue();
            String path = entry.getKey();
            this.log.trace("drain {} queue - type={}, path={}", new Object[]{isAlias ? "alias" : "vanity path", type, path});
            sendEvent |= this.handleResourceChange(new ChangeContext(type, path, isAlias, !isAlias), resolverRefreshed, hasReloadedConfig);
        }
        if (count > 0) {
            this.log.info(MapEntries.getTimingMessage(message, sw.getDuration(), count));
        }
        return sendEvent;
    }

    private void drainAliasQueue(String message) {
        if (this.drainSpecificQueue(true, message, this.resourceChangeQueueForAliases)) {
            this.sendChangeEvent();
        }
    }

    private void drainVanityPathQueue(String message) {
        if (this.drainSpecificQueue(false, message, this.resourceChangeQueueForVanityPaths)) {
            this.sendChangeEvent();
        }
    }

    @NotNull
    static String getTimingMessage(@NotNull String description, @NotNull Duration duration, long operations) {
        StringBuilder result = new StringBuilder(description);
        long nanos = duration.toNanos();
        if (!description.isEmpty()) {
            result.append(": ");
        }
        result.append(String.format("%s (%d ms) - %d operations", duration, TimeUnit.NANOSECONDS.toMillis(nanos), operations));
        if (operations > 0L) {
            long operationsPerSecond = operations * TimeUnit.SECONDS.toNanos(1L) / (nanos == 0L ? 1L : nanos);
            result.append(String.format(" (~ %d operations/s)", operationsPerSecond));
        }
        return result.toString();
    }

    static class ChangeContext {
        final ResourceChange.ChangeType type;
        final String path;
        final boolean forAlias;
        final boolean forVanityPath;

        public ChangeContext(ResourceChange.ChangeType type, String path, boolean forAlias, boolean forVanityPath) {
            this.type = type;
            this.path = path;
            this.forAlias = forAlias;
            this.forVanityPath = forVanityPath;
        }

        public ChangeContext(String path, boolean forAlias, boolean forVanityPath) {
            this(null, path, forAlias, forVanityPath);
        }
    }
}

