/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.delegate;

import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.jcr.delegate.NodeDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.PropertyDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.SessionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionDelegate;
import org.apache.jackrabbit.oak.jcr.delegate.VersionHistoryDelegate;
import org.apache.jackrabbit.oak.jcr.version.ReadWriteVersionManager;
import org.apache.jackrabbit.oak.jcr.version.VersionStorage;
import org.jetbrains.annotations.NotNull;
import sling-mock-oak.com.google.common.base.Preconditions;

public final class VersionManagerDelegate {
    private final SessionDelegate sessionDelegate;
    private final ReadWriteVersionManager versionManager;

    public static VersionManagerDelegate create(SessionDelegate sessionDelegate) {
        return new VersionManagerDelegate(sessionDelegate);
    }

    private VersionManagerDelegate(SessionDelegate sessionDelegate) {
        this.sessionDelegate = sessionDelegate;
        this.versionManager = new ReadWriteVersionManager(sessionDelegate);
    }

    @NotNull
    public VersionDelegate checkin(@NotNull NodeDelegate nodeDelegate) throws RepositoryException {
        return VersionDelegate.create(this.sessionDelegate, this.versionManager.checkin(VersionManagerDelegate.getTree(nodeDelegate)));
    }

    public void checkout(@NotNull NodeDelegate nodeDelegate) throws RepositoryException {
        Root fresh = this.sessionDelegate.getContentSession().getLatestRoot();
        this.versionManager.checkout(fresh, nodeDelegate.getPath());
    }

    public boolean isCheckedOut(@NotNull NodeDelegate nodeDelegate) throws RepositoryException {
        return this.versionManager.isCheckedOut(VersionManagerDelegate.getTree(nodeDelegate));
    }

    @NotNull
    public VersionHistoryDelegate createVersionHistory(@NotNull NodeDelegate versionHistory) throws RepositoryException {
        return new VersionHistoryDelegate(this.sessionDelegate, VersionManagerDelegate.getTree(versionHistory));
    }

    @NotNull
    public VersionDelegate createVersion(@NotNull NodeDelegate version) throws RepositoryException {
        return VersionDelegate.create(this.sessionDelegate, VersionManagerDelegate.getTree(version));
    }

    @NotNull
    public VersionHistoryDelegate getVersionHistory(@NotNull NodeDelegate versionable) throws RepositoryException {
        Tree vh = this.versionManager.getVersionHistory(VersionManagerDelegate.getTree(versionable));
        if (vh == null) {
            throw new UnsupportedRepositoryOperationException("Node does not have a version history: " + versionable.getPath());
        }
        return new VersionHistoryDelegate(this.sessionDelegate, vh);
    }

    @NotNull
    public VersionDelegate getBaseVersion(@NotNull NodeDelegate versionable) throws RepositoryException {
        Tree v = this.versionManager.getBaseVersion(VersionManagerDelegate.getTree(versionable));
        if (v == null) {
            throw new UnsupportedRepositoryOperationException("Node does not have a base version: " + versionable.getPath());
        }
        return VersionDelegate.create(this.sessionDelegate, v);
    }

    @NotNull
    public VersionDelegate getVersionByIdentifier(@NotNull String identifier) throws RepositoryException {
        Tree t = this.sessionDelegate.getIdManager().getTree(identifier);
        if (t == null || !t.exists()) {
            throw new RepositoryException("No such Version with identifier: " + identifier);
        }
        return VersionDelegate.create(this.sessionDelegate, t);
    }

    public void restore(@NotNull NodeDelegate parent, @NotNull String oakName, @NotNull VersionDelegate vd) throws RepositoryException {
        NodeDelegate frozen = vd.getFrozenNode();
        PropertyState primaryType = frozen.getProperty("jcr:frozenPrimaryType").getPropertyState();
        PropertyState uuid = frozen.getProperty("jcr:frozenUuid").getPropertyState();
        PropertyDelegate mixinTypes = frozen.getPropertyOrNull("jcr:frozenMixinTypes");
        if (parent.getChild(oakName) == null) {
            Tree t = parent.getTree().addChild(oakName);
            t.setProperty("jcr:primaryType", primaryType.getValue(Type.NAME), Type.NAME);
            t.setProperty("jcr:uuid", uuid.getValue(Type.STRING), Type.STRING);
            if (mixinTypes != null && mixinTypes.getPropertyState().count() > 0) {
                t.setProperty("jcr:mixinTypes", mixinTypes.getPropertyState().getValue(Type.NAMES), Type.NAMES);
            }
            t.setProperty("jcr:baseVersion", vd.getIdentifier(), Type.REFERENCE);
            t.setProperty("jcr:versionHistory", vd.getParent().getIdentifier(), Type.REFERENCE);
        } else {
            Tree t = parent.getChild(oakName).getTree();
            t.setProperty("jcr:baseVersion", "restore-" + vd.getIdentifier(), Type.REFERENCE);
        }
    }

    public void addVersionLabel(@NotNull VersionHistoryDelegate versionHistory, @NotNull VersionDelegate version, @NotNull String oakVersionLabel, boolean moveLabel) throws InvalidItemStateException, LabelExistsVersionException, VersionException, RepositoryException {
        Root fresh = this.sessionDelegate.getContentSession().getLatestRoot();
        VersionStorage storage = new VersionStorage(fresh);
        String vhRelPath = PathUtils.relativize("/jcr:system/jcr:versionStorage", Preconditions.checkNotNull(versionHistory).getPath());
        this.versionManager.addVersionLabel(storage, vhRelPath, Preconditions.checkNotNull(version).getIdentifier(), Preconditions.checkNotNull(oakVersionLabel), moveLabel);
    }

    public void removeVersionLabel(@NotNull VersionHistoryDelegate versionHistory, @NotNull String oakVersionLabel) throws InvalidItemStateException, VersionException, RepositoryException {
        Root fresh = this.sessionDelegate.getContentSession().getLatestRoot();
        VersionStorage storage = new VersionStorage(fresh);
        String vhRelPath = PathUtils.relativize("/jcr:system/jcr:versionStorage", Preconditions.checkNotNull(versionHistory).getPath());
        this.versionManager.removeVersionLabel(storage, vhRelPath, Preconditions.checkNotNull(oakVersionLabel));
    }

    public void removeVersion(@NotNull VersionHistoryDelegate versionHistory, @NotNull String oakVersionName) throws RepositoryException {
        Root fresh = this.sessionDelegate.getContentSession().getLatestRoot();
        VersionStorage storage = new VersionStorage(fresh);
        String vhRelPath = PathUtils.relativize("/jcr:system/jcr:versionStorage", Preconditions.checkNotNull(versionHistory).getPath());
        this.versionManager.removeVersion(storage, vhRelPath, oakVersionName);
    }

    @NotNull
    private static Tree getTree(@NotNull NodeDelegate nodeDelegate) throws InvalidItemStateException {
        return Preconditions.checkNotNull(nodeDelegate).getTree();
    }
}

