/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index;

import org.apache.jackrabbit.oak.plugins.index.CorruptIndexHandler;
import org.apache.jackrabbit.oak.plugins.index.IndexEditorProvider;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.NodeTraversalCallback;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.commit.EditorProvider;
import org.apache.jackrabbit.oak.spi.commit.VisibleEditor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexUpdateProvider
implements EditorProvider {
    private static final IndexUpdateCallback NOOP_CALLBACK = new IndexUpdateCallback(){

        @Override
        public void indexUpdate() {
        }
    };
    private final IndexEditorProvider provider;
    private final String async;
    private final IndexUpdate.MissingIndexProviderStrategy missingStrategy;
    private CorruptIndexHandler corruptIndexHandler = CorruptIndexHandler.NOOP;
    private boolean ignoreReindexFlags = IndexUpdate.IGNORE_REINDEX_FLAGS;

    public IndexUpdateProvider(IndexEditorProvider provider, boolean failOnMissingIndexProvider) {
        this(provider, null, failOnMissingIndexProvider);
    }

    public IndexUpdateProvider(IndexEditorProvider provider) {
        this(provider, null, false);
    }

    public IndexUpdateProvider(@NotNull IndexEditorProvider provider, @Nullable String async, boolean failOnMissingIndexProvider) {
        this.provider = provider;
        this.async = async;
        this.missingStrategy = new IndexUpdate.MissingIndexProviderStrategy();
        this.missingStrategy.setFailOnMissingIndexProvider(failOnMissingIndexProvider);
    }

    @Override
    @Nullable
    public Editor getRootEditor(NodeState before, NodeState after, NodeBuilder builder, CommitInfo info) {
        IndexUpdate editor = new IndexUpdate(this.provider, this.async, after, builder, NOOP_CALLBACK, NodeTraversalCallback.NOOP, info, this.corruptIndexHandler).withMissingProviderStrategy(this.missingStrategy);
        editor.setIgnoreReindexFlags(this.ignoreReindexFlags);
        return VisibleEditor.wrap(editor);
    }

    public void setCorruptIndexHandler(CorruptIndexHandler corruptIndexHandler) {
        this.corruptIndexHandler = corruptIndexHandler;
    }

    public void setIgnoreReindexFlags(boolean ignoreReindexFlags) {
        this.ignoreReindexFlags = ignoreReindexFlags;
    }
}

