/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authorization.permission;

import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.tree.TreeProvider;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.ChildOrderDiff;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionUtil;
import org.apache.jackrabbit.oak.security.authorization.permission.PermissionValidatorProvider;
import org.apache.jackrabbit.oak.spi.commit.DefaultValidator;
import org.apache.jackrabbit.oak.spi.commit.Validator;
import org.apache.jackrabbit.oak.spi.commit.VisibleValidator;
import org.apache.jackrabbit.oak.spi.lock.LockConstants;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.PermissionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.Permissions;
import org.apache.jackrabbit.oak.spi.security.authorization.permission.TreePermission;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.apache.jackrabbit.oak.spi.version.VersionConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sling-mock-oak.com.google.common.base.Preconditions;

class PermissionValidator
extends DefaultValidator {
    private final Tree parentBefore;
    private final Tree parentAfter;
    private final TreePermission parentPermission;
    private final PermissionProvider permissionProvider;
    private final PermissionValidatorProvider provider;
    private final TypePredicate isReferenceable;
    private final TypePredicate isCreated;
    private final long permission;

    PermissionValidator(@NotNull NodeState rootBefore, @NotNull NodeState rootAfter, @NotNull PermissionProvider permissionProvider, @NotNull PermissionValidatorProvider provider) {
        this.parentBefore = provider.createReadOnlyTree(rootBefore);
        this.parentAfter = provider.createReadOnlyTree(rootAfter);
        this.parentPermission = permissionProvider.getTreePermission(this.parentBefore, TreePermission.EMPTY);
        this.permissionProvider = permissionProvider;
        this.provider = provider;
        this.isReferenceable = new TypePredicate(rootAfter, "mix:referenceable");
        this.isCreated = new TypePredicate(rootAfter, "mix:created");
        this.permission = Permissions.getPermission(PermissionUtil.getPath(this.parentBefore, this.parentAfter), 0L);
    }

    PermissionValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @Nullable TreePermission parentPermission, @NotNull PermissionValidator parentValidator) {
        this.parentBefore = parentBefore;
        this.parentAfter = parentAfter;
        this.parentPermission = parentPermission;
        this.permissionProvider = parentValidator.permissionProvider;
        this.provider = parentValidator.provider;
        this.isReferenceable = parentValidator.isReferenceable;
        this.isCreated = parentValidator.isCreated;
        this.permission = 0L == parentValidator.permission ? Permissions.getPermission(PermissionUtil.getPath(parentBefore, parentAfter), 0L) : parentValidator.permission;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        String name = after.getName();
        if (!":childOrder".equals(name) && !this.isImmutableProperty(name, this.parentAfter)) {
            this.checkPermissions(this.parentAfter, after, 4L);
        }
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        String name = after.getName();
        if (":childOrder".equals(name)) {
            String childName = ChildOrderDiff.firstReordered(before, after);
            if (childName != null) {
                this.checkPermissions(this.parentAfter, false, 16384L);
            }
        } else if (this.isImmutableProperty(name, this.parentAfter)) {
            this.checkPermissions(this.parentAfter, false, 96L);
        } else {
            this.checkPermissions(this.parentAfter, after, 8L);
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        String name = before.getName();
        if (!":childOrder".equals(name) && !this.isImmutableProperty(name, this.parentBefore)) {
            this.checkPermissions(this.parentBefore, before, 16L);
        }
    }

    @Override
    public Validator childNodeAdded(String name, NodeState after) throws CommitFailedException {
        Tree child = Preconditions.checkNotNull(this.parentAfter.getChild(name));
        if (this.isVersionstorageTree(child) && (child = this.getVersionHistoryTree(child)) == null) {
            throw new CommitFailedException("Access", 21, "New version storage node without version history: cannot verify permissions.");
        }
        return this.checkPermissions(child, false, 32L);
    }

    @Override
    public Validator childNodeChanged(String name, NodeState before, NodeState after) {
        Tree childBefore = this.parentBefore.getChild(name);
        Tree childAfter = this.parentAfter.getChild(name);
        return this.nextValidator(childBefore, childAfter, this.parentPermission.getChildPermission(name, before));
    }

    @Override
    public Validator childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        Tree child = this.parentBefore.getChild(name);
        if (this.isVersionstorageTree(child)) {
            throw new CommitFailedException("Access", 22, "Attempt to remove versionstorage node: Fail to verify delete permission.");
        }
        return this.checkPermissions(child, true, 64L);
    }

    @NotNull
    PermissionValidator createValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @NotNull TreePermission parentPermission, @NotNull PermissionValidator parentValidator) {
        return new PermissionValidator(parentBefore, parentAfter, parentPermission, parentValidator);
    }

    @Nullable
    Tree getParentAfter() {
        return this.parentAfter;
    }

    @Nullable
    Tree getParentBefore() {
        return this.parentBefore;
    }

    @NotNull
    PermissionProvider getPermissionProvider() {
        return this.permissionProvider;
    }

    @NotNull
    TreeProvider getTreeProvider() {
        return this.provider.getTreeProvider();
    }

    @Nullable
    Validator checkPermissions(@NotNull Tree tree, boolean isBefore, long defaultPermission) throws CommitFailedException {
        long toTest = this.getPermission(tree, defaultPermission);
        if (Permissions.isRepositoryPermission(toTest)) {
            if (!this.permissionProvider.getRepositoryPermission().isGranted(toTest)) {
                throw new CommitFailedException("Access", 0, "Access denied");
            }
            return null;
        }
        NodeState ns = this.provider.getTreeProvider().asNodeState(tree);
        TreePermission tp = this.parentPermission.getChildPermission(tree.getName(), ns);
        if (!tp.isGranted(toTest)) {
            throw new CommitFailedException("Access", 0, "Access denied");
        }
        if (this.noTraverse(toTest, defaultPermission)) {
            return null;
        }
        return isBefore ? this.nextValidator(tree, null, tp) : this.nextValidator(null, tree, tp);
    }

    private void checkPermissions(@NotNull Tree parent, @NotNull PropertyState property, long defaultPermission) throws CommitFailedException {
        boolean isGranted;
        if (NodeStateUtils.isHidden(property.getName())) {
            return;
        }
        long toTest = this.getPermission(parent, property, defaultPermission);
        if (toTest != 0L && !(isGranted = Permissions.isRepositoryPermission(toTest) ? this.permissionProvider.getRepositoryPermission().isGranted(toTest) : this.parentPermission.isGranted(toTest, property))) {
            throw new CommitFailedException("Access", 0, "Access denied");
        }
    }

    @NotNull
    private Validator nextValidator(@Nullable Tree parentBefore, @Nullable Tree parentAfter, @NotNull TreePermission treePermission) {
        PermissionValidator validator = this.createValidator(parentBefore, parentAfter, treePermission, this);
        return new VisibleValidator(validator, true, false);
    }

    private long getPermission(@NotNull Tree tree, long defaultPermission) {
        if (this.permission != 0L) {
            return this.permission;
        }
        long perm = this.testAccessControlPermission(tree) ? 256L : (this.testUserPermission(tree) ? 524288L : (this.isIndexDefinition(tree) ? 0x100000L : defaultPermission));
        return perm;
    }

    private long getPermission(@NotNull Tree parent, @NotNull PropertyState propertyState, long defaultPermission) {
        if (this.permission != 0L) {
            return this.permission;
        }
        String name = propertyState.getName();
        long perm = "jcr:primaryType".equals(name) ? (defaultPermission == 8L ? this.getPermission(parent, 512L) : 0L) : ("jcr:mixinTypes".equals(name) ? 512L : (LockConstants.LOCK_PROPERTY_NAMES.contains(name) ? 2048L : (VersionConstants.VERSION_PROPERTY_NAMES.contains(name) ? 1024L : (this.provider.getAccessControlContext().definesProperty(parent, propertyState) ? 256L : (this.provider.getUserContext().definesProperty(parent, propertyState) && !this.provider.requiresJr2Permissions(524288L) ? 524288L : (this.isIndexDefinition(parent) ? 0x100000L : defaultPermission))))));
        return perm;
    }

    private boolean noTraverse(long permission, long defaultPermission) {
        if (defaultPermission == 64L && this.provider.requiresJr2Permissions(64L)) {
            return false;
        }
        return permission == 256L || permission == 1024L || permission == 64L || defaultPermission == 64L;
    }

    private boolean isImmutableProperty(@NotNull String name, @NotNull Tree parent) {
        NodeState parentNs = this.provider.getTreeProvider().asNodeState(parent);
        if ("jcr:uuid".equals(name) && this.isReferenceable.test(parentNs)) {
            return true;
        }
        return ("jcr:created".equals(name) || "jcr:createdBy".equals(name)) && this.isCreated.test(parentNs);
    }

    private boolean testUserPermission(@NotNull Tree tree) {
        return this.provider.getUserContext().definesTree(tree) && !this.provider.requiresJr2Permissions(524288L);
    }

    private boolean testAccessControlPermission(@NotNull Tree tree) {
        return this.provider.getAccessControlContext().definesTree(tree);
    }

    private boolean isVersionstorageTree(@NotNull Tree tree) {
        return this.permission == 1024L && "rep:versionStorage".equals(TreeUtil.getPrimaryTypeName(tree));
    }

    @Nullable
    private Tree getVersionHistoryTree(@NotNull Tree versionstorageTree) throws CommitFailedException {
        Tree versionHistory = null;
        for (Tree child : versionstorageTree.getChildren()) {
            if ("nt:versionHistory".equals(TreeUtil.getPrimaryTypeName(child))) {
                versionHistory = child;
                continue;
            }
            if (this.isVersionstorageTree(child)) {
                versionHistory = this.getVersionHistoryTree(child);
                continue;
            }
            throw new CommitFailedException("Misc", 0, "unexpected node");
        }
        return versionHistory;
    }

    private boolean isIndexDefinition(@NotNull Tree tree) {
        return tree.getPath().contains("oak:index");
    }
}

