/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import javax.jcr.Value;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.QueryBuilder;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.security.user.query.Condition;
import org.apache.jackrabbit.oak.security.user.query.RelationOp;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class XPathQueryBuilder
implements QueryBuilder<Condition> {
    private AuthorizableType selectorType = AuthorizableType.AUTHORIZABLE;
    private String groupID;
    private boolean declaredMembersOnly;
    private Condition condition;
    private String sortProperty;
    private QueryBuilder.Direction sortDirection = QueryBuilder.Direction.ASCENDING;
    private boolean sortIgnoreCase;
    private Value bound;
    private long offset;
    private long maxCount = Long.MAX_VALUE;

    XPathQueryBuilder() {
    }

    @Override
    public void setSelector(@NotNull Class<? extends Authorizable> selector) {
        this.selectorType = User.class.isAssignableFrom(selector) ? AuthorizableType.USER : (Group.class.isAssignableFrom(selector) ? AuthorizableType.GROUP : AuthorizableType.AUTHORIZABLE);
    }

    @Override
    public void setScope(@NotNull String groupID, boolean declaredOnly) {
        this.groupID = groupID;
        this.declaredMembersOnly = declaredOnly;
    }

    @Override
    public void setCondition(@NotNull Condition condition) {
        this.condition = condition;
    }

    @Override
    public void setSortOrder(@NotNull String propertyName, @NotNull QueryBuilder.Direction direction, boolean ignoreCase) {
        this.sortProperty = propertyName;
        this.sortDirection = direction;
        this.sortIgnoreCase = ignoreCase;
    }

    @Override
    public void setSortOrder(@NotNull String propertyName, @NotNull QueryBuilder.Direction direction) {
        this.setSortOrder(propertyName, direction, false);
    }

    @Override
    public void setLimit(@Nullable Value bound, long maxCount) {
        this.offset = 0L;
        this.bound = bound;
        this.setMaxCount(maxCount);
    }

    @Override
    public void setLimit(long offset, long maxCount) {
        this.bound = null;
        this.offset = offset;
        this.setMaxCount(maxCount);
    }

    @Override
    @NotNull
    public Condition nameMatches(@NotNull String pattern) {
        return new Condition.Node(pattern);
    }

    @Override
    @NotNull
    public Condition neq(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.NE, value);
    }

    @Override
    @NotNull
    public Condition eq(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.EQ, value);
    }

    @Override
    @NotNull
    public Condition lt(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.LT, value);
    }

    @Override
    @NotNull
    public Condition le(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.LE, value);
    }

    @Override
    @NotNull
    public Condition gt(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.GT, value);
    }

    @Override
    @NotNull
    public Condition ge(@NotNull String relPath, @NotNull Value value) {
        return new Condition.Property(relPath, RelationOp.GE, value);
    }

    @Override
    @NotNull
    public Condition exists(@NotNull String relPath) {
        return new Condition.Property(relPath, RelationOp.EX);
    }

    @Override
    @NotNull
    public Condition like(@NotNull String relPath, @NotNull String pattern) {
        return new Condition.Property(relPath, RelationOp.LIKE, pattern);
    }

    @Override
    @NotNull
    public Condition contains(@NotNull String relPath, @NotNull String searchExpr) {
        return new Condition.Contains(relPath, searchExpr);
    }

    @Override
    @NotNull
    public Condition impersonates(@NotNull String name) {
        return new Condition.Impersonation(name);
    }

    @Override
    @NotNull
    public Condition not(@NotNull Condition condition) {
        return new Condition.Not(condition);
    }

    @Override
    @NotNull
    public Condition and(@NotNull Condition condition1, @NotNull Condition condition2) {
        return new Condition.And(condition1, condition2);
    }

    @Override
    @NotNull
    public Condition or(@NotNull Condition condition1, @NotNull Condition condition2) {
        return new Condition.Or(condition1, condition2);
    }

    Condition property(String relPath, RelationOp op, Value value) {
        return new Condition.Property(relPath, op, value);
    }

    AuthorizableType getSelectorType() {
        return this.selectorType;
    }

    String getGroupID() {
        return this.groupID;
    }

    boolean isDeclaredMembersOnly() {
        return this.declaredMembersOnly;
    }

    Condition getCondition() {
        return this.condition;
    }

    String getSortProperty() {
        return this.sortProperty;
    }

    QueryBuilder.Direction getSortDirection() {
        return this.sortDirection;
    }

    boolean getSortIgnoreCase() {
        return this.sortIgnoreCase;
    }

    Value getBound() {
        return this.bound;
    }

    long getOffset() {
        return this.offset;
    }

    long getMaxCount() {
        return this.maxCount;
    }

    private void setMaxCount(long maxCount) {
        this.maxCount = maxCount == -1L ? Long.MAX_VALUE : maxCount;
    }
}

