/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ThreeWayConflictHandler;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public interface SecurityConfiguration {
    @NotNull
    public String getName();

    @NotNull
    public ConfigurationParameters getParameters();

    @NotNull
    public WorkspaceInitializer getWorkspaceInitializer();

    @NotNull
    public RepositoryInitializer getRepositoryInitializer();

    @NotNull
    public List<? extends CommitHook> getCommitHooks(@NotNull String var1);

    @NotNull
    public List<? extends ValidatorProvider> getValidators(@NotNull String var1, @NotNull Set<Principal> var2, @NotNull MoveTracker var3);

    @NotNull
    public List<ThreeWayConflictHandler> getConflictHandlers();

    @NotNull
    public List<ProtectedItemImporter> getProtectedItemImporters();

    @NotNull
    public Context getContext();

    public static class Default
    implements SecurityConfiguration {
        @Override
        @NotNull
        public String getName() {
            return "org.apache.jackrabbit.oak";
        }

        @Override
        @NotNull
        public ConfigurationParameters getParameters() {
            return ConfigurationParameters.EMPTY;
        }

        @Override
        @NotNull
        public WorkspaceInitializer getWorkspaceInitializer() {
            return WorkspaceInitializer.DEFAULT;
        }

        @Override
        @NotNull
        public RepositoryInitializer getRepositoryInitializer() {
            return RepositoryInitializer.DEFAULT;
        }

        @Override
        @NotNull
        public List<? extends CommitHook> getCommitHooks(@NotNull String workspaceName) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<? extends ValidatorProvider> getValidators(@NotNull String workspaceName, @NotNull Set<Principal> principals, @NotNull MoveTracker moveTracker) {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<ThreeWayConflictHandler> getConflictHandlers() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<ProtectedItemImporter> getProtectedItemImporters() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Context getContext() {
            return Context.DEFAULT;
        }
    }
}

