/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.action;

import java.util.Collections;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.AccessControlPolicyIterator;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.api.security.JackrabbitAccessControlList;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.AuthorizationConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;
import org.apache.jackrabbit.oak.spi.security.user.action.AbstractAuthorizableAction;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sling-mock-oak.com.google.common.base.Preconditions;

public class AccessControlAction
extends AbstractAuthorizableAction {
    private static final Logger log = LoggerFactory.getLogger(AccessControlAction.class);
    public static final String USER_PRIVILEGE_NAMES = "userPrivilegeNames";
    public static final String GROUP_PRIVILEGE_NAMES = "groupPrivilegeNames";
    private SecurityProvider securityProvider;
    private String[] groupPrivilegeNames = new String[0];
    private String[] userPrivilegeNames = new String[0];
    private Set<String> administrativePrincipals = Collections.emptySet();

    @Override
    public void init(SecurityProvider securityProvider, ConfigurationParameters config) {
        this.securityProvider = securityProvider;
        this.userPrivilegeNames = AccessControlAction.privilegeNames(config, USER_PRIVILEGE_NAMES);
        this.groupPrivilegeNames = AccessControlAction.privilegeNames(config, GROUP_PRIVILEGE_NAMES);
        this.administrativePrincipals = securityProvider.getConfiguration(AuthorizationConfiguration.class).getParameters().getConfigValue("administrativePrincipals", Collections.EMPTY_SET);
    }

    @Override
    public void onCreate(@NotNull Group group, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        this.setAC(group, root, namePathMapper);
    }

    @Override
    public void onCreate(@NotNull User user, @Nullable String password, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        this.setAC(user, root, namePathMapper);
    }

    @NotNull
    private static String[] privilegeNames(ConfigurationParameters config, String paramName) {
        String[] privilegeNames = config.getConfigValue(paramName, null, String[].class);
        if (privilegeNames != null && privilegeNames.length > 0) {
            return privilegeNames;
        }
        return new String[0];
    }

    private void setAC(@NotNull Authorizable authorizable, @NotNull Root root, @NotNull NamePathMapper namePathMapper) throws RepositoryException {
        Preconditions.checkState(this.securityProvider != null, "Not initialized");
        if (this.omitSetup(authorizable)) {
            return;
        }
        String path = authorizable.getPath();
        AuthorizationConfiguration acConfig = this.securityProvider.getConfiguration(AuthorizationConfiguration.class);
        AccessControlManager acMgr = acConfig.getAccessControlManager(root, namePathMapper);
        JackrabbitAccessControlList acl = null;
        AccessControlPolicyIterator it = acMgr.getApplicablePolicies(path);
        while (it.hasNext()) {
            AccessControlPolicy plc = it.nextAccessControlPolicy();
            if (!(plc instanceof JackrabbitAccessControlList)) continue;
            acl = (JackrabbitAccessControlList)plc;
            break;
        }
        if (acl == null) {
            log.warn("Cannot process AccessControlAction: no applicable ACL at {}", (Object)path);
        } else {
            String[] privNames;
            String[] stringArray = privNames = authorizable.isGroup() ? this.groupPrivilegeNames : this.userPrivilegeNames;
            if (acl.addAccessControlEntry(authorizable.getPrincipal(), AccessControlAction.getPrivileges(privNames, acMgr))) {
                acMgr.setPolicy(path, (AccessControlPolicy)acl);
            }
        }
    }

    private boolean omitSetup(@NotNull Authorizable authorizable) throws RepositoryException {
        String principalName;
        if (authorizable.isGroup()) {
            if (this.groupPrivilegeNames.length == 0) {
                log.debug("No privileges configured for groups; omit ac setup.");
                return true;
            }
        } else {
            if (this.userPrivilegeNames.length == 0) {
                log.debug("No privileges configured for users; omit ac setup.");
                return true;
            }
            if (this.isBuiltInUser(authorizable)) {
                log.debug("System user: {}; omit ac setup.", (Object)authorizable.getID());
                return true;
            }
        }
        if (this.administrativePrincipals.contains(principalName = authorizable.getPrincipal().getName())) {
            log.debug("Administrative principal: {}; omit ac setup.", (Object)principalName);
            return true;
        }
        return false;
    }

    private boolean isBuiltInUser(@NotNull Authorizable authorizable) throws RepositoryException {
        ConfigurationParameters userConfig = this.securityProvider.getConfiguration(UserConfiguration.class).getParameters();
        String userId = authorizable.getID();
        return UserUtil.getAdminId(userConfig).equals(userId) || UserUtil.getAnonymousId(userConfig).equals(userId);
    }

    @NotNull
    private static Privilege[] getPrivileges(@NotNull String[] privNames, @NotNull AccessControlManager acMgr) throws RepositoryException {
        Privilege[] privileges = new Privilege[privNames.length];
        for (int i = 0; i < privNames.length; ++i) {
            privileges[i] = acMgr.privilegeFromName(privNames[i]);
        }
        return privileges;
    }
}

