/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.slingstart;

import aQute.bnd.version.MavenVersion;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.Feature;
import org.apache.sling.feature.builder.FeatureProvider;
import org.apache.sling.feature.io.json.FeatureJSONReader;
import org.apache.sling.feature.io.json.FeatureJSONWriter;
import org.apache.sling.feature.modelconverter.FeatureToProvisioning;
import org.apache.sling.maven.slingstart.JSONFeatures;
import org.apache.sling.maven.slingstart.ModelPreprocessor;
import org.apache.sling.maven.slingstart.ModelUtils;
import org.apache.sling.maven.slingstart.Substitution;

public class FeatureModelConverter {
    static final String BUILD_DIR = "provisioning/converted";
    static final String PROVISIONING_MODEL_NAME_VARIABLE = "provisioning.model.name";
    static final String PROVISIONING_RUNMODES = "provisioning.runmodes";
    private static final char EOF = '\uffff';
    private static final int CLAUSE_START = 0;
    private static final int PARAMETER_START = 1;
    private static final int KEY = 2;
    private static final int DIRECTIVE_OR_TYPEDATTRIBUTE = 4;
    private static final int ARGUMENT = 8;
    private static final int VALUE = 16;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Feature getFeature(ArtifactId id, MavenSession session, MavenProject project, ArtifactHandlerManager manager, ArtifactResolver resolver) {
        try {
            File file = ModelUtils.getArtifact(project, session, manager, resolver, id.getGroupId(), id.getArtifactId(), id.getVersion(), id.getType(), id.getClassifier()).getFile();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");){
                Feature feature = FeatureJSONReader.read((Reader)reader, (String)file.toURI().toURL().toString());
                return feature;
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void convert(ModelPreprocessor.Environment env) throws MavenExecutionException {
        for (ModelPreprocessor.ProjectInfo pi : env.modelProjects.values()) {
            FeatureModelConverter.convert(env, pi, pi.defaultProvisioningModelName);
        }
    }

    public static void convertDirectories(String featuresDirectory, MavenProject project, String defaultProvName, FeatureProvider fp) throws MavenExecutionException {
        List<FeatureFileEntry> featureFiles = FeatureModelConverter.getFeatureFiles(project.getBasedir(), featuresDirectory);
        if (!featureFiles.isEmpty()) {
            FeatureModelConverter.convert(featureFiles, project, defaultProvName, fp);
        }
    }

    static List<FeatureFileEntry> getFeatureFiles(File baseDir, String config) {
        ArrayList<FeatureFileEntry> files = new ArrayList<FeatureFileEntry>();
        for (ParsedHeaderClause cfg : FeatureModelConverter.parseStandardHeader(config)) {
            String directory = cfg.m_paths.get(0).trim().replace('/', File.separatorChar);
            String runmodes = (String)cfg.m_attrs.get(PROVISIONING_RUNMODES);
            String model = (String)cfg.m_attrs.get(PROVISIONING_MODEL_NAME_VARIABLE);
            File featuresDir = new File(baseDir, directory);
            File[] children = featuresDir.listFiles();
            if (children == null) continue;
            for (File f : children) {
                if (!f.isFile() || !f.getName().endsWith(".json")) continue;
                FeatureFileEntry ff = new FeatureFileEntry();
                ff.file = f;
                ff.runModes = runmodes;
                ff.model = model;
                files.add(ff);
            }
        }
        return files;
    }

    public static void convert(ModelPreprocessor.Environment env, ModelPreprocessor.ProjectInfo info, String defaultProvName) throws MavenExecutionException {
        String config = ModelPreprocessor.nodeValue(info.plugin, "featuresDirectory", "src/main/features");
        List<FeatureFileEntry> files = FeatureModelConverter.getFeatureFiles(info.project.getBasedir(), config);
        if (!files.isEmpty()) {
            try {
                FeatureModelConverter.convert(files, info.project, defaultProvName, id -> FeatureModelConverter.getFeature(id, env.session, info.project, env.artifactHandlerManager, env.resolver));
            }
            catch (RuntimeException ex) {
                throw new MavenExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    static void convert(List<FeatureFileEntry> files, MavenProject project, String defaultProvName, FeatureProvider fp) throws MavenExecutionException {
        File processedFeaturesDir = new File(project.getBuild().getDirectory(), "features/processed");
        processedFeaturesDir.mkdirs();
        ArrayList<File> substedFiles = new ArrayList<File>();
        for (FeatureFileEntry featureFileEntry : files) {
            File f = featureFileEntry.file;
            File outFile = new File(processedFeaturesDir, f.getName());
            if (!outFile.exists() || outFile.lastModified() <= f.lastModified()) {
                try {
                    Throwable throwable;
                    String json;
                    block52: {
                        String suggestedClassifier;
                        if (!f.getName().equals("feature.json")) {
                            int lastDot = f.getName().lastIndexOf(46);
                            suggestedClassifier = f.getName().substring(0, lastDot);
                        } else {
                            suggestedClassifier = null;
                        }
                        json = FeatureModelConverter.readFeatureFile(project, f, suggestedClassifier);
                        if (defaultProvName != null || featureFileEntry.runModes != null || featureFileEntry.model != null) {
                            throwable = null;
                            try (StringReader reader = new StringReader(json);){
                                Feature feature = FeatureJSONReader.read((Reader)reader, (String)f.getAbsolutePath());
                                boolean update = false;
                                if (featureFileEntry.runModes != null) {
                                    String oldValue = (String)feature.getVariables().get(PROVISIONING_RUNMODES);
                                    String newValue = oldValue == null ? featureFileEntry.runModes : oldValue.concat(",").concat(featureFileEntry.runModes);
                                    feature.getVariables().put(PROVISIONING_RUNMODES, newValue);
                                    update = true;
                                }
                                if (feature.getVariables().get(PROVISIONING_MODEL_NAME_VARIABLE) == null) {
                                    boolean updateInner = true;
                                    if (featureFileEntry.model != null) {
                                        feature.getVariables().put(PROVISIONING_MODEL_NAME_VARIABLE, featureFileEntry.model);
                                    } else if (defaultProvName != null) {
                                        feature.getVariables().put(PROVISIONING_MODEL_NAME_VARIABLE, defaultProvName);
                                    } else {
                                        updateInner = update;
                                    }
                                    update = updateInner;
                                }
                                if (!update) break block52;
                                try (StringWriter writer = new StringWriter();){
                                    FeatureJSONWriter.write((Writer)writer, (Feature)feature);
                                    ((Writer)writer).flush();
                                    json = ((Object)writer).toString();
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                    }
                    throwable = null;
                    try (FileWriter fileWriter = new FileWriter(outFile);){
                        fileWriter.write(json);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new MavenExecutionException("Problem processing feature file " + f.getAbsolutePath(), (Throwable)e);
                }
            }
            substedFiles.add(outFile);
        }
        File targetDir = new File(project.getBuild().getDirectory(), BUILD_DIR);
        targetDir.mkdirs();
        try {
            for (File f : substedFiles) {
                File genFile = new File(targetDir, f.getName() + ".txt");
                FeatureToProvisioning.convert((File)f, (File)genFile, (FeatureProvider)fp, (File[])substedFiles.toArray(new File[0]));
            }
        }
        catch (Exception exception) {
            throw new MavenExecutionException("Cannot convert feature files to provisioning model", (Throwable)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFeatureFile(MavenProject project, File file, String suggestedClassifier) {
        ArtifactId fileId = new ArtifactId(project.getGroupId(), project.getArtifactId(), project.getVersion(), suggestedClassifier, "slingosgifeature");
        try (FileReader reader = new FileReader(file);){
            String string = Substitution.replaceMavenVars(project, JSONFeatures.read(reader, fileId, file.getAbsolutePath()));
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read feature file " + file.getAbsolutePath() + " : " + e.getMessage(), e);
        }
    }

    private static String cleanVersionString(String version) {
        StringBuilder sb = new StringBuilder();
        boolean afterDot = false;
        for (int i = 0; i < version.length(); ++i) {
            char c = version.charAt(i);
            if (c == '.') {
                if (afterDot) {
                    sb.append('0');
                }
                afterDot = true;
                sb.append(c);
                continue;
            }
            if (afterDot && c == '0') continue;
            if (afterDot && c == '-') {
                sb.append('0');
                sb.append(c);
                afterDot = false;
                continue;
            }
            afterDot = false;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String getOSGiVersion(String version) {
        DefaultArtifactVersion dav = new DefaultArtifactVersion(FeatureModelConverter.cleanVersionString(version));
        StringBuilder sb = new StringBuilder();
        sb.append(dav.getMajorVersion());
        sb.append('.');
        sb.append(dav.getMinorVersion());
        sb.append('.');
        sb.append(dav.getIncrementalVersion());
        if (dav.getQualifier() != null) {
            sb.append('.');
            sb.append(dav.getQualifier());
        }
        MavenVersion mavenVersion = new MavenVersion(sb.toString());
        return mavenVersion.getOSGiVersion().toString();
    }

    private static char charAt(int pos, String headers, int length) {
        if (pos >= length) {
            return '\uffff';
        }
        return headers.charAt(pos);
    }

    private static List<ParsedHeaderClause> parseStandardHeader(String header) {
        ArrayList<ParsedHeaderClause> clauses = new ArrayList<ParsedHeaderClause>();
        if (header == null) {
            return clauses;
        }
        ParsedHeaderClause clause = null;
        String key = null;
        Map<String, Object> targetMap = null;
        int state = 0;
        int currentPosition = 0;
        int startPosition = 0;
        int length = header.length();
        boolean quoted = false;
        boolean escaped = false;
        char currentChar = '\uffff';
        do {
            currentChar = FeatureModelConverter.charAt(currentPosition, header, length);
            switch (state) {
                case 0: {
                    clause = new ParsedHeaderClause(new ArrayList<String>(), new HashMap<String, String>(), new HashMap<String, Object>(), new HashMap<String, String>());
                    clauses.add(clause);
                    state = 1;
                }
                case 1: {
                    startPosition = currentPosition;
                    state = 2;
                }
                case 2: {
                    switch (currentChar) {
                        case ':': 
                        case '=': {
                            key = header.substring(startPosition, currentPosition).trim();
                            startPosition = currentPosition + 1;
                            targetMap = clause.m_attrs;
                            state = currentChar == ':' ? 4 : 8;
                            break;
                        }
                        case ',': 
                        case ';': 
                        case '\uffff': {
                            clause.m_paths.add(header.substring(startPosition, currentPosition).trim());
                            state = currentChar == ',' ? 0 : 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 4: {
                    switch (currentChar) {
                        case '=': {
                            if (startPosition != currentPosition) {
                                clause.m_types.put(key, header.substring(startPosition, currentPosition).trim());
                            } else {
                                targetMap = clause.m_dirs;
                            }
                            state = 8;
                            startPosition = currentPosition + 1;
                            break;
                        }
                    }
                    ++currentPosition;
                    break;
                }
                case 8: {
                    if (currentChar == '\"') {
                        quoted = true;
                        ++currentPosition;
                    } else {
                        quoted = false;
                    }
                    if (!Character.isWhitespace(currentChar)) {
                        state = 16;
                        break;
                    }
                    ++currentPosition;
                    break;
                }
                case 16: {
                    if (escaped) {
                        escaped = false;
                    } else if (currentChar == '\\') {
                        escaped = true;
                    } else if (quoted && currentChar == '\"') {
                        quoted = false;
                    } else if (!quoted) {
                        String value = null;
                        switch (currentChar) {
                            case ',': 
                            case ';': 
                            case '\uffff': {
                                value = header.substring(startPosition, currentPosition).trim();
                                if (value.startsWith("\"") && value.endsWith("\"")) {
                                    value = value.substring(1, value.length() - 1);
                                }
                                if (targetMap.put(key, value) != null) {
                                    throw new IllegalArgumentException("Duplicate '" + key + "' in: " + header);
                                }
                                state = currentChar == ';' ? 1 : 0;
                                break;
                            }
                        }
                    }
                    ++currentPosition;
                    break;
                }
            }
        } while (currentChar != 65535);
        if (state > 1) {
            throw new IllegalArgumentException("Unable to parse header: " + header);
        }
        return clauses;
    }

    private static class ParsedHeaderClause {
        public final List<String> m_paths;
        public final Map<String, String> m_dirs;
        public final Map<String, Object> m_attrs;
        public final Map<String, String> m_types;

        public ParsedHeaderClause(List<String> paths, Map<String, String> dirs, Map<String, Object> attrs, Map<String, String> types) {
            this.m_paths = paths;
            this.m_dirs = dirs;
            this.m_attrs = attrs;
            this.m_types = types;
        }
    }

    public static class FeatureFileEntry {
        public File file;
        public String runModes;
        public String model;
    }
}

