/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.math.BigDecimal;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Util;

public class SqlNumericLiteral
extends SqlLiteral {
    private Integer prec;
    private Integer scale;
    private boolean isExact;

    protected SqlNumericLiteral(BigDecimal value, Integer prec, Integer scale, boolean isExact, SqlParserPos pos) {
        super(value, isExact ? SqlTypeName.DECIMAL : SqlTypeName.DOUBLE, pos);
        this.prec = prec;
        this.scale = scale;
        this.isExact = isExact;
    }

    public Integer getPrec() {
        return this.prec;
    }

    public Integer getScale() {
        return this.scale;
    }

    public boolean isExact() {
        return this.isExact;
    }

    @Override
    public SqlNode clone(SqlParserPos pos) {
        return new SqlNumericLiteral((BigDecimal)this.value, this.getPrec(), this.getScale(), this.isExact, pos);
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.literal(this.toValue());
    }

    @Override
    public String toValue() {
        BigDecimal bd = (BigDecimal)this.value;
        if (this.isExact) {
            return this.value.toString();
        }
        return Util.toScientificNotation(bd);
    }

    @Override
    public RelDataType createSqlType(RelDataTypeFactory typeFactory) {
        if (this.isExact) {
            int scaleValue = this.scale;
            if (0 == scaleValue) {
                BigDecimal bd = (BigDecimal)this.value;
                long l = bd.longValue();
                SqlTypeName result = l >= Integer.MIN_VALUE && l <= Integer.MAX_VALUE ? SqlTypeName.INTEGER : SqlTypeName.BIGINT;
                return typeFactory.createSqlType(result);
            }
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, this.prec, scaleValue);
        }
        return typeFactory.createSqlType(SqlTypeName.DOUBLE);
    }

    public boolean isInteger() {
        return 0 == this.scale;
    }
}

