/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hack;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.storm.hack.IOUtil;
import org.apache.storm.hack.ShadeRequest;
import org.apache.storm.hack.relocation.Relocator;
import org.apache.storm.hack.resource.ResourceTransformer;
import org.apache.storm.hack.shade.org.objectweb.asm.ClassReader;
import org.apache.storm.hack.shade.org.objectweb.asm.ClassWriter;
import org.apache.storm.hack.shade.org.objectweb.asm.commons.Remapper;
import org.apache.storm.hack.shade.org.objectweb.asm.commons.RemappingClassAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultShader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultShader.class);

    public void shadeJarStream(ShadeRequest shadeRequest, InputStream in, OutputStream fileOutputStream) throws IOException {
        HashSet<String> resources = new HashSet<String>();
        ArrayList<ResourceTransformer> transformers = new ArrayList<ResourceTransformer>(shadeRequest.getResourceTransformers());
        LOG.debug("Transformers {}", transformers);
        RelocatorRemapper remapper = new RelocatorRemapper(shadeRequest.getRelocators());
        LOG.debug("Remapper {}", (Object)remapper);
        JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(fileOutputStream));
        JarInputStream jarFile = new JarInputStream(in);
        JarEntry entry = jarFile.getNextJarEntry();
        while (entry != null) {
            String name = entry.getName();
            LOG.debug("Processing " + name);
            remapper.setClassName(name);
            if ("META-INF/INDEX.LIST".equals(name)) {
                LOG.debug("Skipping INDEX.LIST...");
            } else if (!entry.isDirectory()) {
                String dir;
                JarInputStream is = jarFile;
                String mappedName = remapper.map(name);
                LOG.debug(name + " -> " + mappedName);
                int idx = mappedName.lastIndexOf(47);
                if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                    this.addDirectory(resources, jos, dir);
                }
                if (name.endsWith(".class")) {
                    this.addRemappedClass(remapper, jos, name, is);
                } else if (name.endsWith(".java")) {
                    if (!resources.contains(mappedName)) {
                        this.addJavaSource(resources, jos, mappedName, is, shadeRequest.getRelocators());
                    }
                } else if (!this.resourceTransformed(transformers, mappedName, is, shadeRequest.getRelocators()) && !resources.contains(mappedName)) {
                    this.addResource(resources, jos, mappedName, is);
                }
            }
            entry = jarFile.getNextJarEntry();
        }
        jarFile.close();
        for (ResourceTransformer transformer : transformers) {
            if (!transformer.hasTransformedResource()) continue;
            transformer.modifyOutputStream(jos);
        }
        jos.close();
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        LOG.debug("Adding JAR directory " + entry);
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, String name, InputStream is) throws IOException {
        LOG.debug("Remapping class... " + name);
        if (!remapper.hasRelocators()) {
            try {
                LOG.debug("Just copy class...");
                jos.putNextEntry(new JarEntry(name));
                IOUtil.copy(is, jos);
            }
            catch (ZipException e) {
                LOG.info("zip exception ", (Throwable)e);
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        final String pkg = name.substring(0, name.lastIndexOf(47) + 1);
        RemappingClassAdapter cv = new RemappingClassAdapter(cw, remapper){

            @Override
            public void visitSource(String source, String debug) {
                LOG.debug("visitSource " + source);
                if (source == null) {
                    super.visitSource(source, debug);
                } else {
                    String fqSource = pkg + source;
                    String mappedSource = this.remapper.map(fqSource);
                    String filename = mappedSource.substring(mappedSource.lastIndexOf(47) + 1);
                    LOG.debug("Remapped to " + filename);
                    super.visitSource(filename, debug);
                }
            }
        };
        try {
            cr.accept(cv, 8);
        }
        catch (Throwable ise) {
            throw new IOException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        LOG.debug("Remapped class name to " + mappedName);
        try {
            jos.putNextEntry(new JarEntry(mappedName + ".class"));
            jos.write(renamedClass);
        }
        catch (ZipException e) {
            LOG.info("zip exception ", (Throwable)e);
        }
    }

    private boolean resourceTransformed(List<ResourceTransformer> resourceTransformers, String name, InputStream is, List<Relocator> relocators) throws IOException {
        boolean resourceTransformed = false;
        for (ResourceTransformer transformer : resourceTransformers) {
            if (!transformer.canTransformResource(name)) continue;
            LOG.debug("Transforming " + name + " using " + transformer.getClass().getName());
            transformer.processResource(name, is, relocators);
            resourceTransformed = true;
            break;
        }
        return resourceTransformed;
    }

    private void addJavaSource(Set<String> resources, JarOutputStream jos, String name, InputStream is, List<Relocator> relocators) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        String sourceContent = IOUtil.toString(new InputStreamReader(is, "UTF-8"));
        for (Relocator relocator : relocators) {
            sourceContent = relocator.applyToSourceContent(sourceContent);
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
        writer.append(sourceContent);
        writer.flush();
        resources.add(name);
    }

    private void addResource(Set<String> resources, JarOutputStream jos, String name, InputStream is) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        IOUtil.copy(is, jos);
        resources.add(name);
    }

    class RelocatorRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        private final List<Relocator> relocators;
        private final HashSet<String> warned = new HashSet();
        private String className = "UNKNOWN";

        public RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        @Override
        public String map(String name) {
            String orig = name;
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                if (this.warned.contains(orig)) break;
                LOG.warn("Relocating {} to {} in {}. {}", new Object[]{orig, value, this.className, r.getWarnMessage()});
                this.warned.add(orig);
                break;
            }
            return value;
        }
    }
}

