/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth.workertoken;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

class WorkerTokenSigner {
    static final String DEFAULT_HMAC_ALGORITHM = "HmacSHA256";
    private static final ThreadLocal<Mac> threadLocalMac = ThreadLocal.withInitial(() -> {
        try {
            return Mac.getInstance(DEFAULT_HMAC_ALGORITHM);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find HmacSHA256 algorithm.");
        }
    });

    WorkerTokenSigner() {
    }

    static byte[] createPassword(byte[] identifier, SecretKey key) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(key);
        }
        catch (InvalidKeyException ike) {
            throw new IllegalArgumentException("Invalid key to HMAC computation", ike);
        }
        return mac.doFinal(identifier);
    }
}

