/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.compiler.fs.AbstractFileSystem;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public class ResourceFileSystem
extends AbstractFileSystem {
    private final FileStore store = new FileStore(){

        @Override
        public Charset getDefaultCharset() {
            return ResourceFileSystem.this.getDefaultCharset();
        }

        @Override
        public URI toUri(FileRef fileRef) {
            try {
                return this.getClass().getResource(fileRef.getName()).toURI();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public InputStream openInputStream(FileRef fileRef) {
            return this.getClass().getResourceAsStream(fileRef.getName());
        }

        @Override
        public OutputStream openOutputStream(FileRef fileRef) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toFilename(FileRef fileRef) {
            return fileRef.getName();
        }

        @Override
        public String toRelativeFilename(FileRef fileRef) {
            return this.toFilename(fileRef);
        }

        @Override
        public long getLastModified(FileRef fileRef) {
            return 0L;
        }

        @Override
        public boolean delete(FileRef fileRef) {
            return false;
        }
    };
    private static Pattern LIST_DELIMITER_PATTERN = Pattern.compile(":");

    @Override
    protected FileStore getFileStore() {
        return this.store;
    }

    @Override
    public FileRef parseFilename(String systemFilename) {
        return new FileRef(this.store, systemFilename);
    }

    @Override
    protected Pattern getFilenameListDelimiter() {
        return LIST_DELIMITER_PATTERN;
    }
}

