/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
@Documented
@Inherited
public @interface TestConstructor {
    public static final String TEST_CONSTRUCTOR_AUTOWIRE_MODE_PROPERTY_NAME = "spring.test.constructor.autowire.mode";

    public AutowireMode autowireMode();

    public static enum AutowireMode {
        ALL,
        ANNOTATED;


        @Nullable
        public static AutowireMode from(@Nullable String name) {
            if (name == null) {
                return null;
            }
            try {
                return AutowireMode.valueOf(name.trim().toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                Log logger = LogFactory.getLog(AutowireMode.class);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Failed to parse autowire mode from '%s': %s", name, ex.getMessage()));
                }
                return null;
            }
        }
    }
}

