/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.Map;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.design.JasperDesign;

public class JRDesignFont
extends JRBaseFont {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_STYLE = "style";
    public static final String PROPERTY_STYLE_NAME_REFERENCE = "styleNameReference";

    @JsonCreator
    private JRDesignFont() {
        this((JRStyleContainer)null);
    }

    public JRDesignFont(JRStyleContainer styleContainer) {
        super(styleContainer);
    }

    public void setStyle(JRStyle style) {
        JRStyle old = this.style;
        this.style = style;
        this.getEventSupport().firePropertyChange(PROPERTY_STYLE, old, this.style);
    }

    public void setStyleNameReference(String styleNameReference) {
        String old = this.styleNameReference;
        this.styleNameReference = styleNameReference;
        this.getEventSupport().firePropertyChange(PROPERTY_STYLE_NAME_REFERENCE, old, this.styleNameReference);
    }

    @JsonSetter(value="style")
    private void setStyleName(String styleName) {
        JasperDesign jasperDesign;
        if (styleName != null && (jasperDesign = JasperDesign.getThreadInstance()) != null) {
            Map<String, JRStyle> stylesMap = jasperDesign.getStylesMap();
            if (stylesMap.containsKey(styleName)) {
                JRStyle style = stylesMap.get(styleName);
                this.setStyle(style);
            } else {
                this.setStyleNameReference(styleName);
            }
        }
    }
}

