/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.tiles;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import org.apache.tiles.autotag.freemarker.FMTemplateGeneratorFactory;
import org.apache.tiles.autotag.generate.TemplateGenerator;
import org.apache.tiles.autotag.generate.TemplateGeneratorBuilder;
import org.apache.tiles.autotag.jsp.JspTemplateGeneratorFactory;
import org.apache.tiles.autotag.model.TemplateClass;
import org.apache.tiles.autotag.model.TemplateParameter;
import org.apache.tiles.autotag.model.TemplateSuite;
import org.apache.tiles.autotag.velocity.VelocityTemplateGeneratorFactory;
import org.apache.velocity.app.VelocityEngine;

public class BuildAutotags {
    public static void main(String[] args) {
        BuildAutotags me = new BuildAutotags();
        me.buildJsp(args[0]);
        me.buildFreemarker(args[0]);
        me.buildVelocity(args[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildJsp(String outputDir) {
        String taglibURI = "http://tiles.apache.org/tags-tiles";
        String packageName = "org.apache.tiles.web.jsp.taglib";
        String requestClass = "org.apache.tiles.request.Request";
        String runtime = "org.apache.tiles.request.jsp.autotag.JspAutotagRuntime";
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("taglibURI", taglibURI);
        try {
            TemplateSuite suite;
            try (InputStream stream = this.getClass().getResourceAsStream("/META-INF/template-suite.xml");){
                XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                xstream.allowTypes(new Class[]{TemplateClass.class, TemplateSuite.class, TemplateParameter.class});
                suite = (TemplateSuite)xstream.fromXML(stream);
            }
            Properties props = new Properties();
            InputStream propsStream = this.getClass().getResourceAsStream("/org/apache/tiles/autotag/velocity.properties");
            props.load(propsStream);
            propsStream.close();
            File classesOutputDirectory = new File(outputDir + "/generated-sources/autotag/classes");
            File resourcesOutputDirectory = new File(outputDir + "/generated-sources/autotag");
            TemplateGenerator generator = new JspTemplateGeneratorFactory(classesOutputDirectory, resourcesOutputDirectory, new VelocityEngine(props), TemplateGeneratorBuilder.createNewInstance()).createTemplateGenerator();
            generator.generate(packageName, suite, parameters, runtime, requestClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildFreemarker(String outputDir) {
        String packageName = "org.apache.tiles.freemarker.template";
        String requestClass = "org.apache.tiles.request.Request";
        String runtime = "org.apache.tiles.request.freemarker.autotag.FreemarkerAutotagRuntime";
        try {
            TemplateSuite suite;
            try (InputStream stream = this.getClass().getResourceAsStream("/META-INF/template-suite.xml");){
                XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                xstream.allowTypes(new Class[]{TemplateClass.class, TemplateSuite.class, TemplateParameter.class});
                suite = (TemplateSuite)xstream.fromXML(stream);
            }
            Properties props = new Properties();
            InputStream propsStream = this.getClass().getResourceAsStream("/org/apache/tiles/autotag/velocity.properties");
            props.load(propsStream);
            propsStream.close();
            File classesOutputDirectory = new File(outputDir + "/generated-sources/autotag/classes");
            TemplateGenerator generator = new FMTemplateGeneratorFactory(classesOutputDirectory, new VelocityEngine(props), TemplateGeneratorBuilder.createNewInstance()).createTemplateGenerator();
            generator.generate(packageName, suite, null, runtime, requestClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildVelocity(String outputDir) {
        String packageName = "org.apache.tiles.velocity.template";
        String requestClass = "org.apache.tiles.request.Request";
        String runtime = "org.apache.tiles.request.velocity.autotag.VelocityAutotagRuntime";
        try {
            TemplateSuite suite;
            try (InputStream stream = this.getClass().getResourceAsStream("/META-INF/template-suite.xml");){
                XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
                xstream.allowTypes(new Class[]{TemplateClass.class, TemplateSuite.class, TemplateParameter.class});
                suite = (TemplateSuite)xstream.fromXML(stream);
            }
            Properties props = new Properties();
            InputStream propsStream = this.getClass().getResourceAsStream("/org/apache/tiles/autotag/velocity.properties");
            props.load(propsStream);
            propsStream.close();
            File classesOutputDirectory = new File(outputDir + "/generated-sources/autotag/classes");
            File resourcesOutputDirectory = new File(outputDir + "/generated-sources/autotag");
            TemplateGenerator generator = new VelocityTemplateGeneratorFactory(classesOutputDirectory, resourcesOutputDirectory, new VelocityEngine(props), TemplateGeneratorBuilder.createNewInstance()).createTemplateGenerator();
            generator.generate(packageName, suite, null, runtime, requestClass);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

