/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.HashMap;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.nhttp.HttpCoreNIOListener;

public class Axis2TransportHelper {
    private static Log log = LogFactory.getLog(Axis2TransportHelper.class);
    private ConfigurationContext configurationContext;

    public Axis2TransportHelper(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public void pauseListeners() {
        if (this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null) {
            HashMap trpIns = this.configurationContext.getAxisConfiguration().getTransportsIn();
            for (TransportInDescription trpIn : trpIns.values()) {
                TransportListener trpLst = trpIn.getReceiver();
                if (!(trpLst instanceof ManagementSupport)) continue;
                try {
                    ((ManagementSupport)trpLst).pause();
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error putting transport listener for: " + trpIn.getName() + " into maintenence"));
                }
            }
        }
    }

    public void resumeListeners() {
        if (this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null) {
            HashMap trpIns = this.configurationContext.getAxisConfiguration().getTransportsIn();
            for (TransportInDescription trpIn : trpIns.values()) {
                TransportListener trpLst = trpIn.getReceiver();
                if (!(trpLst instanceof ManagementSupport)) continue;
                try {
                    ((ManagementSupport)trpLst).resume();
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error resuming transport listener for: " + trpIn.getName() + " from maintenence"));
                }
            }
        }
    }

    public void pauseSenders() {
        if (this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null) {
            HashMap trpOuts = this.configurationContext.getAxisConfiguration().getTransportsOut();
            for (TransportOutDescription trpOut : trpOuts.values()) {
                TransportSender trpSnd = trpOut.getSender();
                if (!(trpSnd instanceof ManagementSupport)) continue;
                try {
                    ((ManagementSupport)trpSnd).pause();
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error pausing transport sender: " + trpOut.getName()));
                }
            }
        }
    }

    public void resumeSenders() {
        if (this.configurationContext != null && this.configurationContext.getAxisConfiguration() != null) {
            HashMap trpOuts = this.configurationContext.getAxisConfiguration().getTransportsOut();
            for (TransportOutDescription trpOut : trpOuts.values()) {
                TransportSender trpSnd = trpOut.getSender();
                if (!(trpSnd instanceof ManagementSupport)) continue;
                try {
                    ((ManagementSupport)trpSnd).resume();
                }
                catch (AxisFault axisFault) {
                    log.error((Object)("Error resuming transport sender for : " + trpOut.getName() + " from maintenence"));
                }
            }
        }
    }

    public int getPendingListenerThreadCount() {
        int pendingThreads = 0;
        HashMap trpIns = this.configurationContext.getAxisConfiguration().getTransportsIn();
        for (TransportInDescription trpIn : trpIns.values()) {
            int inQue;
            int inUse;
            TransportListener trpLst = trpIn.getReceiver();
            if (!(trpLst instanceof ManagementSupport) || (inUse = ((ManagementSupport)trpLst).getActiveThreadCount()) + (inQue = ((ManagementSupport)trpLst).getQueueSize()) <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transport Listener : " + trpIn.getName() + " currently using : " + inUse + " threads with " + inQue + " requests already queued..."));
            }
            pendingThreads = inUse + inQue;
        }
        return pendingThreads;
    }

    public int getActiveConnectionsCount() {
        HashMap trpIns = this.configurationContext.getAxisConfiguration().getTransportsIn();
        for (TransportInDescription trpIn : trpIns.values()) {
            if (!(trpIn.getReceiver() instanceof HttpCoreNIOListener)) continue;
            return ((HttpCoreNIOListener)trpIn.getReceiver()).getActiveConnectionsSize();
        }
        return 0;
    }

    public int getPendingSenderThreadCount() {
        int pendingThreads = 0;
        HashMap trpOuts = this.configurationContext.getAxisConfiguration().getTransportsOut();
        for (TransportOutDescription trpOut : trpOuts.values()) {
            int inQue;
            int inUse;
            TransportSender trpSnd = trpOut.getSender();
            if (!(trpSnd instanceof ManagementSupport) || (inUse = ((ManagementSupport)trpSnd).getActiveThreadCount()) + (inQue = ((ManagementSupport)trpSnd).getQueueSize()) <= 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Transport Sender : " + trpSnd.getName() + " currently using : " + inUse + " threads with " + inQue + " requests already queued..."));
            }
            pendingThreads += inUse + inQue;
        }
        return pendingThreads;
    }
}

