/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.message.store;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.message.store.AbstractMessageStore;

public class InMemoryMessageStore
extends AbstractMessageStore {
    private static final Log log = LogFactory.getLog(InMemoryMessageStore.class);
    private Queue<MessageContext> messageList = new ConcurrentLinkedQueue<MessageContext>();
    private Lock lock = new ReentrantLock();

    @Override
    public boolean offer(MessageContext messageContext) {
        this.lock.lock();
        try {
            if (messageContext != null) {
                messageContext.getEnvelope().build();
                this.messageList.offer(messageContext);
                this.notifyMessageAddition(messageContext.getMessageID());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Message with id " + messageContext.getMessageID() + " stored"));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public MessageContext poll() {
        this.lock.lock();
        try {
            MessageContext context = this.messageList.poll();
            if (context != null) {
                this.notifyMessageRemoval(context.getMessageID());
            }
            MessageContext messageContext = context;
            return messageContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public MessageContext peek() {
        return this.messageList.peek();
    }

    @Override
    public MessageContext remove() throws NoSuchElementException {
        this.lock.lock();
        try {
            MessageContext msgCtx = this.messageList.remove();
            if (msgCtx != null) {
                this.notifyMessageRemoval(msgCtx.getMessageID());
            }
            MessageContext messageContext = msgCtx;
            return messageContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(int index) {
        this.lock.lock();
        try {
            if (index >= 0 && index < this.messageList.size()) {
                int i = 0;
                for (MessageContext msgCtx : this.messageList) {
                    if (index == i) {
                        MessageContext messageContext = msgCtx;
                        return messageContext;
                    }
                    ++i;
                }
            }
            MessageContext messageContext = null;
            return messageContext;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext remove(String messageID) {
        this.lock.lock();
        try {
            if (messageID != null) {
                MessageContext removable = null;
                for (MessageContext msgCtx : this.messageList) {
                    if (!msgCtx.getMessageID().equals(messageID)) continue;
                    removable = msgCtx;
                    break;
                }
                if (removable != null && this.messageList.remove(removable)) {
                    this.notifyMessageRemoval(messageID);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return null;
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            while (!this.messageList.isEmpty()) {
                this.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public List<MessageContext> getAll() {
        this.lock.lock();
        try {
            ArrayList<MessageContext> returnList = new ArrayList<MessageContext>();
            returnList.addAll(this.messageList);
            ArrayList<MessageContext> arrayList = returnList;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageContext get(String messageId) {
        block5: {
            this.lock.lock();
            try {
                if (messageId == null) break block5;
                for (MessageContext msgCtx : this.messageList) {
                    if (!msgCtx.getMessageID().equals(messageId)) continue;
                    MessageContext messageContext = msgCtx;
                    return messageContext;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.messageList.size();
    }
}

