/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.context.servlet;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.servlet.AbstractAjaxHandler;

public class DefaultAjaxHandler
extends AbstractAjaxHandler {
    public static final String AJAX_ACCEPT_CONTENT_TYPE = "text/html;type=ajax";
    public static final String AJAX_SOURCE_PARAM = "ajaxSource";
    public static final String REDIRECT_URL_HEADER = "Spring-Redirect-URL";
    public static final String POPUP_VIEW_HEADER = "Spring-Modal-View";

    public DefaultAjaxHandler() {
        this(null);
    }

    public DefaultAjaxHandler(AbstractAjaxHandler delegate) {
        super(delegate);
    }

    @Override
    protected boolean isAjaxRequestInternal(HttpServletRequest request, HttpServletResponse response) {
        String header = request.getHeader("Accept");
        String param = request.getParameter(AJAX_SOURCE_PARAM);
        return AJAX_ACCEPT_CONTENT_TYPE.equals(header) || StringUtils.hasText((String)param);
    }

    @Override
    protected void sendAjaxRedirectInternal(String targetUrl, HttpServletRequest request, HttpServletResponse response, boolean popup) {
        if (popup) {
            response.setHeader(POPUP_VIEW_HEADER, "true");
        }
        response.setHeader(REDIRECT_URL_HEADER, response.encodeRedirectURL(targetUrl));
    }
}

