/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.idp.metadata.writer;

import java.io.Writer;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.support.saml.idp.metadata.writer.SamlIdPCertificateAndKeyWriter;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class DefaultSamlIdPCertificateAndKeyWriter
implements SamlIdPCertificateAndKeyWriter {
    private static final int X509_CERT_BITS_SIZE = 160;
    private int keySize = 2048;
    private String hostname;
    private String keyType = "RSA";
    private String certificateAlgorithm = "SHA256withRSA";
    private int certificateLifetimeInYears = 20;
    private List<String> uriSubjectAltNames;

    @Override
    public void writeCertificateAndKey(Writer privateKeyWriter, Writer certificateWriter) {
        FunctionUtils.doUnchecked(u -> {
            KeyPair keypair = this.generateKeyPair();
            X509Certificate certificate = this.generateCertificate(keypair);
            try (JcaPEMWriter keyOut = new JcaPEMWriter(privateKeyWriter);){
                keyOut.writeObject((Object)keypair.getPrivate());
                keyOut.flush();
            }
            try (JcaPEMWriter certOut = new JcaPEMWriter(certificateWriter);){
                certOut.writeObject((Object)certificate);
                certOut.flush();
            }
        }, (Object[])new Object[0]);
    }

    private KeyPair generateKeyPair() {
        return (KeyPair)FunctionUtils.doUnchecked(() -> {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(this.keyType);
            generator.initialize(this.keySize);
            return generator.generateKeyPair();
        });
    }

    private X509Certificate generateCertificate(KeyPair keypair) throws Exception {
        X500Name dn = new X500Name("CN=" + this.hostname);
        GregorianCalendar notBefore = new GregorianCalendar();
        GregorianCalendar notOnOrAfter = new GregorianCalendar();
        notOnOrAfter.set(1, notOnOrAfter.get(1) + this.certificateLifetimeInYears);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(dn, new BigInteger(160, RandomUtils.getNativeInstance()), notBefore.getTime(), notOnOrAfter.getTime(), dn, keypair.getPublic());
        JcaX509ExtensionUtils extUtils = new JcaX509ExtensionUtils();
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extUtils.createSubjectKeyIdentifier(keypair.getPublic()));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)GeneralNames.getInstance((Object)new DERSequence(this.buildSubjectAltNames())));
        X509CertificateHolder certHldr = builder.build(new JcaContentSignerBuilder(this.certificateAlgorithm).build(keypair.getPrivate()));
        X509Certificate cert = new JcaX509CertificateConverter().getCertificate(certHldr);
        cert.checkValidity(new Date());
        cert.verify(keypair.getPublic());
        return cert;
    }

    private ASN1Encodable[] buildSubjectAltNames() {
        ArrayList<GeneralName> subjectAltNames = new ArrayList<GeneralName>(2);
        subjectAltNames.add(new GeneralName(2, this.hostname));
        if (this.uriSubjectAltNames != null) {
            this.uriSubjectAltNames.forEach(subjectAltName -> subjectAltNames.add(new GeneralName(6, subjectAltName)));
        }
        return (ASN1Encodable[])subjectAltNames.toArray(ASN1Encodable[]::new);
    }

    @Generated
    public DefaultSamlIdPCertificateAndKeyWriter() {
    }

    @Generated
    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @Generated
    public void setCertificateAlgorithm(String certificateAlgorithm) {
        this.certificateAlgorithm = certificateAlgorithm;
    }

    @Generated
    public void setCertificateLifetimeInYears(int certificateLifetimeInYears) {
        this.certificateLifetimeInYears = certificateLifetimeInYears;
    }

    @Generated
    public void setUriSubjectAltNames(List<String> uriSubjectAltNames) {
        this.uriSubjectAltNames = uriSubjectAltNames;
    }
}

