/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.configurer;

import lombok.Generated;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.web.flow.configurer.AbstractCasWebflowConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.EndState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.engine.ViewState;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

public class DefaultLogoutWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLogoutWebflowConfigurer.class);

    public DefaultLogoutWebflowConfigurer(FlowBuilderServices flowBuilderServices, FlowDefinitionRegistry flowDefinitionRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
        super(flowBuilderServices, flowDefinitionRegistry, applicationContext, casProperties);
    }

    @Override
    protected void doInitialize() {
        Flow flow = this.getLogoutFlow();
        if (flow != null) {
            ActionState terminateSessionActionState = this.createTerminateSessionActionState(flow);
            this.createLogoutConfirmationView(flow);
            this.createDoLogoutActionState(flow);
            this.createFrontLogoutActionState(flow);
            this.createLogoutPropagationEndState(flow);
            this.createLogoutViewState(flow);
            this.createFinishLogoutState(flow);
            DefaultLogoutWebflowConfigurer.configureFlowStartState(flow, terminateSessionActionState);
        }
    }

    private static void configureFlowStartState(Flow flow, ActionState terminateSessionActionState) {
        LOGGER.trace("Setting the start state of the logout webflow identified by [{}] to [{}]", (Object)flow.getId(), (Object)terminateSessionActionState.getId());
        flow.setStartState((State)terminateSessionActionState);
    }

    protected ActionState createTerminateSessionActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "terminateSession", "terminateSessionAction");
        this.createTransitionForState((TransitionableState)actionState, "warn", "confirmLogoutView");
        this.createStateDefaultTransition((TransitionableState)actionState, "doLogout");
        return actionState;
    }

    protected void createFinishLogoutState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "finishLogout", "finishLogoutAction");
        this.createTransitionForState((TransitionableState)actionState, "redirect", "redirectView");
        this.createTransitionForState((TransitionableState)actionState, "post", "postView");
        this.createTransitionForState((TransitionableState)actionState, "finish", "logoutView");
    }

    protected void createLogoutViewState(Flow flow) {
        this.createEndState(flow, "redirectView", this.createExternalRedirectViewFactory("flowScope.logoutRedirectUrl"));
        this.createEndState(flow, "postView", "casPostResponseView");
        EndState logoutView = this.createEndState(flow, "logoutView", "logout/casLogoutView");
        logoutView.getEntryActionList().add((Action)this.createEvaluateAction("logoutViewSetupAction"));
    }

    private void createLogoutPropagationEndState(Flow flow) {
        this.createEndState(flow, "propagateLogoutRequests", "logout/casPropagateLogoutView");
    }

    protected void createFrontLogoutActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "frontLogout", (Action)this.createEvaluateAction("frontChannelLogoutAction"));
        this.createTransitionForState((TransitionableState)actionState, "finish", "finishLogout");
        this.createTransitionForState((TransitionableState)actionState, "propagate", "propagateLogoutRequests");
    }

    private void createDoLogoutActionState(Flow flow) {
        ActionState actionState = this.createActionState(flow, "doLogout", "logoutAction");
        this.createTransitionForState((TransitionableState)actionState, "finish", "finishLogout");
        this.createTransitionForState((TransitionableState)actionState, "front", "frontLogout");
    }

    protected void createLogoutConfirmationView(Flow flow) {
        ViewState view = this.createViewState(flow, "confirmLogoutView", "logout/casConfirmLogoutView");
        view.getRenderActionList().add((Action)this.createEvaluateAction("confirmLogoutAction"));
        this.createTransitionForState((TransitionableState)view, "success", "terminateSession");
    }
}

