/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;

public abstract class AttributesToGetResultsHandler {
    private final String[] attrsToGet;

    public AttributesToGetResultsHandler(String[] attributesToGet) {
        Assertions.nullCheck((Object)attributesToGet, (String)"attrsToGet");
        this.attrsToGet = attributesToGet;
    }

    public Set<Attribute> reduceToAttrsToGet(Set<Attribute> attributesToGet) {
        HashSet<Attribute> ret = new HashSet<Attribute>(this.attrsToGet.length);
        Map map = AttributeUtil.toMap(attributesToGet);
        for (String attrName : this.attrsToGet) {
            Attribute attr = (Attribute)map.get(attrName);
            if (attr == null) continue;
            ret.add(attr);
        }
        return ret;
    }

    public ConnectorObject reduceToAttrsToGet(ConnectorObject obj) {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        bld.setUid(obj.getUid());
        bld.setName(obj.getName());
        bld.setObjectClass(obj.getObjectClass());
        Set objAttrs = obj.getAttributes();
        Set<Attribute> attrs = this.reduceToAttrsToGet(objAttrs);
        bld.addAttributes(attrs);
        return bld.build();
    }
}

