/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.SyncopeWebApplication;
import org.apache.syncope.client.console.audit.AuditHistoryModal;
import org.apache.syncope.client.console.notifications.NotificationTasks;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.AnyDirectoryPanel;
import org.apache.syncope.client.console.panels.AnyObjectDisplayAttributesModalPanel;
import org.apache.syncope.client.console.panels.DirectoryPanel;
import org.apache.syncope.client.console.rest.AnyObjectRestClient;
import org.apache.syncope.client.console.tasks.AnyPropagationTasks;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionLink;
import org.apache.syncope.client.console.wicket.markup.html.form.ActionsPanel;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.client.console.wizards.any.AnyObjectWrapper;
import org.apache.syncope.client.ui.commons.panels.ModalPanel;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.client.ui.commons.wizards.any.AnyWrapper;
import org.apache.syncope.common.lib.AnyOperations;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.request.AnyObjectUR;
import org.apache.syncope.common.lib.to.AnyObjectTO;
import org.apache.syncope.common.lib.to.AnyTypeClassTO;
import org.apache.syncope.common.lib.to.ProvisioningResult;
import org.apache.syncope.common.lib.to.SchemaTO;
import org.apache.syncope.common.lib.types.AnyEntitlement;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;

public class AnyObjectDirectoryPanel
extends AnyDirectoryPanel<AnyObjectTO, AnyObjectRestClient> {
    private static final long serialVersionUID = -1100228004207271270L;

    protected AnyObjectDirectoryPanel(String id, Builder builder, boolean wizardInModal) {
        super(id, builder, wizardInModal);
    }

    @Override
    protected String paginatorRowsKey() {
        return "anyobject.paginator.rows";
    }

    @Override
    protected String[] getDefaultAttributeSelection() {
        return AnyObjectDisplayAttributesModalPanel.DEFAULT_SELECTION;
    }

    @Override
    public ActionsPanel<Serializable> getHeader(String componentId) {
        ActionsPanel<Serializable> panel = super.getHeader(componentId);
        panel.add(new ActionLink<Serializable>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, Serializable ignore) {
                target.add(new Component[]{AnyObjectDirectoryPanel.this.displayAttributeModal.setContent((ModalPanel)new AnyObjectDisplayAttributesModalPanel(AnyObjectDirectoryPanel.this.displayAttributeModal, AnyObjectDirectoryPanel.this.page.getPageReference(), AnyObjectDirectoryPanel.this.plainSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), AnyObjectDirectoryPanel.this.derSchemas.stream().map(SchemaTO::getKey).collect(Collectors.toList()), AnyObjectDirectoryPanel.this.type))});
                AnyObjectDirectoryPanel.this.displayAttributeModal.addSubmitButton();
                AnyObjectDirectoryPanel.this.displayAttributeModal.header((IModel)new ResourceModel("any.attr.display"));
                AnyObjectDirectoryPanel.this.displayAttributeModal.show(true);
            }

            @Override
            protected boolean statusCondition(Serializable modelObject) {
                return AnyObjectDirectoryPanel.this.wizardInModal;
            }
        }, ActionLink.ActionType.CHANGE_VIEW, AnyEntitlement.READ.getFor(this.type)).hideLabel();
        return panel;
    }

    @Override
    public ActionsPanel<AnyObjectTO> getActions(final IModel<AnyObjectTO> model) {
        ActionsPanel<AnyObjectTO> panel = super.getActions(model);
        panel.add(new ActionLink<AnyObjectTO>(){
            private static final long serialVersionUID = -7978723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                AnyObjectDirectoryPanel.this.send((IEventSink)AnyObjectDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.EditItemActionEvent((Serializable)((Object)new AnyObjectWrapper((AnyObjectTO)((AnyObjectRestClient)AnyObjectDirectoryPanel.this.restClient).read(((AnyObjectTO)model.getObject()).getKey()))), target));
            }
        }, ActionLink.ActionType.EDIT, String.format("%s,%s", AnyEntitlement.READ.getFor(this.type), AnyEntitlement.UPDATE.getFor(this.type))).setRealms(this.realm, ((AnyObjectTO)model.getObject()).getDynRealms());
        if (this.wizardInModal) {
            SyncopeWebApplication.get().getAnyDirectoryPanelAdditionalActionLinksProvider().get(this.type, (AnyObjectTO)model.getObject(), this.realm, this.altDefaultModal, this.getString("any.edit", (IModel)new Model((Serializable)((Object)new AnyObjectWrapper((AnyObjectTO)model.getObject())))), this, this.pageRef).forEach(panel::add);
            panel.add(new ActionLink<AnyObjectTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                    target.add(new Component[]{AnyObjectDirectoryPanel.this.utilityModal.setContent(new AnyPropagationTasks(AnyObjectDirectoryPanel.this.utilityModal, AnyTypeKind.ANY_OBJECT, ((AnyObjectTO)model.getObject()).getKey(), AnyObjectDirectoryPanel.this.pageRef))});
                    AnyObjectDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.propagation.tasks", model));
                    AnyObjectDirectoryPanel.this.utilityModal.show(true);
                }
            }, ActionLink.ActionType.PROPAGATION_TASKS, "TASK_LIST");
            panel.add(new ActionLink<AnyObjectTO>(){
                private static final long serialVersionUID = -7978723352517770644L;

                @Override
                public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                    target.add(new Component[]{AnyObjectDirectoryPanel.this.utilityModal.setContent(new NotificationTasks(AnyTypeKind.ANY_OBJECT, ((AnyObjectTO)model.getObject()).getKey(), AnyObjectDirectoryPanel.this.pageRef))});
                    AnyObjectDirectoryPanel.this.utilityModal.header((IModel)new StringResourceModel("any.notification.tasks", model));
                    AnyObjectDirectoryPanel.this.utilityModal.show(true);
                    target.add(new Component[]{AnyObjectDirectoryPanel.this.utilityModal});
                }
            }, ActionLink.ActionType.NOTIFICATION_TASKS, "TASK_LIST");
        }
        panel.add(new ActionLink<AnyObjectTO>(){
            private static final long serialVersionUID = -2878723352517770644L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                model.setObject((Object)((AnyObjectTO)((AnyObjectRestClient)AnyObjectDirectoryPanel.this.restClient).read(((AnyObjectTO)model.getObject()).getKey())));
                target.add(new Component[]{AnyObjectDirectoryPanel.this.altDefaultModal.setContent(new AuditHistoryModal<AnyObjectTO>(AuditElements.EventCategoryType.LOGIC, "AnyObjectLogic", (AnyObjectTO)model.getObject(), AnyEntitlement.UPDATE.getFor(AnyObjectDirectoryPanel.this.type), AnyObjectDirectoryPanel.this.auditRestClient){
                    private static final long serialVersionUID = -7440902560249531201L;

                    @Override
                    protected void restore(String json, AjaxRequestTarget target) {
                        AnyObjectTO original = (AnyObjectTO)model.getObject();
                        try {
                            AnyObjectTO updated = (AnyObjectTO)DirectoryPanel.MAPPER.readValue(json, AnyObjectTO.class);
                            AnyObjectUR updateReq = AnyOperations.diff((AnyObjectTO)updated, (AnyObjectTO)original, (boolean)false);
                            ProvisioningResult<AnyObjectTO> result = ((AnyObjectRestClient)AnyObjectDirectoryPanel.this.restClient).update(original.getETagValue(), updateReq);
                            ((AnyObjectTO)model.getObject()).setLastChangeDate(((AnyObjectTO)result.getEntity()).getLastChangeDate());
                            SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                            target.add(new Component[]{AnyObjectDirectoryPanel.this.container});
                        }
                        catch (Exception e) {
                            DirectoryPanel.LOG.error("While restoring any object {}", (Object)((AnyObjectTO)model.getObject()).getKey(), (Object)e);
                            SyncopeConsoleSession.get().onException(e);
                        }
                        ((BasePage)AnyObjectDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
                    }
                })});
                AnyObjectDirectoryPanel.this.altDefaultModal.header((IModel)new StringResourceModel("auditHistory.title", model));
                AnyObjectDirectoryPanel.this.altDefaultModal.show(true);
            }
        }, ActionLink.ActionType.VIEW_AUDIT_HISTORY, String.format("%s,%s", AnyEntitlement.READ.getFor(this.type), "AUDIT_LIST")).setRealms(this.realm, ((AnyObjectTO)model.getObject()).getDynRealms());
        panel.add(new ActionLink<AnyObjectTO>(){
            private static final long serialVersionUID = -7978723352517770645L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                AnyObjectTO clone = (AnyObjectTO)SerializationUtils.clone((Serializable)((AnyObjectTO)model.getObject()));
                clone.setKey(null);
                AnyObjectDirectoryPanel.this.send((IEventSink)AnyObjectDirectoryPanel.this, Broadcast.EXACT, new AjaxWizard.NewItemActionEvent((Serializable)((Object)new AnyObjectWrapper(clone)), target));
            }

            @Override
            protected boolean statusCondition(AnyObjectTO modelObject) {
                return AnyObjectDirectoryPanel.this.addAjaxLink.isVisibleInHierarchy() && AnyObjectDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.CLONE, AnyEntitlement.CREATE.getFor(this.type)).setRealm(this.realm);
        panel.add(new ActionLink<AnyObjectTO>(){
            private static final long serialVersionUID = -7978723352517770646L;

            @Override
            public void onClick(AjaxRequestTarget target, AnyObjectTO ignore) {
                try {
                    ((AnyObjectRestClient)AnyObjectDirectoryPanel.this.restClient).delete(((AnyObjectTO)model.getObject()).getETagValue(), ((AnyObjectTO)model.getObject()).getKey());
                    SyncopeConsoleSession.get().success((Serializable)((Object)AnyObjectDirectoryPanel.this.getString("operation_succeeded")));
                    target.add(new Component[]{AnyObjectDirectoryPanel.this.container});
                }
                catch (SyncopeClientException e) {
                    DirectoryPanel.LOG.error("While deleting any object {}", (Object)((AnyObjectTO)model.getObject()).getKey(), (Object)e);
                    SyncopeConsoleSession.get().onException((Exception)((Object)e));
                }
                ((BasePage)AnyObjectDirectoryPanel.this.pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }

            @Override
            protected boolean statusCondition(AnyObjectTO modelObject) {
                return AnyObjectDirectoryPanel.this.realm.startsWith("/");
            }
        }, ActionLink.ActionType.DELETE, AnyEntitlement.DELETE.getFor(this.type), true).setRealm(this.realm);
        return panel;
    }

    public static class Builder
    extends AnyDirectoryPanel.Builder<AnyObjectTO, AnyObjectRestClient> {
        private static final long serialVersionUID = -6828423611982275641L;

        public Builder(List<AnyTypeClassTO> anyTypeClassTOs, AnyObjectRestClient restClient, String type, PageReference pageRef) {
            super(anyTypeClassTOs, restClient, type, pageRef);
            this.setShowResultPage(true);
        }

        @Override
        protected WizardMgtPanel<AnyWrapper<AnyObjectTO>> newInstance(String id, boolean wizardInModal) {
            return new AnyObjectDirectoryPanel(id, this, wizardInModal);
        }
    }
}

