/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.soap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.soap.WebServiceConfiguration;
import net.tirasa.connid.bundles.soap.WebServiceConnection;
import net.tirasa.connid.bundles.soap.WebServiceFilterTranslator;
import net.tirasa.connid.bundles.soap.exceptions.ProvisioningException;
import net.tirasa.connid.bundles.soap.provisioning.interfaces.Provisioning;
import net.tirasa.connid.bundles.soap.to.WSAttribute;
import net.tirasa.connid.bundles.soap.to.WSAttributeValue;
import net.tirasa.connid.bundles.soap.to.WSChange;
import net.tirasa.connid.bundles.soap.to.WSUser;
import net.tirasa.connid.bundles.soap.utilities.AttributeType;
import net.tirasa.connid.bundles.soap.utilities.Operand;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedByteArray;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.AttributeInfoBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationalAttributeInfos;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SchemaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(displayNameKey="SOAP_CONNECTOR", configurationClass=WebServiceConfiguration.class)
public class WebServiceConnector
implements PoolableConnector,
AuthenticateOp,
CreateOp,
DeleteOp,
SchemaOp,
SearchOp<Operand>,
SyncOp,
TestOp,
UpdateOp,
ResolveUsernameOp {
    private static final Log LOG = Log.getLog(WebServiceConnector.class);
    private WebServiceConnection connection;
    private WebServiceConfiguration config;
    private Schema schema = null;
    private HashMap<String, WSAttribute> wsAttributes = null;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        LOG.ok("Connector initialization", new Object[0]);
        this.config = (WebServiceConfiguration)cfg;
        this.connection = new WebServiceConnection(this.config);
    }

    public void dispose() {
        LOG.ok("Dispose connector resources", new Object[0]);
        this.config = null;
        if (this.connection != null) {
            this.connection.dispose();
            this.connection = null;
        }
        WebServiceConnection.shutdownBus();
    }

    public void checkAlive() {
        LOG.ok("Connection test", new Object[0]);
        this.connection.test();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        LOG.ok("User uthentication", new Object[0]);
        if (objectClass == null || !objectClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (username == null || password == null) {
            throw new IllegalArgumentException("Invalid credentuals");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        try {
            return new Uid(provisioning.authenticate(username, password.toString()));
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("Authentication failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
    }

    public Uid create(ObjectClass objClass, Set<Attribute> attrs, OperationOptions options) {
        LOG.ok("Account creation", new Object[0]);
        if (objClass == null || !objClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (attrs == null || attrs.isEmpty()) {
            throw new IllegalArgumentException("No attribute specified");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        Name name = AttributeUtil.getNameFromAttributes(attrs);
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        LOG.ok("Account to be created: " + name.getNameValue(), new Object[0]);
        ArrayList<WSAttributeValue> attributes = new ArrayList<WSAttributeValue>();
        for (Attribute attr : attrs) {
            WSAttribute wsAttribute = new WSAttribute(attr.getName());
            if (attr.is(Name.NAME)) {
                wsAttribute.setKey(true);
                wsAttribute.setNullable(false);
            }
            if (attr.is(OperationalAttributeInfos.PASSWORD.getName())) {
                wsAttribute.setName(OperationalAttributeInfos.PASSWORD.getName());
                wsAttribute.setPassword(true);
            }
            if (LOG.isOk()) {
                LOG.ok("\nAttribute: \n\tName: " + wsAttribute.getName() + "\n\tType: " + wsAttribute.getType() + "\n\tIsKey: " + wsAttribute.isKey() + "\n\tIsPassword: " + wsAttribute.isPassword(), new Object[0]);
            }
            WSAttributeValue wsAttributeValue = new WSAttributeValue(wsAttribute);
            attributes.add(wsAttributeValue);
            List value = attr.getValue();
            if (value != null && value.size() == 1 && (value.get(0) instanceof GuardedString || value.get(0) instanceof GuardedByteArray)) {
                wsAttributeValue.addValue((Object)value.toString());
                continue;
            }
            wsAttributeValue.setValues(value);
        }
        LOG.ok("\nUser " + name.getNameValue() + "\n\tattributes: " + attributes.size(), new Object[0]);
        try {
            provisioning.create(attributes);
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("Creation failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
        return new Uid(name.getNameValue());
    }

    public void delete(ObjectClass objClass, Uid uid, OperationOptions options) {
        LOG.ok("Account deletion", new Object[0]);
        if (objClass == null || !objClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        try {
            provisioning.delete(uid.getUidValue());
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("Deletion failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
    }

    public Schema schema() {
        LOG.ok("Schema retrieving", new Object[0]);
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        if (this.wsAttributes != null) {
            this.wsAttributes.clear();
        }
        this.wsAttributes = new HashMap();
        HashSet<AttributeInfo> attributes = new HashSet<AttributeInfo>();
        List wsAttrs = provisioning.schema();
        for (WSAttribute attribute : wsAttrs) {
            this.wsAttributes.put(this.getAttributeName(attribute), attribute);
            if (LOG.isOk()) {
                LOG.ok("\nAttribute: \n\tName: " + attribute.getName() + "\n\tType: " + attribute.getType() + "\n\tIsKey: " + attribute.isKey() + "\n\tIsPassword: " + attribute.isPassword() + "\n\tIsNullable: " + attribute.isNullable(), new Object[0]);
            }
            try {
                attributes.add(this.buildAttribute(attribute));
            }
            catch (IllegalArgumentException ila) {
                LOG.error("Invalid attribute " + attribute.getName(), new Object[]{ila});
            }
        }
        SchemaBuilder schemaBld = new SchemaBuilder(this.getClass());
        ObjectClassInfoBuilder objectclassInfoBuilder = new ObjectClassInfoBuilder();
        objectclassInfoBuilder.setType(ObjectClass.ACCOUNT_NAME);
        objectclassInfoBuilder.addAllAttributeInfo(attributes);
        ObjectClassInfo objectclassInfo = objectclassInfoBuilder.build();
        schemaBld.defineObjectClass(objectclassInfo);
        if (!provisioning.isAuthenticationSupported().booleanValue()) {
            LOG.ok("Authentication is not supported.", new Object[0]);
            schemaBld.removeSupportedObjectClass(AuthenticateOp.class, objectclassInfo);
        }
        if (!provisioning.isSyncSupported().booleanValue()) {
            LOG.ok("Synchronization is not supported.", new Object[0]);
            schemaBld.removeSupportedObjectClass(SyncOp.class, objectclassInfo);
        }
        this.schema = schemaBld.build();
        return this.schema;
    }

    public FilterTranslator<Operand> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        if (oclass == null || !oclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        return new WebServiceFilterTranslator();
    }

    public void executeQuery(ObjectClass objClass, Operand query, ResultsHandler handler, OperationOptions options) {
        if (LOG.isOk()) {
            LOG.ok("Execute query: " + query, new Object[0]);
        }
        if (objClass == null || !objClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Invalid handler");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        try {
            List resultSet = provisioning.query(query);
            if (resultSet == null) {
                return;
            }
            boolean handle = true;
            Iterator i = resultSet.iterator();
            while (i.hasNext() && handle) {
                WSUser user = (WSUser)i.next();
                if (LOG.isOk()) {
                    LOG.ok("Found user: {0}", new Object[]{user});
                }
                try {
                    handle = handler.handle(this.buildConnectorObject(user.getAttributes()).build());
                    LOG.ok("Handle: {0}", new Object[]{handle});
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error building connector object for {0}", new Object[]{user});
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void test() {
        this.connection.test();
    }

    public Uid update(ObjectClass objclass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        if (objclass == null || !objclass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (uid == null) {
            throw new IllegalArgumentException("No uid specified");
        }
        if (replaceAttributes == null || replaceAttributes.isEmpty()) {
            throw new IllegalArgumentException("No attribute specified");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        ArrayList<WSAttributeValue> attributes = new ArrayList<WSAttributeValue>();
        for (Attribute attr : replaceAttributes) {
            WSAttribute wsAttribute = new WSAttribute(attr.getName());
            if (attr.is(Name.NAME)) {
                wsAttribute.setKey(true);
                wsAttribute.setNullable(false);
            }
            if (attr.is(OperationalAttributeInfos.PASSWORD.getName())) {
                wsAttribute.setName(OperationalAttributeInfos.PASSWORD.getName());
                wsAttribute.setPassword(true);
            }
            if (LOG.isOk()) {
                LOG.ok("\nAttribute: \n\tName: " + wsAttribute.getName() + "\n\tType: " + wsAttribute.getType() + "\n\tIsKey: " + wsAttribute.isKey() + "\n\tIsPassword: " + wsAttribute.isPassword(), new Object[0]);
            }
            WSAttributeValue wsAttributeValue = new WSAttributeValue(wsAttribute);
            attributes.add(wsAttributeValue);
            List value = attr.getValue();
            if (value != null && value.size() == 1 && (value.get(0) instanceof GuardedString || value.get(0) instanceof GuardedByteArray)) {
                wsAttributeValue.addValue((Object)value.toString());
                continue;
            }
            wsAttributeValue.setValues(value);
        }
        Uid uuid = null;
        try {
            uuid = new Uid(provisioning.update(uid.getUidValue(), attributes));
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("Update failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
        return uuid;
    }

    public void sync(ObjectClass objClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        if (objClass == null || !objClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (handler == null) {
            throw new IllegalArgumentException("Invalid handler");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        try {
            List changes = provisioning.sync();
            SyncDeltaBuilder sdb = null;
            boolean handle = true;
            Iterator i = changes.iterator();
            while (i.hasNext() && handle) {
                WSChange change = (WSChange)i.next();
                if (LOG.isOk()) {
                    LOG.ok("Found change {0}", new Object[]{change});
                }
                try {
                    sdb = this.buildSyncDelta(change);
                    handle = handler.handle(sdb.build());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e, "Error building connector object for change {0}", new Object[]{change});
                }
            }
        }
        catch (ProvisioningException e) {
            LOG.error("Synchronization failed", new Object[0]);
            throw new IllegalStateException(e);
        }
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        if (objectClass == null || !objectClass.equals((Object)ObjectClass.ACCOUNT)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        SyncToken token = null;
        try {
            token = new SyncToken((Object)provisioning.getLatestChangeNumber());
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("getLatestSyncToken failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
        return token;
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        if (objectClass == null) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        if (username == null) {
            throw new IllegalArgumentException("No username specified");
        }
        Provisioning provisioning = this.connection.getProvisioning();
        if (provisioning == null) {
            throw new IllegalStateException("Web Service client not found");
        }
        String uid = null;
        try {
            uid = provisioning.resolve(username);
        }
        catch (ProvisioningException e) {
            throw new ConnectorException("Resolve failed", (Throwable)e);
        }
        catch (Throwable t) {
            throw new ConnectorException("Communication exception", t);
        }
        Uid uuid = null;
        if (uid != null) {
            LOG.ok("Not able to resolve '" + username + "'", new Object[0]);
            uuid = new Uid(uid);
        }
        return uuid;
    }

    private AttributeInfo buildAttribute(WSAttribute attribute) {
        AttributeInfoBuilder builder = new AttributeInfoBuilder();
        try {
            if (attribute.isPassword()) {
                return OperationalAttributeInfos.PASSWORD;
            }
            if (attribute.isKey()) {
                builder.setName(Name.NAME);
                builder.setReadable(true);
                return builder.build();
            }
            Class.forName(AttributeType.valueOf((String)attribute.getType()).getClassName());
            builder.setName(attribute.getName());
            builder.setRequired(attribute.isNullable());
            return builder.build();
        }
        catch (ClassNotFoundException e) {
            LOG.error("Invalid data type", new Object[]{e});
            throw new IllegalArgumentException(e);
        }
        catch (Throwable t) {
            LOG.error("Unexpected exception", new Object[]{t});
            throw new IllegalArgumentException(t);
        }
    }

    private ConnectorObjectBuilder buildConnectorObject(Set<WSAttributeValue> attributes) {
        ConnectorObjectBuilder bld = new ConnectorObjectBuilder();
        String uid = null;
        for (WSAttributeValue attribute : attributes) {
            if (uid == null && (attribute.isKey() || Name.NAME.equals(attribute.getName()) || Uid.NAME.equals(attribute.getName()))) {
                uid = attribute.getStringValue();
                bld.setName(uid);
                bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attribute.getName(), (Collection)attribute.getValues())});
                continue;
            }
            if (OperationalAttributes.ENABLE_NAME.equals(attribute.getName())) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.buildEnabled((attribute.getValues() == null || attribute.getValues().isEmpty() || Boolean.parseBoolean(attribute.getValues().get(0).toString()) ? 1 : 0) != 0)});
                continue;
            }
            if (attribute.getValues() == null) {
                bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attribute.getName())});
                continue;
            }
            bld.addAttribute(new Attribute[]{AttributeBuilder.build((String)attribute.getName(), (Collection)attribute.getValues())});
        }
        if (uid == null) {
            throw new IllegalStateException("Invalid uid");
        }
        bld.setUid(new Uid(uid));
        bld.setObjectClass(ObjectClass.ACCOUNT);
        return bld;
    }

    private String getAttributeName(WSAttribute attribute) {
        String attributeName = null;
        if (attribute.isKey()) {
            attributeName = Name.NAME;
        }
        if (attribute.isPassword()) {
            attributeName = OperationalAttributeInfos.PASSWORD.getName();
        }
        if (!attribute.isKey() && !attribute.isPassword()) {
            attributeName = attribute.getName();
        }
        return attributeName;
    }

    private SyncDeltaBuilder buildSyncDelta(WSChange change) {
        SyncDeltaBuilder bld = new SyncDeltaBuilder();
        ConnectorObject object = this.buildConnectorObject(change.getAttributes()).build();
        bld.setToken(new SyncToken((Object)change.getId()));
        bld.setObject(object);
        if ("CREATE_OR_UPDATE".equalsIgnoreCase(change.getType())) {
            bld.setDeltaType(SyncDeltaType.CREATE_OR_UPDATE);
        } else if ("DELETE".equalsIgnoreCase(change.getType())) {
            bld.setDeltaType(SyncDeltaType.DELETE);
        }
        bld.setUid(object.getUid());
        return bld;
    }
}

