/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.core.behavior;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.googlecode.wicket.jquery.core.behavior.AjaxCallbackBehavior;
import com.googlecode.wicket.jquery.core.data.IChoiceProvider;
import com.googlecode.wicket.jquery.core.renderer.ITextRenderer;
import com.googlecode.wicket.jquery.core.template.IJQueryTemplate;
import com.googlecode.wicket.jquery.core.utils.ListUtils;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;

public abstract class ChoiceModelBehavior<T>
extends AjaxCallbackBehavior
implements IChoiceProvider<T> {
    private static final long serialVersionUID = 1L;
    protected static final String FILTER_VALUE = "filter[filters][0][value]";
    protected final ITextRenderer<? super T> renderer;
    protected final IJQueryTemplate template;

    protected ChoiceModelBehavior(ITextRenderer<? super T> renderer) {
        this(renderer, null);
    }

    protected ChoiceModelBehavior(ITextRenderer<? super T> renderer, IJQueryTemplate template) {
        this.renderer = renderer;
        this.template = template;
    }

    protected List<String> getProperties() {
        if (this.template != null) {
            return ListUtils.exclude(this.template.getTextProperties(), this.renderer.getFields());
        }
        return Collections.emptyList();
    }

    @Override
    protected String getResponse(IRequestParameters parameters) {
        JSONArray payload = new JSONArray();
        List choices = this.getChoices();
        if (choices != null) {
            for (Object choice : choices) {
                JSONObject object = this.renderer.render(choice);
                List<String> properties = this.getProperties();
                for (String property : properties) {
                    object.put(property, (Object)this.renderer.getText(choice, property));
                }
                payload.put((Object)object);
            }
        }
        return payload.toString();
    }
}

