/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.pac4j.authentication.clients;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.scribejava.core.model.Verb;
import com.nimbusds.jose.JWSAlgorithm;
import java.security.interfaces.ECPrivateKey;
import java.time.Period;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jBaseClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationBitBucketProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationCoreProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationDropboxProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationFacebookProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationFoursquareProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationGitHubProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationGoogleProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationHiOrgServerProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationLinkedInProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationPayPalProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationTwitterProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationWindowsLiveProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationWordpressProperties;
import org.apereo.cas.configuration.model.support.pac4j.Pac4jDelegatedAuthenticationYahooProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.BasePac4jOidcClientProperties;
import org.apereo.cas.configuration.model.support.pac4j.oidc.Pac4jOidcClientProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactory;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientFactoryCustomizer;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.RandomUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.crypto.PrivateKeyFactoryBean;
import org.apereo.cas.util.function.FunctionUtils;
import org.pac4j.cas.client.CasClient;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.IndirectClient;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.PathParameterCallbackUrlResolver;
import org.pac4j.core.http.callback.QueryParameterCallbackUrlResolver;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.oauth.client.BitbucketClient;
import org.pac4j.oauth.client.DropBoxClient;
import org.pac4j.oauth.client.FacebookClient;
import org.pac4j.oauth.client.FoursquareClient;
import org.pac4j.oauth.client.GenericOAuth20Client;
import org.pac4j.oauth.client.GitHubClient;
import org.pac4j.oauth.client.Google2Client;
import org.pac4j.oauth.client.HiOrgServerClient;
import org.pac4j.oauth.client.LinkedIn2Client;
import org.pac4j.oauth.client.PayPalClient;
import org.pac4j.oauth.client.TwitterClient;
import org.pac4j.oauth.client.WindowsLiveClient;
import org.pac4j.oauth.client.WordPressClient;
import org.pac4j.oauth.client.YahooClient;
import org.pac4j.oidc.client.AppleClient;
import org.pac4j.oidc.client.AzureAdClient;
import org.pac4j.oidc.client.GoogleOidcClient;
import org.pac4j.oidc.client.KeycloakOidcClient;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.AppleOidcConfiguration;
import org.pac4j.oidc.config.AzureAdOidcConfiguration;
import org.pac4j.oidc.config.KeycloakOidcConfiguration;
import org.pac4j.oidc.config.OidcConfiguration;
import org.pac4j.saml.client.SAML2Client;
import org.pac4j.saml.config.SAML2Configuration;
import org.pac4j.saml.metadata.DefaultSAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2MetadataSigner;
import org.pac4j.saml.metadata.SAML2ServiceProviderRequestedAttribute;
import org.pac4j.saml.metadata.XMLSecSAML2MetadataSigner;
import org.pac4j.saml.store.EmptyStoreFactory;
import org.pac4j.saml.store.HttpSessionStoreFactory;
import org.pac4j.saml.store.SAMLMessageStoreFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.core.io.Resource;

public abstract class BaseDelegatedClientFactory
implements DelegatedClientFactory {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDelegatedClientFactory.class);
    @Generated
    private final Object $lock = new Object[0];
    private static final Pattern PATTERN_LOGIN_URL = Pattern.compile("/login$");
    protected final CasConfigurationProperties casProperties;
    private final Collection<DelegatedClientFactoryCustomizer> customizers;
    private final CasSSLContext casSSLContext;
    private final ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory;
    private final Cache<String, Collection<IndirectClient>> clientsCache;

    protected abstract Collection<IndirectClient> loadClients();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Collection<IndirectClient> build() {
        Object object = this.$lock;
        synchronized (object) {
            Pac4jDelegatedAuthenticationCoreProperties core = this.casProperties.getAuthn().getPac4j().getCore();
            Collection<IndirectClient> currentClients = this.getCachedClients().isEmpty() || !core.isLazyInit() ? this.loadClients() : this.getCachedClients();
            this.clientsCache.put((Object)this.casProperties.getServer().getName(), currentClients);
            return currentClients;
        }
    }

    @Override
    public Collection<IndirectClient> rebuild() {
        this.clientsCache.invalidateAll();
        return this.build();
    }

    protected Collection<IndirectClient> getCachedClients() {
        Collection cachedClients = (Collection)this.clientsCache.getIfPresent((Object)this.casProperties.getServer().getName());
        return (Collection)ObjectUtils.defaultIfNull((Object)cachedClients, new ArrayList());
    }

    protected void configureClient(IndirectClient client, Pac4jBaseClientProperties clientProperties, CasConfigurationProperties givenProperties) {
        String cname = clientProperties.getClientName();
        if (StringUtils.isNotBlank((CharSequence)cname)) {
            client.setName(cname);
        } else {
            String className = client.getClass().getSimpleName();
            String genName = className.concat(RandomUtils.randomNumeric((int)4));
            client.setName(genName);
            LOGGER.warn("Client name for [{}] is set to a generated value of [{}]. Consider defining an explicit name for the delegated provider", (Object)className, (Object)genName);
        }
        Map customProperties = client.getCustomProperties();
        customProperties.put("autoRedirectType", clientProperties.getAutoRedirectType());
        if (StringUtils.isNotBlank((CharSequence)clientProperties.getPrincipalAttributeId())) {
            customProperties.put("principalAttributeId", clientProperties.getPrincipalAttributeId());
        }
        if (StringUtils.isNotBlank((CharSequence)clientProperties.getCssClass())) {
            customProperties.put("cssClass", clientProperties.getCssClass());
        }
        if (StringUtils.isNotBlank((CharSequence)clientProperties.getDisplayName())) {
            customProperties.put("displayName", clientProperties.getDisplayName());
        }
        String callbackUrl = StringUtils.defaultString((String)clientProperties.getCallbackUrl(), (String)this.casProperties.getServer().getLoginUrl());
        client.setCallbackUrl(callbackUrl);
        LOGGER.trace("Client [{}] will use the callback URL [{}]", (Object)client.getName(), (Object)callbackUrl);
        switch (clientProperties.getCallbackUrlType()) {
            case PATH_PARAMETER: {
                client.setCallbackUrlResolver((CallbackUrlResolver)new PathParameterCallbackUrlResolver());
                break;
            }
            case NONE: {
                client.setCallbackUrlResolver((CallbackUrlResolver)new NoParameterCallbackUrlResolver());
                break;
            }
            default: {
                client.setCallbackUrlResolver((CallbackUrlResolver)new QueryParameterCallbackUrlResolver());
            }
        }
        this.customizers.forEach(customizer -> customizer.customize(client));
        if (!givenProperties.getAuthn().getPac4j().getCore().isLazyInit()) {
            client.init();
        }
    }

    protected Collection<IndirectClient> buildFoursquareIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationFoursquareProperties foursquare = pac4jProperties.getFoursquare();
        if (foursquare.isEnabled() && StringUtils.isNotBlank((CharSequence)foursquare.getId()) && StringUtils.isNotBlank((CharSequence)foursquare.getSecret())) {
            FoursquareClient client = new FoursquareClient(foursquare.getId(), foursquare.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)foursquare, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildGoogleIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationGoogleProperties google = pac4jProperties.getGoogle();
        if (google.isEnabled() && StringUtils.isNotBlank((CharSequence)google.getId()) && StringUtils.isNotBlank((CharSequence)google.getSecret())) {
            Google2Client client = new Google2Client(google.getId(), google.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)google, casProperties);
            if (StringUtils.isNotBlank((CharSequence)google.getScope())) {
                client.setScope(Google2Client.Google2Scope.valueOf((String)google.getScope().toUpperCase()));
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildFacebookIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationFacebookProperties fb = pac4jProperties.getFacebook();
        if (fb.isEnabled() && StringUtils.isNotBlank((CharSequence)fb.getId()) && StringUtils.isNotBlank((CharSequence)fb.getSecret())) {
            FacebookClient client = new FacebookClient(fb.getId(), fb.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)fb, casProperties);
            if (StringUtils.isNotBlank((CharSequence)fb.getScope())) {
                client.setScope(fb.getScope());
            }
            if (StringUtils.isNotBlank((CharSequence)fb.getFields())) {
                client.setFields(fb.getFields());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildLinkedInIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationLinkedInProperties ln = pac4jProperties.getLinkedIn();
        if (ln.isEnabled() && StringUtils.isNotBlank((CharSequence)ln.getId()) && StringUtils.isNotBlank((CharSequence)ln.getSecret())) {
            LinkedIn2Client client = new LinkedIn2Client(ln.getId(), ln.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)ln, casProperties);
            if (StringUtils.isNotBlank((CharSequence)ln.getScope())) {
                client.setScope(ln.getScope());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildGitHubIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationGitHubProperties github = pac4jProperties.getGithub();
        if (github.isEnabled() && StringUtils.isNotBlank((CharSequence)github.getId()) && StringUtils.isNotBlank((CharSequence)github.getSecret())) {
            GitHubClient client = new GitHubClient(github.getId(), github.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)github, casProperties);
            if (StringUtils.isNotBlank((CharSequence)github.getScope())) {
                client.setScope(github.getScope());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildDropBoxIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationDropboxProperties db = pac4jProperties.getDropbox();
        if (db.isEnabled() && StringUtils.isNotBlank((CharSequence)db.getId()) && StringUtils.isNotBlank((CharSequence)db.getSecret())) {
            DropBoxClient client = new DropBoxClient(db.getId(), db.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)db, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildWindowsLiveIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationWindowsLiveProperties live = pac4jProperties.getWindowsLive();
        if (live.isEnabled() && StringUtils.isNotBlank((CharSequence)live.getId()) && StringUtils.isNotBlank((CharSequence)live.getSecret())) {
            WindowsLiveClient client = new WindowsLiveClient(live.getId(), live.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)live, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildYahooIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationYahooProperties yahoo = pac4jProperties.getYahoo();
        if (yahoo.isEnabled() && StringUtils.isNotBlank((CharSequence)yahoo.getId()) && StringUtils.isNotBlank((CharSequence)yahoo.getSecret())) {
            YahooClient client = new YahooClient(yahoo.getId(), yahoo.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)yahoo, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildHiOrgServerIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationHiOrgServerProperties hiOrgServer = pac4jProperties.getHiOrgServer();
        if (hiOrgServer.isEnabled() && StringUtils.isNotBlank((CharSequence)hiOrgServer.getId()) && StringUtils.isNotBlank((CharSequence)hiOrgServer.getSecret())) {
            HiOrgServerClient client = new HiOrgServerClient(hiOrgServer.getId(), hiOrgServer.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)hiOrgServer, casProperties);
            if (StringUtils.isNotBlank((CharSequence)hiOrgServer.getScope())) {
                client.getConfiguration().setScope(hiOrgServer.getScope());
            }
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildOAuth20IdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getOauth2().stream().filter(oauth -> oauth.isEnabled() && StringUtils.isNotBlank((CharSequence)oauth.getId()) && StringUtils.isNotBlank((CharSequence)oauth.getSecret())).map(oauth -> {
            GenericOAuth20Client client = new GenericOAuth20Client();
            client.setProfileId((String)StringUtils.defaultIfBlank((CharSequence)oauth.getPrincipalAttributeId(), (CharSequence)pac4jProperties.getCore().getPrincipalAttributeId()));
            client.setKey(oauth.getId());
            client.setSecret(oauth.getSecret());
            client.setProfileAttrs(oauth.getProfileAttrs());
            client.setProfileNodePath(oauth.getProfilePath());
            client.setProfileUrl(oauth.getProfileUrl());
            client.setProfileVerb(Verb.valueOf((String)oauth.getProfileVerb().toUpperCase()));
            client.setTokenUrl(oauth.getTokenUrl());
            client.setAuthUrl(oauth.getAuthUrl());
            client.setScope(oauth.getScope());
            client.setCustomParams(oauth.getCustomParams());
            client.setWithState(oauth.isWithState());
            String clientAuthenticationMethod = oauth.getClientAuthenticationMethod();
            if (StringUtils.isNotBlank((CharSequence)clientAuthenticationMethod)) {
                client.setClientAuthenticationMethod(clientAuthenticationMethod);
            }
            client.getConfiguration().setResponseType(oauth.getResponseType());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)oauth, casProperties);
            LOGGER.debug("Created client [{}]", (Object)client);
            return client;
        }).collect(Collectors.toList());
    }

    protected Collection<IndirectClient> buildOidcIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getOidc().stream().map(oidc -> this.getOidcClientFrom((Pac4jOidcClientProperties)oidc, casProperties)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected Collection<IndirectClient> buildWordpressIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationWordpressProperties wp = pac4jProperties.getWordpress();
        if (wp.isEnabled() && StringUtils.isNotBlank((CharSequence)wp.getId()) && StringUtils.isNotBlank((CharSequence)wp.getSecret())) {
            WordPressClient client = new WordPressClient(wp.getId(), wp.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)wp, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildTwitterIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationTwitterProperties twitter = pac4jProperties.getTwitter();
        if (twitter.isEnabled() && StringUtils.isNotBlank((CharSequence)twitter.getId()) && StringUtils.isNotBlank((CharSequence)twitter.getSecret())) {
            TwitterClient client = new TwitterClient(twitter.getId(), twitter.getSecret(), twitter.isIncludeEmail());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)twitter, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    private OidcClient getOidcClientFrom(Pac4jOidcClientProperties clientProperties, CasConfigurationProperties casProperties) {
        if (clientProperties.getAzure().isEnabled() && StringUtils.isNotBlank((CharSequence)clientProperties.getAzure().getId())) {
            LOGGER.debug("Building OpenID Connect client for Azure AD...");
            AzureAdOidcConfiguration azure = BaseDelegatedClientFactory.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getAzure(), AzureAdOidcConfiguration.class);
            azure.setTenant(clientProperties.getAzure().getTenant());
            AzureAdOidcConfiguration cfg = new AzureAdOidcConfiguration((OidcConfiguration)azure);
            AzureAdClient azureClient = new AzureAdClient(cfg);
            this.configureClient((IndirectClient)azureClient, (Pac4jBaseClientProperties)clientProperties.getAzure(), casProperties);
            return azureClient;
        }
        if (clientProperties.getGoogle().isEnabled() && StringUtils.isNotBlank((CharSequence)clientProperties.getGoogle().getId())) {
            LOGGER.debug("Building OpenID Connect client for Google...");
            OidcConfiguration cfg = BaseDelegatedClientFactory.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getGoogle(), OidcConfiguration.class);
            GoogleOidcClient googleClient = new GoogleOidcClient(cfg);
            this.configureClient((IndirectClient)googleClient, (Pac4jBaseClientProperties)clientProperties.getGoogle(), casProperties);
            return googleClient;
        }
        if (clientProperties.getKeycloak().isEnabled() && StringUtils.isNotBlank((CharSequence)clientProperties.getKeycloak().getId())) {
            LOGGER.debug("Building OpenID Connect client for KeyCloak...");
            KeycloakOidcConfiguration cfg = BaseDelegatedClientFactory.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getKeycloak(), KeycloakOidcConfiguration.class);
            cfg.setRealm(clientProperties.getKeycloak().getRealm());
            cfg.setBaseUri(clientProperties.getKeycloak().getBaseUri());
            KeycloakOidcClient kc = new KeycloakOidcClient(cfg);
            this.configureClient((IndirectClient)kc, (Pac4jBaseClientProperties)clientProperties.getKeycloak(), casProperties);
            return kc;
        }
        if (clientProperties.getApple().isEnabled() && StringUtils.isNotBlank((CharSequence)clientProperties.getApple().getPrivateKey())) {
            LOGGER.debug("Building OpenID Connect client for Apple...");
            AppleOidcConfiguration cfg = BaseDelegatedClientFactory.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getApple(), AppleOidcConfiguration.class);
            FunctionUtils.doUnchecked(u -> {
                PrivateKeyFactoryBean factory = new PrivateKeyFactoryBean();
                factory.setAlgorithm("EC");
                factory.setSingleton(false);
                factory.setLocation((Resource)ResourceUtils.getResourceFrom((String)clientProperties.getApple().getPrivateKey()));
                cfg.setPrivateKey((ECPrivateKey)factory.getObject());
            }, (Object[])new Object[0]);
            cfg.setPrivateKeyID(clientProperties.getApple().getPrivateKeyId());
            cfg.setTeamID(clientProperties.getApple().getTeamId());
            cfg.setTimeout(Beans.newDuration((String)clientProperties.getApple().getTimeout()));
            AppleClient kc = new AppleClient(cfg);
            this.configureClient((IndirectClient)kc, (Pac4jBaseClientProperties)clientProperties.getApple(), casProperties);
            return kc;
        }
        if (clientProperties.getGeneric().isEnabled()) {
            LOGGER.debug("Building generic OpenID Connect client...");
            OidcConfiguration generic = BaseDelegatedClientFactory.getOidcConfigurationForClient((BasePac4jOidcClientProperties)clientProperties.getGeneric(), OidcConfiguration.class);
            OidcClient oc = new OidcClient(generic);
            this.configureClient((IndirectClient)oc, (Pac4jBaseClientProperties)clientProperties.getGeneric(), casProperties);
            return oc;
        }
        return null;
    }

    protected Collection<IndirectClient> buildPaypalIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationPayPalProperties paypal = pac4jProperties.getPaypal();
        if (paypal.isEnabled() && StringUtils.isNotBlank((CharSequence)paypal.getId()) && StringUtils.isNotBlank((CharSequence)paypal.getSecret())) {
            PayPalClient client = new PayPalClient(paypal.getId(), paypal.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)paypal, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    private static <T extends OidcConfiguration> T getOidcConfigurationForClient(BasePac4jOidcClientProperties oidc, Class<T> clazz) {
        OidcConfiguration cfg = (OidcConfiguration)FunctionUtils.doUnchecked(() -> (OidcConfiguration)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)oidc.getScope())) {
            cfg.setScope(oidc.getScope());
        }
        cfg.setUseNonce(oidc.isUseNonce());
        cfg.setDisablePkce(oidc.isDisablePkce());
        cfg.setSecret(oidc.getSecret());
        cfg.setClientId(oidc.getId());
        cfg.setReadTimeout((int)Beans.newDuration((String)oidc.getReadTimeout()).toMillis());
        cfg.setConnectTimeout((int)Beans.newDuration((String)oidc.getConnectTimeout()).toMillis());
        if (StringUtils.isNotBlank((CharSequence)oidc.getPreferredJwsAlgorithm())) {
            cfg.setPreferredJwsAlgorithm(JWSAlgorithm.parse((String)oidc.getPreferredJwsAlgorithm().toUpperCase()));
        }
        cfg.setMaxClockSkew(Long.valueOf(Beans.newDuration((String)oidc.getMaxClockSkew()).toSeconds()).intValue());
        cfg.setDiscoveryURI(oidc.getDiscoveryUri());
        cfg.setCustomParams(oidc.getCustomParams());
        cfg.setLogoutUrl(oidc.getLogoutUrl());
        cfg.setAllowUnsignedIdTokens(oidc.isAllowUnsignedIdTokens());
        cfg.setIncludeAccessTokenClaimsInProfile(oidc.isIncludeAccessTokenClaims());
        cfg.setExpireSessionWithToken(oidc.isExpireSessionWithToken());
        if (StringUtils.isNotBlank((CharSequence)oidc.getTokenExpirationAdvance())) {
            cfg.setTokenExpirationAdvance((int)Beans.newDuration((String)oidc.getTokenExpirationAdvance()).toSeconds());
        }
        if (StringUtils.isNotBlank((CharSequence)oidc.getResponseMode())) {
            cfg.setResponseMode(oidc.getResponseMode());
        }
        if (StringUtils.isNotBlank((CharSequence)oidc.getResponseType())) {
            cfg.setResponseType(oidc.getResponseType());
        }
        if (!oidc.getMappedClaims().isEmpty()) {
            cfg.setMappedClaims(CollectionUtils.convertDirectedListToMap((Collection)oidc.getMappedClaims()));
        }
        return (T)cfg;
    }

    protected Collection<IndirectClient> buildSaml2IdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getSaml().stream().filter(saml -> saml.isEnabled() && StringUtils.isNotBlank((CharSequence)saml.getKeystorePath()) && StringUtils.isNotBlank((CharSequence)saml.getIdentityProviderMetadataPath()) && StringUtils.isNotBlank((CharSequence)saml.getServiceProviderEntityId()) && StringUtils.isNotBlank((CharSequence)saml.getServiceProviderMetadataPath())).map(saml -> {
            List mappedAttributes;
            SAML2Configuration cfg = new SAML2Configuration(saml.getKeystorePath(), saml.getKeystorePassword(), saml.getPrivateKeyPassword(), saml.getIdentityProviderMetadataPath());
            cfg.setForceKeystoreGeneration(saml.isForceKeystoreGeneration());
            if (saml.getCertificateExpirationDays() > 0) {
                cfg.setCertificateExpirationPeriod(Period.ofDays(saml.getCertificateExpirationDays()));
            }
            FunctionUtils.doIfNotNull((Object)saml.getCertificateSignatureAlg(), arg_0 -> ((SAML2Configuration)cfg).setCertificateSignatureAlg(arg_0));
            cfg.setCertificateNameToAppend((String)StringUtils.defaultIfBlank((CharSequence)saml.getCertificateNameToAppend(), (CharSequence)saml.getClientName()));
            cfg.setMaximumAuthenticationLifetime(Beans.newDuration((String)saml.getMaximumAuthenticationLifetime()).toSeconds());
            cfg.setServiceProviderEntityId(saml.getServiceProviderEntityId());
            cfg.setServiceProviderMetadataPath(saml.getServiceProviderMetadataPath());
            cfg.setAuthnRequestBindingType(saml.getDestinationBinding());
            cfg.setSpLogoutRequestBindingType(saml.getLogoutRequestBinding());
            cfg.setForceAuth(saml.isForceAuth());
            cfg.setPassive(saml.isPassive());
            cfg.setSignMetadata(saml.isSignServiceProviderMetadata());
            SAML2MetadataSigner signer = (SAML2MetadataSigner)FunctionUtils.doIf((boolean)StringUtils.equalsIgnoreCase((CharSequence)saml.getMetadataSignerStrategy(), (CharSequence)"default"), () -> new DefaultSAML2MetadataSigner(cfg), () -> new XMLSecSAML2MetadataSigner(cfg)).get();
            cfg.setMetadataSigner(signer);
            cfg.setAuthnRequestSigned(saml.isSignAuthnRequest());
            cfg.setSpLogoutRequestSigned(saml.isSignServiceProviderLogoutRequest());
            cfg.setAcceptedSkew(Beans.newDuration((String)saml.getAcceptedSkew()).toSeconds());
            cfg.setSslSocketFactory(this.casSSLContext.getSslContext().getSocketFactory());
            cfg.setHostnameVerifier(this.casSSLContext.getHostnameVerifier());
            if (StringUtils.isNotBlank((CharSequence)saml.getPrincipalIdAttribute())) {
                cfg.setAttributeAsId(saml.getPrincipalIdAttribute());
            }
            cfg.setWantsAssertionsSigned(saml.isWantsAssertionsSigned());
            cfg.setWantsResponsesSigned(saml.isWantsResponsesSigned());
            cfg.setAllSignatureValidationDisabled(saml.isAllSignatureValidationDisabled());
            cfg.setUseNameQualifier(saml.isUseNameQualifier());
            cfg.setAttributeConsumingServiceIndex(saml.getAttributeConsumingServiceIndex());
            Optional.ofNullable((SAMLMessageStoreFactory)this.samlMessageStoreFactory.getIfAvailable()).ifPresentOrElse(arg_0 -> ((SAML2Configuration)cfg).setSamlMessageStoreFactory(arg_0), () -> {
                FunctionUtils.doIf((boolean)saml.getMessageStoreFactory().equalsIgnoreCase("EMPTY"), ig -> cfg.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new EmptyStoreFactory())).accept(saml);
                FunctionUtils.doIf((boolean)saml.getMessageStoreFactory().equalsIgnoreCase("SESSION"), ig -> cfg.setSamlMessageStoreFactory((SAMLMessageStoreFactory)new HttpSessionStoreFactory())).accept(saml);
                if (saml.getMessageStoreFactory().contains(".")) {
                    FunctionUtils.doAndHandle(unused -> {
                        Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getMessageStoreFactory());
                        SAMLMessageStoreFactory factory = (SAMLMessageStoreFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        cfg.setSamlMessageStoreFactory(factory);
                    });
                }
            });
            if (saml.getAssertionConsumerServiceIndex() >= 0) {
                cfg.setAssertionConsumerServiceIndex(saml.getAssertionConsumerServiceIndex());
            }
            if (!saml.getAuthnContextClassRef().isEmpty()) {
                cfg.setComparisonType(saml.getAuthnContextComparisonType().toUpperCase());
                cfg.setAuthnContextClassRefs(saml.getAuthnContextClassRef());
            }
            if (StringUtils.isNotBlank((CharSequence)saml.getKeystoreAlias())) {
                cfg.setKeystoreAlias(saml.getKeystoreAlias());
            }
            if (StringUtils.isNotBlank((CharSequence)saml.getNameIdPolicyFormat())) {
                cfg.setNameIdPolicyFormat(saml.getNameIdPolicyFormat());
            }
            if (!saml.getRequestedAttributes().isEmpty()) {
                saml.getRequestedAttributes().stream().map(attribute -> new SAML2ServiceProviderRequestedAttribute(attribute.getName(), attribute.getFriendlyName(), attribute.getNameFormat(), attribute.isRequired())).forEach(attribute -> cfg.getRequestedServiceProviderAttributes().add(attribute));
            }
            if (!saml.getBlockedSignatureSigningAlgorithms().isEmpty()) {
                cfg.setBlackListedSignatureSigningAlgorithms((Collection)saml.getBlockedSignatureSigningAlgorithms());
            }
            if (!saml.getSignatureAlgorithms().isEmpty()) {
                cfg.setSignatureAlgorithms(saml.getSignatureAlgorithms());
            }
            if (!saml.getSignatureReferenceDigestMethods().isEmpty()) {
                cfg.setSignatureReferenceDigestMethods(saml.getSignatureReferenceDigestMethods());
            }
            if (!StringUtils.isNotBlank((CharSequence)saml.getSignatureCanonicalizationAlgorithm())) {
                cfg.setSignatureCanonicalizationAlgorithm(saml.getSignatureCanonicalizationAlgorithm());
            }
            cfg.setProviderName(saml.getProviderName());
            cfg.setNameIdPolicyAllowCreate(saml.getNameIdPolicyAllowCreate().toBoolean());
            if (StringUtils.isNotBlank((CharSequence)saml.getSaml2AttributeConverter())) {
                FunctionUtils.doAndHandle(__ -> {
                    Class clazz = ClassUtils.getClass((ClassLoader)this.getClass().getClassLoader(), (String)saml.getSaml2AttributeConverter());
                    AttributeConverter converter = (AttributeConverter)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    cfg.setSamlAttributeConverter(converter);
                });
            }
            if (!(mappedAttributes = saml.getMappedAttributes()).isEmpty()) {
                cfg.setMappedAttributes(CollectionUtils.convertDirectedListToMap((Collection)mappedAttributes));
            }
            SAML2Client client = new SAML2Client(cfg);
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)saml, casProperties);
            LOGGER.debug("Created delegated client [{}]", (Object)client);
            return client;
        }).collect(Collectors.toList());
    }

    protected Collection<IndirectClient> buildBitBucketIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        Pac4jDelegatedAuthenticationBitBucketProperties bb = pac4jProperties.getBitbucket();
        if (bb.isEnabled() && StringUtils.isNotBlank((CharSequence)bb.getId()) && StringUtils.isNotBlank((CharSequence)bb.getSecret())) {
            BitbucketClient client = new BitbucketClient(bb.getId(), bb.getSecret());
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)bb, casProperties);
            LOGGER.debug("Created client [{}] with identifier [{}]", (Object)client.getName(), (Object)client.getKey());
            return List.of(client);
        }
        return List.of();
    }

    protected Collection<IndirectClient> buildCasIdentityProviders(CasConfigurationProperties casProperties) {
        Pac4jDelegatedAuthenticationProperties pac4jProperties = casProperties.getAuthn().getPac4j();
        return pac4jProperties.getCas().stream().filter(cas -> cas.isEnabled() && StringUtils.isNotBlank((CharSequence)cas.getLoginUrl())).map(cas -> {
            CasConfiguration cfg = new CasConfiguration(cas.getLoginUrl(), CasProtocol.valueOf((String)cas.getProtocol()));
            String prefix = PATTERN_LOGIN_URL.matcher(cas.getLoginUrl()).replaceFirst("/");
            cfg.setPrefixUrl(StringUtils.appendIfMissing((String)prefix, (CharSequence)"/", (CharSequence[])new CharSequence[0]));
            cfg.setHostnameVerifier(this.casSSLContext.getHostnameVerifier());
            cfg.setSslSocketFactory(this.casSSLContext.getSslContext().getSocketFactory());
            CasClient client = new CasClient(cfg);
            this.configureClient((IndirectClient)client, (Pac4jBaseClientProperties)cas, casProperties);
            LOGGER.debug("Created client [{}]", (Object)client);
            return client;
        }).collect(Collectors.toList());
    }

    protected Set<IndirectClient> buildAllIdentityProviders(CasConfigurationProperties properties) {
        LinkedHashSet<IndirectClient> newClients = new LinkedHashSet<IndirectClient>();
        newClients.addAll(this.buildCasIdentityProviders(properties));
        newClients.addAll(this.buildFacebookIdentityProviders(properties));
        newClients.addAll(this.buildOidcIdentityProviders(properties));
        newClients.addAll(this.buildOAuth20IdentityProviders(properties));
        newClients.addAll(this.buildSaml2IdentityProviders(properties));
        newClients.addAll(this.buildTwitterIdentityProviders(properties));
        newClients.addAll(this.buildDropBoxIdentityProviders(properties));
        newClients.addAll(this.buildFoursquareIdentityProviders(properties));
        newClients.addAll(this.buildGitHubIdentityProviders(properties));
        newClients.addAll(this.buildGoogleIdentityProviders(properties));
        newClients.addAll(this.buildWindowsLiveIdentityProviders(properties));
        newClients.addAll(this.buildYahooIdentityProviders(properties));
        newClients.addAll(this.buildLinkedInIdentityProviders(properties));
        newClients.addAll(this.buildPaypalIdentityProviders(properties));
        newClients.addAll(this.buildWordpressIdentityProviders(properties));
        newClients.addAll(this.buildBitBucketIdentityProviders(properties));
        newClients.addAll(this.buildHiOrgServerIdentityProviders(properties));
        return newClients;
    }

    @Generated
    public BaseDelegatedClientFactory(CasConfigurationProperties casProperties, Collection<DelegatedClientFactoryCustomizer> customizers, CasSSLContext casSSLContext, ObjectProvider<SAMLMessageStoreFactory> samlMessageStoreFactory, Cache<String, Collection<IndirectClient>> clientsCache) {
        this.casProperties = casProperties;
        this.customizers = customizers;
        this.casSSLContext = casSSLContext;
        this.samlMessageStoreFactory = samlMessageStoreFactory;
        this.clientsCache = clientsCache;
    }
}

