/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.resource.FileSystemPathService;
import org.apache.wicket.resource.FileSystemResource;

public class FileSystemResourceReference
extends ResourceReference {
    private static final long serialVersionUID = 1L;
    private Path path;

    public FileSystemResourceReference(String name, Path path) {
        super(name);
        this.path = path;
    }

    public FileSystemResourceReference(String name) {
        super(name);
    }

    public FileSystemResourceReference(Class<?> scope, String name) {
        super(scope, name);
    }

    @Override
    public IResource getResource() {
        return this.getFileSystemResource();
    }

    protected FileSystemResource getFileSystemResource() {
        if (this.path == null) {
            throw new WicketRuntimeException("Please override #getResource() and provide a path if using a constructor which doesn't take one as argument.");
        }
        return new FileSystemResource(this.path);
    }

    public static Path getPath(URI uri, Map<String, String> env) {
        for (FileSystemPathService pathService : ServiceLoader.load(FileSystemPathService.class)) {
            Path fileSystemPath;
            if (!pathService.isResponsible(uri) || (fileSystemPath = pathService.getPath(uri, env)) == null) continue;
            return fileSystemPath;
        }
        return Paths.get(uri);
    }

    public static Path getPath(URI uri) throws IOException, URISyntaxException {
        return FileSystemResourceReference.getPath(uri, null);
    }
}

