/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.panels;

import de.agilecoders.wicket.core.markup.html.bootstrap.tabs.AjaxBootstrapTabbedPanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.commons.ITabComponent;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.panels.SCIMConfEnterpriseUserPanel;
import org.apache.syncope.client.console.panels.SCIMConfExtensionAnyObjectPanel;
import org.apache.syncope.client.console.panels.SCIMConfExtensionGroupPanel;
import org.apache.syncope.client.console.panels.SCIMConfExtensionUserPanel;
import org.apache.syncope.client.console.panels.SCIMConfGeneralPanel;
import org.apache.syncope.client.console.panels.SCIMConfGroupPanel;
import org.apache.syncope.client.console.panels.SCIMConfUserPanel;
import org.apache.syncope.client.console.rest.AnyTypeRestClient;
import org.apache.syncope.client.console.rest.SCIMConfRestClient;
import org.apache.syncope.client.console.wizards.WizardMgtPanel;
import org.apache.syncope.common.lib.scim.SCIMConf;
import org.apache.syncope.common.lib.to.AnyTypeTO;
import org.apache.syncope.common.lib.types.AnyTypeKind;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCIMConfPanel
extends WizardMgtPanel<SCIMConf> {
    private static final long serialVersionUID = -1100228004207271270L;
    protected static final Logger LOG = LoggerFactory.getLogger(SCIMConfPanel.class);
    @SpringBean
    protected SCIMConfRestClient scimConfRestClient;
    @SpringBean
    protected AnyTypeRestClient anyTypeRestClient;
    protected final SCIMConf scimConf;

    public SCIMConfPanel(String id, SCIMConf scimConf, final PageReference pageRef) {
        super(id, true);
        this.scimConf = scimConf;
        this.pageRef = pageRef;
        AjaxBootstrapTabbedPanel tabbedPanel = new AjaxBootstrapTabbedPanel("tabbedPanel", this.buildTabList());
        tabbedPanel.setSelectedTab(0);
        this.addInnerObject(new Component[]{tabbedPanel});
        AjaxLink<String> saveButton = new AjaxLink<String>("saveButton"){
            private static final long serialVersionUID = -7978723352517770644L;

            public void onClick(AjaxRequestTarget target) {
                try {
                    SCIMConfPanel.this.scimConfRestClient.set(SCIMConfPanel.this.scimConf);
                    SyncopeConsoleSession.get().success((Serializable)((Object)this.getString("operation_succeeded")));
                }
                catch (Exception e) {
                    LOG.error("While setting SCIM configuration", (Throwable)e);
                    SyncopeConsoleSession.get().onException(e);
                }
                ((BasePage)pageRef.getPage()).getNotificationPanel().refresh((IPartialPageRequestHandler)target);
            }
        };
        this.addInnerObject(new Component[]{saveButton});
        this.setShowResultPanel(true);
    }

    protected List<ITab> buildTabList() {
        ArrayList<ITab> tabs = new ArrayList<ITab>();
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab1"))), new String[]{this.getString("tab1")}){
            private static final long serialVersionUID = -5861786415855103549L;

            public Panel getPanel(String panelId) {
                return new SCIMConfGeneralPanel(panelId, SCIMConfPanel.this.scimConf);
            }
        });
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab2"))), new String[]{this.getString("tab2")}){
            private static final long serialVersionUID = 1998052474181916792L;

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfUserPanel(panelId, SCIMConfPanel.this.scimConf);
            }
        });
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab3"))), new String[]{this.getString("tab3")}){
            private static final long serialVersionUID = 1998052474181916792L;

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfEnterpriseUserPanel(panelId, SCIMConfPanel.this.scimConf);
            }
        });
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab4"))), new String[]{this.getString("tab4")}){
            private static final long serialVersionUID = 6645614456650987567L;

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfExtensionUserPanel(panelId, SCIMConfPanel.this.scimConf, AnyTypeKind.USER.name());
            }
        });
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab5"))), new String[]{this.getString("tab5")}){
            private static final long serialVersionUID = 1998052474181916792L;

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfGroupPanel(panelId, SCIMConfPanel.this.scimConf);
            }
        });
        tabs.add((ITab)new ITabComponent((IModel)new Model((Serializable)((Object)this.getString("tab6"))), new String[]{this.getString("tab6")}){
            private static final long serialVersionUID = -7858187494595192532L;

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfExtensionGroupPanel(panelId, SCIMConfPanel.this.scimConf, AnyTypeKind.GROUP.name());
            }
        });
        this.anyTypeRestClient.listAnyTypes().stream().filter(anyTypeTO -> AnyTypeKind.ANY_OBJECT.equals((Object)anyTypeTO.getKind())).forEach(anyTypeTO -> tabs.add((ITab)new ITabComponent((IModel)new ResourceModel("anyType." + anyTypeTO.getKey(), anyTypeTO.getKey()), new String[0], (AnyTypeTO)anyTypeTO){
            private static final long serialVersionUID = 6429988338658964324L;
            final /* synthetic */ AnyTypeTO val$anyTypeTO;
            {
                this.val$anyTypeTO = anyTypeTO;
                super(title, roles);
            }

            public WebMarkupContainer getPanel(String panelId) {
                return new SCIMConfExtensionAnyObjectPanel(panelId, SCIMConfPanel.this.scimConf, this.val$anyTypeTO.getKey());
            }
        }));
        return tabs;
    }
}

