/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.scim.common.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.scim.common.SCIMConnectorConfiguration;
import net.tirasa.connid.bundles.scim.common.dto.AbstractSCIMBaseResource;
import net.tirasa.connid.bundles.scim.common.dto.BaseResourceReference;
import net.tirasa.connid.bundles.scim.common.dto.SCIMBaseMeta;
import net.tirasa.connid.bundles.scim.common.dto.SCIMGroup;
import net.tirasa.connid.bundles.scim.common.utils.SCIMAttributeUtils;
import net.tirasa.connid.bundles.scim.common.utils.SCIMUtils;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;

public class AbstractSCIMGroup<MT extends SCIMBaseMeta>
extends AbstractSCIMBaseResource<MT>
implements SCIMGroup<MT> {
    private static final long serialVersionUID = 328618763364322821L;
    @JsonProperty
    protected String displayName;
    protected final List<BaseResourceReference> members = new ArrayList<BaseResourceReference>();

    public AbstractSCIMGroup() {
    }

    protected AbstractSCIMGroup(String schemaUri, MT meta) {
        super(meta);
        this.baseSchema = schemaUri;
        this.schemas.add(this.baseSchema);
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public List<BaseResourceReference> getMembers() {
        return this.members;
    }

    @Override
    @JsonIgnore
    public Set<Attribute> toAttributes(Class<?> type, SCIMConnectorConfiguration configuration) throws IllegalArgumentException, IllegalAccessException {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        SCIMUtils.getAllFieldsList(type).stream().filter(f -> !"LOG".equals(f.getName()) && !"serialVersionUID".equals(f.getName()) && !"RESOURCE_NAME".equals(f.getName()) && !"SCHEMA_URI".equals(f.getName())).forEach(field -> {
            try {
                field.setAccessible(true);
                if (!field.isAnnotationPresent(JsonIgnore.class) && !SCIMUtils.isEmptyObject(field.get(this))) {
                    Object objInstance = field.get(this);
                    if (field.getGenericType().toString().contains(SCIMBaseMeta.class.getName())) {
                        if (field.getType().equals(List.class)) {
                            List list = (List)objInstance;
                            for (SCIMBaseMeta scimMeta : list) {
                                SCIMAttributeUtils.addAttribute(scimMeta.toAttributes(), attrs, field.getType());
                            }
                        } else {
                            SCIMAttributeUtils.addAttribute(((SCIMBaseMeta)SCIMBaseMeta.class.cast(objInstance)).toAttributes(), attrs, field.getType());
                        }
                    } else {
                        attrs.add(SCIMAttributeUtils.buildAttributeFromClassField(field, this).build());
                    }
                }
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e, "Unable to build user attributes by reflection", new Object[0]);
            }
        });
        return attrs;
    }

    @Override
    @JsonIgnore
    public void fromAttributes(Set<Attribute> attributes, boolean replaceMembersOnUpdate) {
        attributes.stream().filter(attribute -> !CollectionUtil.isEmpty((Collection)attribute.getValue())).forEach(attribute -> {
            try {
                this.doSetAttribute(attribute.getName(), attribute.getValue(), replaceMembersOnUpdate);
            }
            catch (Exception e) {
                LOG.warn((Throwable)e, "While populating User field from ConnId attribute: {0}", new Object[]{attribute});
            }
        });
    }

    @JsonIgnore
    private void doSetAttribute(String name, List<Object> values, boolean replaceMembersOnUpdate) {
        if ("displayName".equals(name)) {
            this.displayName = (String)String.class.cast(values.get(0));
        } else if ("members".equals(name)) {
            if (replaceMembersOnUpdate) {
                this.members.clear();
            }
            values.forEach(value -> this.members.add(new BaseResourceReference.Builder().value(value.toString()).build()));
        }
    }
}

