/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;

public class ExpressionList
implements ItemsList {
    private List<Expression> expressions;
    private boolean usingBrackets = true;

    public boolean isUsingBrackets() {
        return this.usingBrackets;
    }

    public void setUsingBrackets(boolean bl2) {
        this.usingBrackets = bl2;
    }

    public ExpressionList withUsingBrackets(boolean bl2) {
        this.setUsingBrackets(bl2);
        return this;
    }

    public ExpressionList() {
    }

    public ExpressionList(List<Expression> list) {
        this.expressions = list;
    }

    public ExpressionList(Expression ... expressionArray) {
        this.expressions = new ArrayList<Expression>(Arrays.asList(expressionArray));
    }

    public List<Expression> getExpressions() {
        return this.expressions;
    }

    public ExpressionList addExpressions(Expression ... expressionArray) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        Collections.addAll(list, expressionArray);
        return this.withExpressions(list);
    }

    public ExpressionList withExpressions(List<Expression> list) {
        this.setExpressions(list);
        return this;
    }

    public void setExpressions(List<Expression> list) {
        this.expressions = list;
    }

    @Deprecated
    public ExpressionList withBrackets(boolean bl2) {
        return this.withUsingBrackets(bl2);
    }

    @Override
    public void accept(ItemsListVisitor itemsListVisitor) {
        itemsListVisitor.visit(this);
    }

    public String toString() {
        return PlainSelect.getStringList(this.expressions, true, this.usingBrackets);
    }

    public ExpressionList addExpressions(Collection<? extends Expression> collection) {
        List list = Optional.ofNullable(this.getExpressions()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withExpressions(list);
    }
}

