/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational;

import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.SupportsOldOracleJoinSyntax;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;

public class InExpression
extends ASTNodeAccessImpl
implements Expression,
SupportsOldOracleJoinSyntax {
    private Expression leftExpression;
    private ItemsList rightItemsList;
    private boolean not = false;
    private Expression rightExpression;
    private int oldOracleJoinSyntax = 0;

    public InExpression() {
    }

    public InExpression(Expression expression, ItemsList itemsList) {
        this.setLeftExpression(expression);
        this.setRightItemsList(itemsList);
    }

    @Override
    public void setOldOracleJoinSyntax(int n2) {
        this.oldOracleJoinSyntax = n2;
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("unexpected join type for oracle found with IN (type=" + n2 + ")");
        }
    }

    @Override
    public int getOldOracleJoinSyntax() {
        return this.oldOracleJoinSyntax;
    }

    public ItemsList getRightItemsList() {
        return this.rightItemsList;
    }

    public Expression getLeftExpression() {
        return this.leftExpression;
    }

    public InExpression withRightItemsList(ItemsList itemsList) {
        this.setRightItemsList(itemsList);
        return this;
    }

    public final void setRightItemsList(ItemsList itemsList) {
        this.rightItemsList = itemsList;
    }

    public InExpression withLeftExpression(Expression expression) {
        this.setLeftExpression(expression);
        return this;
    }

    public final void setLeftExpression(Expression expression) {
        this.leftExpression = expression;
    }

    public boolean isNot() {
        return this.not;
    }

    public void setNot(boolean bl2) {
        this.not = bl2;
    }

    public Expression getRightExpression() {
        return this.rightExpression;
    }

    public void setRightExpression(Expression expression) {
        this.rightExpression = expression;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    private String getLeftExpressionString() {
        return this.leftExpression + (this.oldOracleJoinSyntax == 1 ? "(+)" : "");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getLeftExpressionString());
        stringBuilder.append(" ");
        if (this.not) {
            stringBuilder.append("NOT ");
        }
        stringBuilder.append("IN ");
        if (this.rightExpression == null) {
            stringBuilder.append(this.rightItemsList);
        } else {
            stringBuilder.append(this.rightExpression);
        }
        return stringBuilder.toString();
    }

    @Override
    public int getOraclePriorPosition() {
        return 0;
    }

    @Override
    public void setOraclePriorPosition(int n2) {
        if (n2 != 0) {
            throw new IllegalArgumentException("unexpected prior for oracle found");
        }
    }

    public InExpression withRightExpression(Expression expression) {
        this.setRightExpression(expression);
        return this;
    }

    @Override
    public InExpression withOldOracleJoinSyntax(int n2) {
        this.setOldOracleJoinSyntax(n2);
        return this;
    }

    @Override
    public InExpression withOraclePriorPosition(int n2) {
        this.setOraclePriorPosition(n2);
        return this;
    }

    public InExpression withNot(boolean bl2) {
        this.setNot(bl2);
        return this;
    }

    public <E extends ItemsList> E getRightItemsList(Class<E> clazz) {
        return (E)((ItemsList)clazz.cast(this.getRightItemsList()));
    }

    public <E extends Expression> E getLeftExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getLeftExpression()));
    }

    public <E extends Expression> E getRightExpression(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getRightExpression()));
    }
}

