/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.schema;

import java.io.File;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.schema.ReferenceCounter;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.lib.meta.SourceTracker;

public class Sequence
extends ReferenceCounter
implements Comparable<Sequence>,
SourceTracker {
    private static final long serialVersionUID = 1L;
    private DBIdentifier _name = DBIdentifier.NULL;
    private Schema _schema = null;
    private DBIdentifier _schemaName = DBIdentifier.NULL;
    private int _initial = 1;
    private int _increment = 1;
    private int _cache = 0;
    private int _lineNum = 0;
    private int _colNum = 0;
    private QualifiedDBIdentifier _fullPath = null;
    private File _source = null;
    private int _srcType = 0;

    public Sequence() {
    }

    @Deprecated
    public Sequence(String name, Schema schema) {
        this(DBIdentifier.newSequence(name), schema);
    }

    public Sequence(DBIdentifier name, Schema schema) {
        this.setIdentifier(name);
        if (schema != null) {
            this.setSchemaIdentifier(schema.getIdentifier());
        }
        this._schema = schema;
    }

    void remove() {
        this._schema = null;
        this._fullPath = null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getSchemaName() {
        return this.getSchemaIdentifier().getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schemaName == null ? DBIdentifier.NULL : this._schemaName;
    }

    @Deprecated
    public void setSchemaName(String name) {
        this.setSchemaIdentifier(DBIdentifier.newSchema(name));
    }

    public void setSchemaIdentifier(DBIdentifier name) {
        if (this.getSchema() != null) {
            throw new IllegalStateException();
        }
        this._schemaName = name;
        this._fullPath = null;
    }

    @Deprecated
    public String getName() {
        return this.getIdentifier().getName();
    }

    public DBIdentifier getIdentifier() {
        return this._name == null ? DBIdentifier.NULL : this._name;
    }

    @Deprecated
    public void setName(String name) {
        this.setIdentifier(DBIdentifier.newSequence(name));
    }

    public void setIdentifier(DBIdentifier name) {
        if (this.getSchema() != null) {
            throw new IllegalStateException();
        }
        this._name = name;
        this._fullPath = null;
    }

    @Deprecated
    public String getFullName() {
        return this.getFullIdentifier().getName();
    }

    public DBIdentifier getFullIdentifier() {
        return this.getQualifiedPath().getIdentifier();
    }

    public QualifiedDBIdentifier getQualifiedPath() {
        if (this._fullPath == null) {
            this._fullPath = QualifiedDBIdentifier.newPath(this._schemaName, this._name);
        }
        return this._fullPath;
    }

    public int getInitialValue() {
        return this._initial;
    }

    public void setInitialValue(int initial) {
        this._initial = initial;
    }

    public int getIncrement() {
        return this._increment;
    }

    public void setIncrement(int increment) {
        this._increment = increment;
    }

    public int getAllocate() {
        return this._cache;
    }

    public void setAllocate(int cache) {
        this._cache = cache;
    }

    public File getSourceFile() {
        return this._source;
    }

    public Object getSourceScope() {
        return null;
    }

    public int getSourceType() {
        return this._srcType;
    }

    public void setSource(File source, int srcType) {
        this._source = source;
        this._srcType = srcType;
    }

    public String getResourceName() {
        return this.getFullIdentifier().getName();
    }

    @Override
    public int compareTo(Sequence other) {
        DBIdentifier name = this.getIdentifier();
        DBIdentifier otherName = other.getIdentifier();
        if (DBIdentifier.isNull(name) && DBIdentifier.isNull(otherName)) {
            return 0;
        }
        if (DBIdentifier.isNull(name)) {
            return 1;
        }
        if (DBIdentifier.isNull(otherName)) {
            return -1;
        }
        return name.compareTo(otherName);
    }

    public String toString() {
        return this.getFullIdentifier().getName();
    }

    public int getLineNumber() {
        return this._lineNum;
    }

    public void setLineNumber(int lineNum) {
        this._lineNum = lineNum;
    }

    public int getColNumber() {
        return this._colNum;
    }

    public void setColNumber(int colNum) {
        this._colNum = colNum;
    }
}

