/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPRuntimeException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.LogSyntaxMessages;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.RedactedValueException;
import com.unboundid.ldap.sdk.unboundidds.logs.v2.syntax.TokenizedValueException;
import com.unboundid.util.Base64;
import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.CryptoHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import java.security.MessageDigest;
import java.util.LinkedList;

@NotExtensible
@ThreadSafety(level=ThreadSafetyLevel.INTERFACE_THREADSAFE)
public abstract class LogFieldSyntax<T> {
    protected static final int CARRIAGE_RETURN_CODE_POINT = 13;
    protected static final int DOUBLE_QUOTE_CODE_POINT = 34;
    protected static final int NEWLINE_CODE_POINT = 10;
    protected static final int OCTOTHORPE_CODE_POINT = 35;
    protected static final int TAB_CODE_POINT = 9;
    @NotNull
    public static final String REDACTED_STRING = "{REDACTED}";
    @NotNull
    public static final String TOKEN_PREFIX_STRING = "{TOKENIZED:";
    @NotNull
    public static final String TOKEN_SUFFIX_STRING = "}";
    @NotNull
    private static final String TOKEN_DIGEST_ALGORITHM = "SHA-256";
    private static final int TOKEN_DIGEST_BYTES_LENGTH = 12;
    private final int maxStringLengthCharacters;
    @NotNull
    private final ThreadLocal<LinkedList<ByteStringBuffer>> threadLocalBuffers;
    @NotNull
    private final ThreadLocal<MessageDigest> threadLocalDigests;

    protected LogFieldSyntax(int maxStringLengthCharacters) {
        this.maxStringLengthCharacters = maxStringLengthCharacters;
        this.threadLocalBuffers = new ThreadLocal();
        this.threadLocalDigests = new ThreadLocal();
    }

    protected int getMaxStringLengthCharacters() {
        return this.maxStringLengthCharacters;
    }

    @NotNull
    public abstract String getSyntaxName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String valueToSanitizedString(@NotNull T value) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.valueToSanitizedString(value, buffer);
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    public abstract void valueToSanitizedString(@NotNull T var1, @NotNull ByteStringBuffer var2);

    public abstract void logSanitizedFieldToTextFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull ByteStringBuffer var3);

    public abstract void logSanitizedFieldToJSONFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull JSONBuffer var3);

    public abstract void logSanitizedValueToJSONFormattedLog(@NotNull T var1, @NotNull JSONBuffer var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final String sanitize(@NotNull String string) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.sanitize(string, buffer);
            String string2 = buffer.toString();
            return string2;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    protected final void sanitize(@NotNull String string, @NotNull ByteStringBuffer buffer) {
        int codePoint;
        int numCharsToTruncate;
        int numCharsToExamine;
        int stringLength = string.length();
        if (stringLength > this.maxStringLengthCharacters) {
            numCharsToExamine = this.maxStringLengthCharacters;
            numCharsToTruncate = stringLength - this.maxStringLengthCharacters;
        } else {
            numCharsToExamine = stringLength;
            numCharsToTruncate = 0;
        }
        block7: for (int pos = 0; pos < numCharsToExamine; pos += Character.charCount(codePoint)) {
            codePoint = string.codePointAt(pos);
            switch (codePoint) {
                case 34: {
                    buffer.append((byte)39);
                    continue block7;
                }
                case 10: {
                    buffer.append("\\n");
                    continue block7;
                }
                case 13: {
                    buffer.append("\\r");
                    continue block7;
                }
                case 9: {
                    buffer.append("\\t");
                    continue block7;
                }
                case 35: {
                    buffer.append("#23");
                    continue block7;
                }
                default: {
                    if (StaticUtils.isLikelyDisplayableCharacter(codePoint)) {
                        buffer.appendCodePoint(codePoint);
                        continue block7;
                    }
                    for (byte b : StaticUtils.getBytesForCodePoint(codePoint)) {
                        buffer.append('#');
                        StaticUtils.toHex(b, buffer);
                    }
                }
            }
        }
        if (numCharsToTruncate > 0) {
            if (numCharsToTruncate == 1) {
                buffer.append(LogSyntaxMessages.INFO_LOG_SYNTAX_TRUNCATED_1_CHAR.get());
            } else {
                buffer.append(LogSyntaxMessages.INFO_LOG_SYNTAX_TRUNCATED_CHARS.get(numCharsToTruncate));
            }
        }
    }

    @NotNull
    public abstract T parseValue(@NotNull String var1) throws RedactedValueException, TokenizedValueException, LogSyntaxException;

    public boolean valueStringIsCompletelyRedacted(@NotNull String valueString) {
        return valueString.equals(REDACTED_STRING);
    }

    public abstract boolean completelyRedactedValueConformsToSyntax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String redactEntireValue() {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.redactEntireValue(buffer);
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    public void redactEntireValue(@NotNull ByteStringBuffer buffer) {
        buffer.append(REDACTED_STRING);
    }

    public abstract void logCompletelyRedactedFieldToTextFormattedLog(@NotNull String var1, @NotNull ByteStringBuffer var2);

    public abstract void logCompletelyRedactedFieldToJSONFormattedLog(@NotNull String var1, @NotNull JSONBuffer var2);

    public abstract void logCompletelyRedactedValueToJSONFormattedLog(@NotNull JSONBuffer var1);

    public abstract boolean supportsRedactedComponents();

    public boolean valueStringIncludesRedactedComponent(@NotNull String valueString) {
        return valueString.contains(REDACTED_STRING);
    }

    public abstract boolean valueWithRedactedComponentsConformsToSyntax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String redactComponents(@NotNull T value) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.redactComponents(value, buffer);
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    public void redactComponents(@NotNull T value, @NotNull ByteStringBuffer buffer) {
        this.redactEntireValue(buffer);
    }

    public abstract void logRedactedComponentsFieldToTextFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull ByteStringBuffer var3);

    public abstract void logRedactedComponentsFieldToJSONFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull JSONBuffer var3);

    public abstract void logRedactedComponentsValueToJSONFormattedLog(@NotNull T var1, @NotNull JSONBuffer var2);

    public boolean valueStringIsCompletelyTokenized(@NotNull String valueString) {
        return valueString.startsWith(TOKEN_PREFIX_STRING) && valueString.endsWith(TOKEN_SUFFIX_STRING) && valueString.indexOf(TOKEN_PREFIX_STRING, TOKEN_PREFIX_STRING.length()) < 0;
    }

    public abstract boolean completelyTokenizedValueConformsToSyntax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String tokenizeEntireValue(@NotNull T value, @NotNull byte[] pepper) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.tokenizeEntireValue(value, pepper, buffer);
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    public abstract void tokenizeEntireValue(@NotNull T var1, @NotNull byte[] var2, @NotNull ByteStringBuffer var3);

    public abstract void logCompletelyTokenizedFieldToTextFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull byte[] var3, @NotNull ByteStringBuffer var4);

    public abstract void logCompletelyTokenizedFieldToJSONFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull byte[] var3, @NotNull JSONBuffer var4);

    public abstract void logCompletelyTokenizedValueToJSONFormattedLog(@NotNull T var1, @NotNull byte[] var2, @NotNull JSONBuffer var3);

    public abstract boolean supportsTokenizedComponents();

    public boolean valueStringIncludesTokenizedComponent(@NotNull String valueString) {
        int tokenStartPos = valueString.indexOf(TOKEN_PREFIX_STRING);
        return tokenStartPos >= 0 && valueString.indexOf(TOKEN_SUFFIX_STRING, TOKEN_PREFIX_STRING.length()) > 0;
    }

    public abstract boolean valueWithTokenizedComponentsConformsToSyntax();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String tokenizeComponents(@NotNull T value, @NotNull byte[] pepper) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.tokenizeComponents(value, pepper, buffer);
            String string = buffer.toString();
            return string;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    public void tokenizeComponents(@NotNull T value, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.tokenizeEntireValue(value, pepper, buffer);
    }

    public abstract void logTokenizedComponentsFieldToTextFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull byte[] var3, @NotNull ByteStringBuffer var4);

    public abstract void logTokenizedComponentsFieldToJSONFormattedLog(@NotNull String var1, @NotNull T var2, @NotNull byte[] var3, @NotNull JSONBuffer var4);

    public abstract void logTokenizedComponentsValueToJSONFormattedLog(@NotNull T var1, @NotNull byte[] var2, @NotNull JSONBuffer var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected final String tokenize(@NotNull String string, @NotNull byte[] pepper) {
        ByteStringBuffer buffer = this.getTemporaryBuffer();
        try {
            this.tokenize(string, pepper, buffer);
            String string2 = buffer.toString();
            return string2;
        }
        finally {
            this.releaseTemporaryBuffer(buffer);
        }
    }

    protected final void tokenize(@NotNull String string, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        this.tokenize(StaticUtils.getBytes(string), pepper, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void tokenize(@NotNull byte[] bytes, @NotNull byte[] pepper, @NotNull ByteStringBuffer buffer) {
        ByteStringBuffer concatBuffer = this.getTemporaryBuffer();
        try {
            concatBuffer.append(bytes);
            concatBuffer.append(pepper);
            byte[] digestBytes = this.sha256(concatBuffer);
            buffer.append(TOKEN_PREFIX_STRING);
            Base64.urlEncode(digestBytes, 0, 12, buffer, false);
            buffer.append(TOKEN_SUFFIX_STRING);
        }
        finally {
            this.releaseTemporaryBuffer(concatBuffer);
        }
    }

    @NotNull
    protected final byte[] sha256(@NotNull ByteStringBuffer buffer) {
        MessageDigest digest = this.threadLocalDigests.get();
        if (digest == null) {
            try {
                digest = CryptoHelper.getMessageDigest(TOKEN_DIGEST_ALGORITHM);
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPRuntimeException(new LDAPException(ResultCode.ENCODING_ERROR, LogSyntaxMessages.ERR_LOG_SYNTAX_TOKENIZE_DIGEST_ERROR.get(TOKEN_DIGEST_ALGORITHM), e));
            }
        }
        digest.update(buffer.getBackingArray(), 0, buffer.length());
        return digest.digest();
    }

    @NotNull
    protected ByteStringBuffer getTemporaryBuffer() {
        LinkedList<ByteStringBuffer> bufferList = this.threadLocalBuffers.get();
        if (bufferList == null) {
            bufferList = new LinkedList();
            this.threadLocalBuffers.set(bufferList);
        }
        if (bufferList.isEmpty()) {
            return new ByteStringBuffer();
        }
        return bufferList.remove();
    }

    protected void releaseTemporaryBuffer(@NotNull ByteStringBuffer buffer) {
        buffer.clear();
        LinkedList<ByteStringBuffer> bufferList = this.threadLocalBuffers.get();
        if (bufferList == null) {
            bufferList = new LinkedList();
            this.threadLocalBuffers.set(bufferList);
        }
        bufferList.add(buffer);
    }
}

