/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.sysds.runtime.compress.colgroup.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.QDictionary;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.KahanFunction;
import org.apache.sysds.runtime.instructions.cp.KahanObject;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;

public abstract class ADictionary {
    public abstract double[] getValues();

    public abstract double getValue(int var1);

    public abstract int hasZeroTuple(int var1);

    public abstract long getInMemorySize();

    public abstract double aggregate(double var1, Builtin var3);

    public abstract int getValuesLength();

    public abstract ADictionary apply(ScalarOperator var1);

    public abstract ADictionary applyScalarOp(ScalarOperator var1, double var2, int var4);

    public abstract ADictionary clone();

    public void aggregateCols(double[] c, Builtin fn, int[] colIndexes) {
        int ncol = colIndexes.length;
        int vlen = this.getValuesLength() / ncol;
        for (int k = 0; k < vlen; ++k) {
            int valOff = k * ncol;
            for (int j = 0; j < ncol; ++j) {
                c[colIndexes[j]] = fn.execute(c[colIndexes[j]], this.getValue(valOff + j));
            }
        }
    }

    public static ADictionary read(DataInput in, boolean lossy) throws IOException {
        return lossy ? QDictionary.read(in) : Dictionary.read(in);
    }

    public abstract void write(DataOutput var1) throws IOException;

    public abstract long getExactSizeOnDisk();

    public abstract int getNumberOfValues(int var1);

    protected abstract double[] sumAllRowsToDouble(KahanFunction var1, KahanObject var2, int var3);

    protected abstract double sumRow(int var1, KahanFunction var2, KahanObject var3, int var4);

    protected abstract void colSum(double[] var1, int[] var2, int[] var3, KahanFunction var4);

    protected abstract double sum(int[] var1, int var2, KahanFunction var3);
}

