/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.File;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.History$;
import org.apache.spark.internal.config.History$HybridStoreDiskBackend$;
import org.apache.spark.status.KVUtils;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreSerializer;
import org.apache.spark.util.kvstore.KVStoreView;
import org.apache.spark.util.kvstore.LevelDB;
import org.apache.spark.util.kvstore.RocksDB;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.reflect.ClassTag;
import scala.reflect.package$;
import scala.runtime.BoxesRunTime;

public final class KVUtils$
implements Logging {
    public static KVUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new KVUtils$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Enumeration.Value backend(SparkConf conf) {
        return History$HybridStoreDiskBackend$.MODULE$.withName(conf.get(History$.MODULE$.HYBRID_STORE_DISK_BACKEND()));
    }

    public <M> KVStore open(File path, M metadata, SparkConf conf, ClassTag<M> evidence$1) {
        LevelDB levelDB;
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "Metadata is required.");
        Enumeration.Value value = this.backend(conf);
        Enumeration.Value value2 = History$HybridStoreDiskBackend$.MODULE$.LEVELDB();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            levelDB = new LevelDB(path, (KVStoreSerializer)new KVUtils.KVStoreScalaSerializer());
        } else {
            Enumeration.Value value4 = History$HybridStoreDiskBackend$.MODULE$.ROCKSDB();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                levelDB = new RocksDB(path, (KVStoreSerializer)new KVUtils.KVStoreScalaSerializer());
            } else {
                throw new MatchError((Object)value);
            }
        }
        LevelDB db = levelDB;
        Object dbMeta = db.getMetadata(package$.MODULE$.classTag(evidence$1).runtimeClass());
        if (dbMeta == null) {
            db.setMetadata(metadata);
        } else if (!BoxesRunTime.equals((Object)dbMeta, metadata)) {
            db.close();
            throw new KVUtils.MetadataMismatchException();
        }
        return db;
    }

    public <T> Seq<T> viewToSeq(KVStoreView<T> view, int max, Function1<T, Object> filter) {
        List list;
        try (KVStoreIterator iter = view.closeableIterator();){
            list = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)iter).asScala()).filter(filter).take(max).toList();
        }
        return list;
    }

    private KVUtils$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

