/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.fedplanner;

import java.util.Map;
import org.apache.sysds.common.Types;
import org.apache.sysds.hops.AggBinaryOp;
import org.apache.sysds.hops.AggUnaryOp;
import org.apache.sysds.hops.BinaryOp;
import org.apache.sysds.hops.DataOp;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.TernaryOp;
import org.apache.sysds.hops.fedplanner.FTypes;
import org.apache.sysds.hops.ipa.FunctionCallGraph;
import org.apache.sysds.hops.ipa.FunctionCallSizeInfo;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.MMTSJ;
import org.apache.sysds.parser.DMLProgram;
import org.apache.sysds.parser.FunctionStatementBlock;
import org.apache.sysds.runtime.controlprogram.LocalVariableMap;

public abstract class AFederatedPlanner {
    public abstract void rewriteProgram(DMLProgram var1, FunctionCallGraph var2, FunctionCallSizeInfo var3);

    public abstract void rewriteFunctionDynamic(FunctionStatementBlock var1, LocalVariableMap var2);

    protected boolean allowsFederated(Hop hop, Map<Long, FTypes.FType> fedHops) {
        FTypes.FType[] ft = new FTypes.FType[hop.getInput().size()];
        for (int i = 0; i < hop.getInput().size(); ++i) {
            ft[i] = fedHops.get(hop.getInput(i).getHopID());
        }
        return this.allowsFederated(hop, ft);
    }

    protected boolean allowsFederated(Hop hop, FTypes.FType[] ft) {
        if (hop instanceof AggBinaryOp) {
            return ft[0] != null && ft[1] == null || ft[0] == null && ft[1] != null || ft[0] == FTypes.FType.COL && ft[1] == FTypes.FType.ROW;
        }
        if (hop instanceof BinaryOp && !hop.getDataType().isScalar()) {
            return ft[0] != null && ft[1] == null || ft[0] == null && ft[1] != null || ft[0] != null && ft[0] == ft[1];
        }
        if (hop instanceof TernaryOp && !hop.getDataType().isScalar()) {
            return ft[0] != null || ft[1] != null || ft[2] != null;
        }
        if (HopRewriteUtils.isReorg(hop, Types.ReOrgOp.TRANS)) {
            return ft[0] == FTypes.FType.COL || ft[0] == FTypes.FType.ROW;
        }
        if (HopRewriteUtils.isData(hop, Types.OpOpData.FEDERATED) || HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTWRITE) || HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTREAD)) {
            return true;
        }
        if (ft.length == 1 && ft[0] != null) {
            return HopRewriteUtils.isReorg(hop, Types.ReOrgOp.TRANS) || HopRewriteUtils.isAggUnaryOp(hop, Types.AggOp.SUM, Types.AggOp.MIN, Types.AggOp.MAX);
        }
        return false;
    }

    protected FTypes.FType getFederatedOut(Hop hop, Map<Long, FTypes.FType> fedHops) {
        FTypes.FType[] ft = new FTypes.FType[hop.getInput().size()];
        for (int i = 0; i < hop.getInput().size(); ++i) {
            ft[i] = fedHops.get(hop.getInput(i).getHopID());
        }
        return this.getFederatedOut(hop, ft);
    }

    protected FTypes.FType getFederatedOut(Hop hop, FTypes.FType[] ft) {
        if (hop.isScalar()) {
            return null;
        }
        if (hop instanceof AggBinaryOp) {
            MMTSJ.MMTSJType mmtsj = ((AggBinaryOp)hop).checkTransposeSelf();
            if (mmtsj != MMTSJ.MMTSJType.NONE && (mmtsj.isLeft() && ft[0] == FTypes.FType.ROW || mmtsj.isRight() && ft[0] == FTypes.FType.COL)) {
                return FTypes.FType.BROADCAST;
            }
            if (ft[0] != null) {
                return ft[0] == FTypes.FType.ROW ? FTypes.FType.ROW : null;
            }
        } else {
            if (hop instanceof BinaryOp) {
                return ft[0] != null ? ft[0] : ft[1];
            }
            if (hop instanceof TernaryOp) {
                return ft[0] != null ? ft[0] : (ft[1] != null ? ft[1] : ft[2]);
            }
            if (HopRewriteUtils.isReorg(hop, Types.ReOrgOp.TRANS)) {
                if (ft[0] == FTypes.FType.ROW) {
                    return FTypes.FType.COL;
                }
                if (ft[0] == FTypes.FType.COL) {
                    return FTypes.FType.ROW;
                }
            } else if (hop instanceof AggUnaryOp) {
                boolean isColAgg = ((AggUnaryOp)hop).getDirection().isCol();
                if (ft[0] == FTypes.FType.ROW && isColAgg || ft[0] == FTypes.FType.COL && !isColAgg) {
                    return null;
                }
                if (ft[0] == FTypes.FType.ROW || ft[0] == FTypes.FType.COL) {
                    return ft[0];
                }
            } else {
                if (HopRewriteUtils.isData(hop, Types.OpOpData.FEDERATED)) {
                    return this.deriveFType((DataOp)hop);
                }
                if (HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTWRITE) || HopRewriteUtils.isData(hop, Types.OpOpData.TRANSIENTREAD)) {
                    return ft[0];
                }
            }
        }
        return null;
    }

    protected FTypes.FType deriveFType(DataOp fedInit) {
        Hop ranges = fedInit.getInput(fedInit.getParameterIndex("ranges"));
        boolean rowPartitioned = true;
        boolean colPartitioned = true;
        for (int i = 0; i < ranges.getInput().size() / 2; ++i) {
            Hop beg = ranges.getInput(2 * i);
            Hop end = ranges.getInput(2 * i + 1);
            long rl = HopRewriteUtils.getIntValueSafe(beg.getInput(0));
            long ru = HopRewriteUtils.getIntValueSafe(end.getInput(0));
            long cl = HopRewriteUtils.getIntValueSafe(beg.getInput(1));
            long cu = HopRewriteUtils.getIntValueSafe(end.getInput(1));
            rowPartitioned &= cu - cl == fedInit.getDim2();
            colPartitioned &= ru - rl == fedInit.getDim1();
        }
        return rowPartitioned && colPartitioned ? FTypes.FType.FULL : (rowPartitioned ? FTypes.FType.ROW : (colPartitioned ? FTypes.FType.COL : FTypes.FType.OTHER));
    }
}

