/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.bitmap;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.bitmap.ABitmap;
import org.apache.sysds.runtime.compress.utils.IntArrayList;

public final class MultiColBitmap
extends ABitmap {
    private double[][] _values;

    protected MultiColBitmap(IntArrayList[] offsetsLists, double[][] values, int rows) {
        super(offsetsLists, rows);
        this._values = values;
    }

    public double[] getValues(int ix) {
        return this._values[ix];
    }

    @Override
    public int getNumNonZerosInOffset(int idx) {
        int nz = 0;
        for (double v : this.getValues(idx)) {
            nz += v == 0.0 ? 0 : 1;
        }
        return nz;
    }

    @Override
    public int getNumColumns() {
        return this._values[0].length;
    }

    @Override
    protected void addToString(StringBuilder sb) {
        sb.append("\nValues:");
        for (double[] vv : this._values) {
            sb.append("\n" + Arrays.toString(vv));
        }
    }
}

