/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.indexes;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.sysds.runtime.compress.colgroup.indexes.AColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.ColIndexFactory;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.colgroup.indexes.IIterate;
import org.apache.sysds.runtime.compress.colgroup.indexes.RangeIndex;
import org.apache.sysds.utils.MemoryEstimates;

public class ArrayIndex
extends AColIndex {
    private final int[] cols;

    public ArrayIndex(int[] cols) {
        this.cols = cols;
    }

    @Override
    public int size() {
        return this.cols.length;
    }

    @Override
    public int get(int i) {
        return this.cols[i];
    }

    @Override
    public IColIndex shift(int i) {
        int[] ret = new int[this.cols.length];
        for (int j = 0; j < this.cols.length; ++j) {
            ret[j] = this.cols[j] + i;
        }
        return new ArrayIndex(ret);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(IColIndex.ColIndexType.ARRAY.ordinal());
        out.writeInt(this.cols.length);
        for (int i = 0; i < this.cols.length; ++i) {
            out.writeInt(this.cols[i]);
        }
    }

    public static ArrayIndex read(DataInput in) throws IOException {
        int size = in.readInt();
        int[] cols = new int[size];
        for (int i = 0; i < size; ++i) {
            cols[i] = in.readInt();
        }
        return new ArrayIndex(cols);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 5 + 4 * this.cols.length;
    }

    @Override
    public long estimateInMemorySize() {
        return ArrayIndex.estimateInMemorySizeStatic(this.cols.length);
    }

    public static long estimateInMemorySizeStatic(int nCol) {
        return 16L + (long)MemoryEstimates.intArrayCost(nCol);
    }

    @Override
    public IIterate iterator() {
        return new ArrayIterator();
    }

    @Override
    public int findIndex(int i) {
        return Arrays.binarySearch(this.cols, i);
    }

    @Override
    public boolean isContiguous() {
        return false;
    }

    @Override
    public IColIndex.SliceResult slice(int l, int u) {
        if (l == 0 && u > this.cols[this.cols.length - 1]) {
            return new IColIndex.SliceResult(0, this.cols.length, this);
        }
        int s = Arrays.binarySearch(this.cols, l);
        int e = Arrays.binarySearch(this.cols, u);
        s = s < 0 ? Math.abs(s + 1) : s;
        int n = e = e < 0 ? Math.abs(e + 1) : e;
        if (s == e) {
            return new IColIndex.SliceResult(0, 0, null);
        }
        int[] retArr = new int[e - s];
        if (l == 0) {
            retArr = Arrays.copyOfRange(this.cols, s, e);
        } else {
            int i = s;
            int j = 0;
            while (i < e) {
                retArr[j] = this.cols[i] - l;
                ++i;
                ++j;
            }
        }
        IColIndex.SliceResult ret = new IColIndex.SliceResult(s, e, ColIndexFactory.create(retArr));
        return ret;
    }

    @Override
    public boolean equals(IColIndex other) {
        if (other.size() == this.size()) {
            if (other instanceof ArrayIndex) {
                ArrayIndex ot = (ArrayIndex)other;
                int[] otV = ot.cols;
                return Arrays.equals(this.cols, otV);
            }
            if (other instanceof RangeIndex) {
                return other.get(0) == this.cols[0] && other.get(this.size() - 1) == this.cols[this.size() - 1];
            }
            for (int i = 0; i < this.size(); ++i) {
                if (other.get(i) == this.cols[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public IColIndex combine(IColIndex other) {
        int sr = other.size();
        int sl = this.size();
        int[] ret = new int[sr + sl];
        int pl = 0;
        int pr = 0;
        int i = 0;
        while (pl < sl && pr < sr) {
            int vr;
            int vl = this.get(pl);
            if (vl < (vr = other.get(pr))) {
                ret[i++] = vl;
                ++pl;
                continue;
            }
            ret[i++] = vr;
            ++pr;
        }
        while (pl < sl) {
            ret[i++] = this.get(pl++);
        }
        while (pr < sr) {
            ret[i++] = other.get(pr++);
        }
        return ColIndexFactory.create(ret);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(Arrays.toString(this.cols));
        return sb.toString();
    }

    protected class ArrayIterator
    implements IIterate {
        int id = 0;

        protected ArrayIterator() {
        }

        @Override
        public int next() {
            return ArrayIndex.this.cols[this.id++];
        }

        @Override
        public boolean hasNext() {
            return this.id < ArrayIndex.this.cols.length;
        }
    }
}

