/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.NotImplementedException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.CompressedMatrixBlockFactory;
import org.apache.sysds.runtime.compress.io.CompressedWriteBlock;
import org.apache.sysds.runtime.compress.lib.CLALibCombine;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.io.MatrixReader;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;

public final class ReaderCompressed
extends MatrixReader {
    public static ReaderCompressed create() {
        return new ReaderCompressed();
    }

    public static MatrixBlock readCompressedMatrixFromHDFS(String fname) throws IOException {
        return ReaderCompressed.create().readMatrixFromHDFS(fname, 10L, 10L, 10, 100L);
    }

    @Override
    public MatrixBlock readMatrixFromHDFS(String fname, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        FileSystem fs = IOUtilFunctions.getFileSystem(path, (Configuration)job);
        ReaderCompressed.checkValidInputFile(fs, path);
        return ReaderCompressed.readCompressedMatrix(path, job, fs, (int)rlen, (int)clen, blen);
    }

    @Override
    public MatrixBlock readMatrixFromInputStream(InputStream is, long rlen, long clen, int blen, long estnnz) throws IOException, DMLRuntimeException {
        throw new NotImplementedException("Not implemented reading compressedMatrix from input stream");
    }

    private static MatrixBlock readCompressedMatrix(Path path, JobConf job, FileSystem fs, int rlen, int clen, int blen) throws IOException {
        HashMap<MatrixIndexes, MatrixBlock> data = new HashMap<MatrixIndexes, MatrixBlock>();
        for (Path subPath : IOUtilFunctions.getSequenceFilePaths(fs, path)) {
            ReaderCompressed.read(subPath, job, data);
        }
        if (data.size() == 1) {
            return (MatrixBlock)data.entrySet().iterator().next().getValue();
        }
        return CLALibCombine.combine(data, OptimizerUtils.getParallelTextWriteParallelism());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void read(Path path, JobConf job, Map<MatrixIndexes, MatrixBlock> data) throws IOException {
        SequenceFile.Reader reader = new SequenceFile.Reader((Configuration)job, new SequenceFile.Reader.Option[]{SequenceFile.Reader.file((Path)path)});
        try {
            MatrixIndexes key = new MatrixIndexes();
            CompressedWriteBlock value = new CompressedWriteBlock();
            while (reader.next((Writable)key, (Writable)value)) {
                MatrixBlock g = value.get();
                if (g instanceof CompressedMatrixBlock) {
                    data.put(key, g);
                } else if (g.isEmpty()) {
                    data.put(key, CompressedMatrixBlockFactory.createConstant(g.getNumRows(), g.getNumColumns(), 0.0));
                } else {
                    data.put(key, g);
                }
                key = new MatrixIndexes();
                value = new CompressedWriteBlock();
            }
        }
        finally {
            IOUtilFunctions.closeSilently((Closeable)reader);
        }
    }
}

