/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.cp;

import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.functionobjects.COV;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPInstruction;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CovarianceCPInstruction
extends BinaryCPInstruction {
    private CovarianceCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.AggregateBinary, op, in1, in2, in3, out, opcode, istr);
    }

    public static CovarianceCPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cov")) {
            throw new DMLRuntimeException("CovarianceCPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        InstructionUtils.checkNumFields(parts, 4, 5);
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = parts.length == 5 ? null : new CPOperand(parts[3]);
        CPOperand out = new CPOperand(parts[parts.length - 2]);
        int numThreads = Integer.parseInt(parts[parts.length - 1]);
        COVOperator cov = new COVOperator(COV.getCOMFnObject(), numThreads);
        return new CovarianceCPInstruction(cov, in1, in2, in3, out, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        MatrixBlock matBlock1 = ec.getMatrixInput(this.input1.getName());
        MatrixBlock matBlock2 = ec.getMatrixInput(this.input2.getName());
        String output_name = this.output.getName();
        COVOperator cov_op = (COVOperator)this._optr;
        CM_COV_Object covobj = null;
        if (this.input3 == null) {
            covobj = matBlock1.covOperations(cov_op, matBlock2);
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName());
        } else {
            MatrixBlock wtBlock = ec.getMatrixInput(this.input3.getName());
            covobj = matBlock1.covOperations(cov_op, matBlock2, wtBlock);
            ec.releaseMatrixInput(this.input1.getName(), this.input2.getName(), this.input3.getName());
        }
        double val = covobj.getRequiredResult(this._optr);
        ec.setScalarOutput(output_name, new DoubleObject(val));
    }
}

