/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.privacy.propagation;

import org.apache.sysds.runtime.privacy.PrivacyConstraint;
import org.apache.sysds.runtime.privacy.finegrained.FineGrainedPrivacy;
import org.apache.sysds.runtime.privacy.propagation.MatrixMultiplicationPropagator;
import org.apache.sysds.runtime.privacy.propagation.OperatorType;

public class MatrixMultiplicationPropagatorPrivateFirstOptimized
extends MatrixMultiplicationPropagator {
    @Override
    protected void generateFineGrainedConstraints(FineGrainedPrivacy mergedFineGrainedConstraints, PrivacyConstraint.PrivacyLevel[] rowPrivacy, PrivacyConstraint.PrivacyLevel[] colPrivacy, OperatorType[] operatorTypes1, OperatorType[] operatorTypes2) {
        int l;
        int r1 = rowPrivacy.length;
        int c2 = colPrivacy.length;
        for (int i = 0; i < rowPrivacy.length; ++i) {
            if (rowPrivacy[i] == PrivacyConstraint.PrivacyLevel.Private) {
                mergedFineGrainedConstraints.putRow(i, c2, PrivacyConstraint.PrivacyLevel.Private);
                continue;
            }
            if (operatorTypes1[i] != OperatorType.NonAggregate) continue;
            if (rowPrivacy[i] == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                mergedFineGrainedConstraints.putRow(i, c2, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
                continue;
            }
            for (l = 0; l < colPrivacy.length; ++l) {
                if (colPrivacy[l] != PrivacyConstraint.PrivacyLevel.PrivateAggregation) continue;
                mergedFineGrainedConstraints.putElement(i, l, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
        }
        for (int j = 0; j < colPrivacy.length; ++j) {
            if (colPrivacy[j] == PrivacyConstraint.PrivacyLevel.Private) {
                mergedFineGrainedConstraints.putCol(j, r1, PrivacyConstraint.PrivacyLevel.Private);
                continue;
            }
            if (operatorTypes2[j] != OperatorType.NonAggregate) continue;
            if (colPrivacy[j] == PrivacyConstraint.PrivacyLevel.PrivateAggregation) {
                mergedFineGrainedConstraints.putCol(j, r1, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
                continue;
            }
            for (l = 0; l < rowPrivacy.length; ++l) {
                if (rowPrivacy[l] != PrivacyConstraint.PrivacyLevel.PrivateAggregation) continue;
                mergedFineGrainedConstraints.putElement(j, l, PrivacyConstraint.PrivacyLevel.PrivateAggregation);
            }
        }
    }
}

