/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Arrays;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictLibMatrixMult;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.DictionaryFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.IDictionary;
import org.apache.sysds.runtime.compress.colgroup.indexes.IColIndex;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.data.DenseBlockFP64;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.data.SparseBlockCSR;
import org.apache.sysds.runtime.data.SparseBlockFactory;
import org.apache.sysds.runtime.data.SparseBlockMCSR;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.functionobjects.Minus;
import org.apache.sysds.runtime.functionobjects.Plus;
import org.apache.sysds.runtime.functionobjects.ValueFunction;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.data.LibMatrixAgg;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.LeftScalarOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class MatrixBlockDictionary
extends ADictionary {
    private static final long serialVersionUID = 2535887782150955098L;
    private final MatrixBlock _data;

    protected MatrixBlockDictionary(MatrixBlock data) {
        this._data = data;
    }

    public static MatrixBlockDictionary create(MatrixBlock mb) {
        return MatrixBlockDictionary.create(mb, true);
    }

    public static MatrixBlockDictionary create(MatrixBlock mb, boolean check) {
        if (mb == null) {
            throw new DMLCompressionException("Invalid construction of dictionary with null array");
        }
        if (mb.getNumRows() == 0 || mb.getNumColumns() == 0) {
            throw new DMLCompressionException("Invalid construction of dictionary with zero rows and/or cols array");
        }
        if (mb.isEmpty()) {
            return null;
        }
        if (check) {
            mb.examSparsity(true);
            if (mb.isInSparseFormat() && mb.getSparseBlock() instanceof SparseBlockMCSR) {
                SparseBlock csr = SparseBlockFactory.copySparseBlock(SparseBlock.Type.CSR, mb.getSparseBlock(), false);
                mb.setSparseBlock(csr);
            }
        }
        return new MatrixBlockDictionary(mb);
    }

    public static MatrixBlockDictionary createDictionary(double[] values, int nCol, boolean check) {
        if (nCol <= 1) {
            MatrixBlock mb = Util.matrixBlockFromDenseArray(values, nCol, check);
            return MatrixBlockDictionary.create(mb, check);
        }
        int nnz = MatrixBlockDictionary.checkNNz(values);
        if ((double)nnz / (double)values.length < 0.4) {
            SparseBlock sb = SparseBlockFactory.createFromArray(values, nCol, nnz);
            MatrixBlock mb = new MatrixBlock(values.length / nCol, nCol, nnz, sb);
            return MatrixBlockDictionary.create(mb, false);
        }
        return MatrixBlockDictionary.create(Util.matrixBlockFromDenseArray(values, nCol, check), false);
    }

    private static int checkNNz(double[] values) {
        int nnz = 0;
        for (int i = 0; i < values.length; ++i) {
            nnz += values[i] == 0.0 ? 0 : 1;
        }
        return nnz;
    }

    public MatrixBlock getMatrixBlock() {
        return this._data;
    }

    @Override
    public double[] getValues() {
        if (this._data.isInSparseFormat()) {
            LOG.warn((Object)"Inefficient call to getValues for a MatrixBlockDictionary because it was sparse");
            throw new DMLCompressionException("Should not call this function");
        }
        return this._data.getDenseBlockValues();
    }

    @Override
    public double getValue(int i) {
        int nCol = this._data.getNumColumns();
        int row = i / nCol;
        if (row > this._data.getNumRows()) {
            return 0.0;
        }
        int col = i % nCol;
        return this._data.quickGetValue(row, col);
    }

    @Override
    public final double getValue(int r, int c, int nCol) {
        return this._data.quickGetValue(r, c);
    }

    @Override
    public long getInMemorySize() {
        return 8L + this._data.estimateSizeInMemory();
    }

    public static long getInMemorySize(int numberValues, int numberColumns, double sparsity) {
        return 8L + MatrixBlock.estimateSizeInMemory((long)numberValues, (long)numberColumns, sparsity);
    }

    @Override
    public double aggregate(double init, Builtin fn) {
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MAX) {
            return fn.execute(init, this._data.max());
        }
        if (fn.getBuiltinCode() == Builtin.BuiltinCode.MIN) {
            return fn.execute(init, this._data.min());
        }
        throw new NotImplementedException();
    }

    @Override
    public double aggregateWithReference(double init, Builtin fn, double[] reference, boolean def) {
        double ret;
        block8: {
            int nRows;
            block7: {
                int nCol = reference.length;
                nRows = this._data.getNumRows();
                ret = init;
                if (def) {
                    for (int i = 0; i < nCol; ++i) {
                        ret = fn.execute(ret, reference[i]);
                    }
                }
                if (!this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRows; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    int[] aix = sb.indexes(i);
                    double[] avals = sb.values(i);
                    for (int k = apos; k < alen; ++k) {
                        double v = avals[k] + reference[aix[k]];
                        ret = fn.execute(ret, v);
                    }
                }
                if (def) break block8;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRows) continue;
                    ret = fn.execute(ret, reference[i]);
                }
                break block8;
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRows; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret = fn.execute(ret, v);
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRows(Builtin fn, int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else {
            if (nCol == 1) {
                return this._data.getDenseBlockValues();
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        return ret;
    }

    @Override
    public double[] aggregateRowsWithDefault(Builtin fn, double[] defaultTuple) {
        int nRow = this._data.getNumRows();
        int nCol = defaultTuple.length;
        double[] ret = new double[this._data.getNumRows() + 1];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = avals[apos];
                    for (int j = apos + 1; j < alen; ++j) {
                        ret[i] = fn.execute(ret[i], avals[j]);
                    }
                    if (sb.size(i) >= this._data.getNumColumns()) continue;
                    ret[i] = fn.execute(ret[i], 0.0);
                    continue;
                }
                ret[i] = fn.execute(ret[i], 0.0);
            }
        } else if (nCol == 1) {
            System.arraycopy(this._data.getDenseBlockValues(), 0, ret, 0, this._data.getNumRows());
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = values[off++];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    ret[k] = fn.execute(ret[k], values[off++]);
                }
            }
        }
        ret[nRow] = defaultTuple[0];
        for (int i = 1; i < defaultTuple.length; ++i) {
            ret[nRow] = fn.execute(ret[nRow], defaultTuple[i]);
        }
        return ret;
    }

    @Override
    public double[] aggregateRowsWithReference(Builtin fn, double[] reference) {
        int nCol = reference.length;
        int nRows = this._data.getNumRows();
        double[] ret = new double[nRows + 1];
        ret[nRows] = reference[0];
        for (int i = 1; i < nCol; ++i) {
            ret[nRows] = fn.execute(ret[nRows], reference[i]);
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRows; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[nRows];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                double d = ret[i] = aix[k] == 0 ? avals[k++] + reference[0] : reference[0];
                for (j = 1; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    ret[i] = fn.execute(ret[i], v);
                }
                while (j < this._data.getNumColumns()) {
                    ret[i] = fn.execute(ret[i], reference[j]);
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRows; ++k) {
                ret[k] = values[off++] + reference[0];
                for (int j = 1; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret[k] = fn.execute(ret[k], v);
                }
            }
        }
        return ret;
    }

    @Override
    public void aggregateCols(double[] c, Builtin fn, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            MatrixBlock t = LibMatrixReorg.transpose(this._data);
            if (!t.isInSparseFormat()) {
                LOG.warn((Object)"Transpose for aggregating of columns");
                t.denseToSparse(true);
            }
            SparseBlock sbt = t.getSparseBlock();
            for (int i = 0; i < this._data.getNumColumns(); ++i) {
                int idx = colIndexes.get(i);
                if (!sbt.isEmpty(i)) {
                    int apos = sbt.pos(i);
                    int alen = sbt.size(i) + apos;
                    double[] avals = sbt.values(i);
                    for (int j = apos; j < alen; ++j) {
                        c[idx] = fn.execute(c[idx], avals[j]);
                    }
                    if (alen == this._data.getNumRows()) continue;
                    c[idx] = fn.execute(c[idx], 0.0);
                    continue;
                }
                c[idx] = fn.execute(c[idx], 0.0);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    int idx = colIndexes.get(j);
                    c[idx] = fn.execute(c[idx], values[off++]);
                }
            }
        }
    }

    @Override
    public void aggregateColsWithReference(double[] c, Builtin fn, IColIndex colIndexes, double[] reference, boolean def) {
        block8: {
            int nRow;
            int nCol;
            block7: {
                nCol = this._data.getNumColumns();
                nRow = this._data.getNumRows();
                if (def) {
                    for (int j = 0; j < colIndexes.size(); ++j) {
                        int idx = colIndexes.get(j);
                        c[idx] = fn.execute(c[idx], reference[j]);
                    }
                }
                if (!this._data.isInSparseFormat()) break block7;
                SparseBlock sb = this._data.getSparseBlock();
                for (int i = 0; i < nRow; ++i) {
                    if (sb.isEmpty(i)) continue;
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    for (int k = apos; k < alen; ++k) {
                        int idx = colIndexes.get(aix[k]);
                        c[idx] = fn.execute(c[idx], avals[k] + reference[aix[k]]);
                    }
                }
                if (def) break block8;
                int[] nnz = LibMatrixReorg.countNnzPerColumn(this._data);
                for (int i = 0; i < nnz.length; ++i) {
                    if (nnz[i] >= nRow) continue;
                    int idx = colIndexes.get(i);
                    c[idx] = fn.execute(c[idx], reference[i]);
                }
                break block8;
            }
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int j = 0; j < nCol; ++j) {
                    int idx = colIndexes.get(j);
                    c[idx] = fn.execute(c[idx], values[off++] + reference[j]);
                }
            }
        }
    }

    @Override
    public IDictionary applyScalarOp(ScalarOperator op) {
        MatrixBlock res = this._data.scalarOperations(op, new MatrixBlock());
        return MatrixBlockDictionary.create(res);
    }

    @Override
    public IDictionary applyScalarOpAndAppend(ScalarOperator op, double v0, int nCol) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows() + 1, this._data.getNumColumns(), v0);
        double[] retV = ret.getDenseBlockValues();
        if (this._data.isInSparseFormat()) {
            int nRow = this._data.getNumRows();
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int k = apos; k < alen; ++k) {
                    retV[i * nCol + aix[k]] = op.executeScalar(avals[i]);
                }
            }
        } else {
            double[] v = this._data.getDenseBlockValues();
            for (int i = 0; i < v.length; ++i) {
                retV[i] = op.executeScalar(v[i]);
            }
        }
        ret.recomputeNonZeros();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyUnaryOp(UnaryOperator op) {
        MatrixBlock res = this._data.unaryOperations(op, new MatrixBlock());
        return MatrixBlockDictionary.create(res);
    }

    @Override
    public IDictionary applyUnaryOpAndAppend(UnaryOperator op, double v0, int nCol) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows() + 1, this._data.getNumColumns(), v0);
        double[] retV = ret.getDenseBlockValues();
        if (this._data.isInSparseFormat()) {
            int nRow = this._data.getNumRows();
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int k = apos; k < alen; ++k) {
                    retV[i * nCol + aix[k]] = op.fn.execute(avals[i]);
                }
            }
        } else {
            double[] v = this._data.getDenseBlockValues();
            for (int i = 0; i < v.length; ++i) {
                retV[i] = op.fn.execute(v[i]);
            }
        }
        ret.recomputeNonZeros();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyScalarOpWithReference(ScalarOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.executeScalar(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.executeScalar(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.executeScalar(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.executeScalar(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary applyUnaryOpWithReference(UnaryOperator op, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(v) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpLeft(BinaryOperator op, double[] v, IColIndex colIndexes) {
        LOG.warn((Object)"Binary row op left is not supported for Uncompressed Matrix, Implement support for VMr in MatrixBlock Binary Cell operations");
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(v[j2], 0.0);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(v[j], vx);
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(v[j], 0.0);
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[j], values[off]);
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpLeftAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int j;
        int i;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow + 1, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (i = 0; i < nRow; ++i) {
                int j2;
                if (sb.isEmpty(i)) {
                    for (j = 0; j < nCol; ++j) {
                        retV[off++] = op.fn.execute(v[j], 0.0);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j2 = 0; j2 < nCol && k < alen; ++j2) {
                    double vx = aix[k] == j2 ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(v[j2], vx);
                }
                while (j2 < nCol) {
                    retV[off++] = op.fn.execute(v[j2], 0.0);
                    ++j2;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (i = 0; i < nRow; ++i) {
                for (j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[j], values[off]);
                    ++off;
                }
            }
        }
        for (int j3 = 0; j3 < nCol; ++j3) {
            retV[off] = op.fn.execute(v[j3], 0.0);
            ++off;
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpLeftWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(v[j2], reference[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(v[j], vx) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(v[j], reference[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(v[j], values[off] + reference[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v, IColIndex colIndexes) {
        MatrixBlock rowVector = Util.extractValues(v, colIndexes);
        MatrixBlock ret = this._data.binaryOperations(op, rowVector, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary binOpRightAndAppend(BinaryOperator op, double[] v, IColIndex colIndexes) {
        int j;
        int i;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow + 1, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (i = 0; i < nRow; ++i) {
                int j2;
                if (sb.isEmpty(i)) {
                    for (j = 0; j < nCol; ++j) {
                        retV[off++] = op.fn.execute(0.0, v[j]);
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j2 = 0; j2 < nCol && k < alen; ++j2) {
                    double vx = aix[k] == j2 ? avals[k++] : 0.0;
                    retV[off++] = op.fn.execute(vx, v[j2]);
                }
                while (j2 < nCol) {
                    retV[off++] = op.fn.execute(0.0, v[j2]);
                    ++j2;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (i = 0; i < nRow; ++i) {
                for (j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off], v[j]);
                    ++off;
                }
            }
        }
        for (int j3 = 0; j3 < nCol; ++j3) {
            retV[off] = op.fn.execute(0.0, v[j3]);
            ++off;
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRight(BinaryOperator op, double[] v) {
        MatrixBlock rowVector = new MatrixBlock(1, v.length, v);
        MatrixBlock ret = this._data.binaryOperations(op, rowVector, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary binOpRightWithReference(BinaryOperator op, double[] v, IColIndex colIndexes, double[] reference, double[] newReference) {
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = op.fn.execute(reference[j2], v[j2]) - newReference[j2];
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double vx = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = op.fn.execute(vx, v[j]) - newReference[j];
                }
                while (j < nCol) {
                    retV[off++] = op.fn.execute(reference[j], v[j]) - newReference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    retV[off] = op.fn.execute(values[off] + reference[j], v[j]) - newReference[j];
                    ++off;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary clone() {
        MatrixBlock ret = new MatrixBlock();
        ret.copy(this._data);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary.DictType getDictType() {
        return IDictionary.DictType.MatrixBlock;
    }

    @Override
    public int getNumberOfValues(int ncol) {
        if (ncol != this._data.getNumColumns()) {
            throw new DMLCompressionException("Invalid call to get Number of values assuming wrong number of columns");
        }
        return this._data.getNumRows();
    }

    @Override
    public double[] sumAllRowsToDouble(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithDefault(double[] defaultTuple) {
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        for (double v : defaultTuple) {
            int n = numVals;
            ret[n] = ret[n] + v;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        int finalIndex = numVals;
        for (int i = 0; i < nCol; ++i) {
            int n = finalIndex;
            ret[n] = ret[n] + reference[i];
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[finalIndex];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = i;
                    ret[n] = ret[n] + v;
                }
                while (j < this._data.getNumColumns()) {
                    int n = i;
                    ret[n] = ret[n] + reference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSq(int nrColumns) {
        double[] ret = new double[this._data.getNumRows()];
        this.sumAllRowsToDoubleSq(ret);
        return ret;
    }

    private void sumAllRowsToDoubleSq(double[] ret) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = i;
                    ret[n] = ret[n] + avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithDefault(double[] defaultTuple) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.sumAllRowsToDoubleSq(ret);
        int defIdx = ret.length - 1;
        for (int j = 0; j < this._data.getNumColumns(); ++j) {
            double v = defaultTuple[j];
            int n = defIdx;
            ret[n] = ret[n] + v * v;
        }
        return ret;
    }

    @Override
    public double[] sumAllRowsToDoubleSqWithReference(double[] reference) {
        int nCol = reference.length;
        int numVals = this._data.getNumRows();
        double[] ret = new double[numVals + 1];
        int finalIndex = numVals;
        for (int i = 0; i < nCol; ++i) {
            int n = finalIndex;
            ret[n] = ret[n] + reference[i] * reference[i];
        }
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    ret[i] = ret[finalIndex];
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = i;
                    ret[n] = ret[n] + v * v;
                }
                while (j < this._data.getNumColumns()) {
                    int n = i;
                    ret[n] = ret[n] + reference[j] * reference[j];
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = k;
                    ret[n] = ret[n] + v * v;
                }
            }
        }
        return ret;
    }

    @Override
    public double[] productAllRowsToDouble(int nCol) {
        double[] ret = new double[this._data.getNumRows()];
        this.productAllRowsToDouble(ret, nCol);
        return ret;
    }

    private final void productAllRowsToDouble(double[] ret, int nCol) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (!sb.isEmpty(i) && sb.size(i) == nCol) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    ret[i] = 1.0;
                    for (int j = apos; j < alen; ++j) {
                        int n = i;
                        ret[n] = ret[n] * avals[j];
                    }
                    continue;
                }
                ret[i] = 0.0;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < this._data.getNumRows(); ++k) {
                ret[k] = 1.0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = k;
                    ret[n] = ret[n] * v;
                }
            }
        }
    }

    @Override
    public double[] productAllRowsToDoubleWithDefault(double[] defaultTuple) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.productAllRowsToDouble(ret, defaultTuple.length);
        ret[this._data.getNumRows()] = defaultTuple[0];
        for (int j = 1; j < defaultTuple.length; ++j) {
            int n = this._data.getNumRows();
            ret[n] = ret[n] * defaultTuple[j];
        }
        return ret;
    }

    private final void productAllRowsToDoubleWithReference(double[] ret, int nCol, double[] reference) {
        int nRow = this._data.getNumRows();
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                ret[i] = 1.0;
                if (!sb.isEmpty(i)) {
                    int apos = sb.pos(i);
                    int alen = sb.size(i) + apos;
                    double[] avals = sb.values(i);
                    int[] aix = sb.indexes(i);
                    int jj = apos;
                    for (int j = 0; j < nCol; ++j) {
                        if (jj < alen && aix[jj] == j) {
                            int n = i;
                            ret[n] = ret[n] * (avals[jj++] + reference[j]);
                            continue;
                        }
                        if (reference[j] == 0.0) {
                            ret[i] = 0.0;
                            continue;
                        }
                        int n = i;
                        ret[n] = ret[n] * reference[j];
                    }
                    continue;
                }
                for (int j = 0; j < nCol; ++j) {
                    int n = i;
                    ret[n] = ret[n] * reference[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                ret[k] = 1.0;
                for (int j = 0; j < nCol; ++j) {
                    int n = k;
                    ret[n] = ret[n] * (values[off++] + reference[j]);
                }
            }
        }
    }

    @Override
    public double[] productAllRowsToDoubleWithReference(double[] reference) {
        double[] ret = new double[this._data.getNumRows() + 1];
        this.productAllRowsToDoubleWithReference(ret, reference.length, reference);
        ret[this._data.getNumRows()] = reference[0];
        for (int j = 1; j < reference.length; ++j) {
            int n = this._data.getNumRows();
            ret[n] = ret[n] * reference[j];
        }
        return ret;
    }

    @Override
    public void colSum(double[] c, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    c[n] = c[n] + (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * (double)countK;
                }
            }
        }
    }

    @Override
    public void colSumSq(double[] c, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    c[n] = c[n] + (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public void colProduct(double[] res, int[] counts, IColIndex colIndexes) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            int[] cnt = new int[colIndexes.size()];
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    res[n] = res[n] * Math.pow(avals[j], count);
                }
                LibMatrixAgg.countAgg(avals, cnt, aix, apos, sb.size(i));
            }
            int nVal = this.getNumberOfValues(colIndexes.size());
            for (int j = 0; j < colIndexes.size(); ++j) {
                if (cnt[j] >= nVal) continue;
                res[colIndexes.get((int)j)] = 0.0;
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int count = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    int n = colIndexes.get(j);
                    res[n] = res[n] * Math.pow(v, count);
                }
            }
        }
        MatrixBlockDictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colProductWithReference(double[] res, int[] counts, IColIndex colIndexes, double[] reference) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            int[] cnt = new int[colIndexes.size()];
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    int n = colIndexes.get(aix[j]);
                    res[n] = res[n] * Math.pow(avals[j] + reference[aix[j]], count);
                }
                LibMatrixAgg.countAgg(avals, cnt, aix, apos, sb.size(i));
            }
            int nVal = this.getNumberOfValues(colIndexes.size());
            for (int j = 0; j < colIndexes.size(); ++j) {
                if (cnt[j] >= nVal || cnt[j] - nVal == 0) continue;
                int n = colIndexes.get(j);
                res[n] = res[n] * Math.pow(reference[j], cnt[j]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int count = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = colIndexes.get(j);
                    res[n] = res[n] * Math.pow(v, count);
                }
            }
        }
        MatrixBlockDictionary.correctNan(res, colIndexes);
    }

    @Override
    public void colSumSqWithReference(double[] c, int[] counts, IColIndex colIndexes, double[] reference) {
        int nCol = reference.length;
        int nRow = counts.length;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        int n = colIndexes.get(j2);
                        c[n] = c[n] + reference[j2] * reference[j2] * (double)countK;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    int n = colIndexes.get(j);
                    c[n] = c[n] + reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < nRow; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    int n = colIndexes.get(j);
                    c[n] = c[n] + v * v * (double)countK;
                }
            }
        }
    }

    @Override
    public double sum(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSq(int[] counts, int ncol) {
        double tmpSum = 0.0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                int count = counts[i];
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                for (int j = apos; j < alen; ++j) {
                    tmpSum += (double)count * avals[j] * avals[j];
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < counts.length; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++];
                    tmpSum += v * v * (double)countK;
                }
            }
        }
        return tmpSum;
    }

    @Override
    public double sumSqWithReference(int[] counts, double[] reference) {
        int nCol = reference.length;
        int numVals = counts.length;
        double ret = 0.0;
        if (this._data.isInSparseFormat()) {
            double ref = 0.0;
            for (int i = 0; i < nCol; ++i) {
                ref += reference[i] * reference[i];
            }
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < numVals; ++i) {
                int j;
                int countK = counts[i];
                if (sb.isEmpty(i)) {
                    ret += ref * (double)countK;
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    ret += v * v * (double)countK;
                }
                while (j < this._data.getNumColumns()) {
                    ret += reference[j] * reference[j] * (double)countK;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int k = 0; k < numVals; ++k) {
                int countK = counts[k];
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v = values[off++] + reference[j];
                    ret += v * v * (double)countK;
                }
            }
        }
        return ret;
    }

    @Override
    public IDictionary sliceOutColumnRange(int idxStart, int idxEnd, int previousNumberOfColumns) {
        MatrixBlock ret = this._data.slice(0, this._data.getNumRows() - 1, idxStart, idxEnd - 1);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public boolean containsValue(double pattern) {
        return this._data.containsValue(pattern);
    }

    @Override
    public boolean containsValueWithReference(double pattern, double[] reference) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                int j;
                if (sb.isEmpty(i)) continue;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (!(aix[k] == j ? reference[j] + avals[k++] == pattern : reference[j] == pattern)) continue;
                    return true;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] == pattern) {
                        return true;
                    }
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int nCol = reference.length;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] + reference[i % nCol] != pattern) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public long getNumberNonZeros(int[] counts, int nCol) {
        long nnz = 0L;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < counts.length; ++i) {
                if (sb.isEmpty(i)) continue;
                nnz += (long)(sb.size(i) * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    double v;
                    if ((v = values[off++]) == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public long getNumberNonZerosWithReference(int[] counts, double[] reference, int nRows) {
        long nnz = 0L;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            long emptyRowNNZ = nnz;
            for (int i = 0; i < counts.length; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    nnz += emptyRowNNZ * (long)counts[i];
                    continue;
                }
                int countThis = 0;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < this._data.getNumColumns() && k < alen; ++j) {
                    if (aix[k] == j) {
                        if (reference[j] + avals[k++] == 0.0) continue;
                        ++countThis;
                        continue;
                    }
                    if (reference[j] == 0.0) continue;
                    ++countThis;
                }
                while (j < this._data.getNumColumns()) {
                    if (reference[j] != 0.0) {
                        ++countThis;
                    }
                    ++j;
                }
                nnz += (long)(countThis * counts[i]);
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            int off = 0;
            for (int i = 0; i < counts.length; ++i) {
                int countThisTuple = 0;
                for (int j = 0; j < this._data.getNumColumns(); ++j) {
                    if (values[off++] + reference[j] == 0.0) continue;
                    ++countThisTuple;
                }
                nnz += (long)(countThisTuple * counts[i]);
            }
        }
        return nnz;
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i];
        }
    }

    @Override
    public void addToEntry(double[] v, int fr, int to, int nCol, int rep) {
        if (this._data.isInSparseFormat()) {
            MatrixBlockDictionary.addToEntrySparse(this._data.getSparseBlock(), v, fr, to * nCol, nCol, rep);
        } else {
            MatrixBlockDictionary.addToEntryDense(this._data.getDenseBlockValues(), v, fr * nCol, to * nCol, nCol, rep);
        }
    }

    private static final void addToEntrySparse(SparseBlock sb, double[] v, int fr, int st, int nCol, int rep) {
        if (sb.isEmpty(fr)) {
            return;
        }
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        int[] aix = sb.indexes(fr);
        double[] avals = sb.values(fr);
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j] * (double)rep;
        }
    }

    private static final void addToEntrySparseCSR(SparseBlockCSR sb, double[] v, int fr, int st, int nCol, int[] aix, double[] avals) {
        int apos = sb.pos(fr);
        int alen = sb.size(fr) + apos;
        for (int j = apos; j < alen; ++j) {
            int n = st + aix[j];
            v[n] = v[n] + avals[j];
        }
    }

    private static final void addToEntryDense(double[] thisV, double[] v, int sf, int st, int nCol, int rep) {
        int j = st;
        for (int i = sf; i < sf + nCol; ++i) {
            int n = j++;
            v[n] = v[n] + thisV[i] * (double)rep;
        }
    }

    @Override
    public void addToEntryVectorized(double[] v, int f1, int f2, int f3, int f4, int f5, int f6, int f7, int f8, int t1, int t2, int t3, int t4, int t5, int t6, int t7, int t8, int nCol) {
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            if (sb instanceof SparseBlockCSR) {
                SparseBlockCSR csr = (SparseBlockCSR)sb;
                int[] aix = csr.indexes();
                double[] avals = csr.values();
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f1, t1 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f2, t2 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f3, t3 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f4, t4 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f5, t5 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f6, t6 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f7, t7 * nCol, nCol, aix, avals);
                MatrixBlockDictionary.addToEntrySparseCSR(csr, v, f8, t8 * nCol, nCol, aix, avals);
            } else {
                MatrixBlockDictionary.addToEntrySparse(sb, v, f1, t1 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f2, t2 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f3, t3 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f4, t4 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f5, t5 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f6, t6 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f7, t7 * nCol, nCol);
                MatrixBlockDictionary.addToEntrySparse(sb, v, f8, t8 * nCol, nCol);
            }
        } else {
            double[] thisV = this._data.getDenseBlockValues();
            MatrixBlockDictionary.addToEntryDense(thisV, v, f1 * nCol, t1 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f2 * nCol, t2 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f3 * nCol, t3 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f4 * nCol, t4 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f5 * nCol, t5 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f6 * nCol, t6 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f7 * nCol, t7 * nCol, nCol);
            MatrixBlockDictionary.addToEntryDense(thisV, v, f8 * nCol, t8 * nCol, nCol);
        }
    }

    @Override
    public IDictionary subtractTuple(double[] tuple) {
        MatrixBlock v = new MatrixBlock(1, tuple.length, tuple);
        BinaryOperator op = new BinaryOperator(Minus.getMinusFnObject());
        MatrixBlock ret = this._data.binaryOperations(op, v, null);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public MatrixBlockDictionary getMBDict(int nCol) {
        return this;
    }

    @Override
    public String getString(int colIndexes) {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "\n" + this._data.toString();
        }
        return Arrays.toString(this._data.getDenseBlockValues());
    }

    public String toString() {
        if (this._data.isInSparseFormat() || this._data.getNumColumns() > 1) {
            return "MatrixBlock Dictionary :\n" + this._data.toString();
        }
        return "MatrixBlock Dictionary : " + Arrays.toString(this._data.getDenseBlockValues());
    }

    @Override
    public IDictionary scaleTuples(int[] scaling, int nCol) {
        if (this._data.isInSparseFormat()) {
            MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), true);
            retBlock.allocateSparseRowsBlock(true);
            SparseBlock sbRet = retBlock.getSparseBlock();
            SparseBlock sbThis = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sbThis.isEmpty(i)) continue;
                sbRet.set(i, sbThis.get(i), true);
                int count = scaling[i];
                int apos = sbRet.pos(i);
                int alen = sbRet.size(i) + apos;
                double[] avals = sbRet.values(i);
                for (int j = apos; j < alen; ++j) {
                    avals[j] = (double)count * avals[j];
                }
            }
            retBlock.setNonZeros(this._data.getNonZeros());
            return MatrixBlockDictionary.create(retBlock);
        }
        double[] _values = this._data.getDenseBlockValues();
        double[] scaledValues = new double[_values.length];
        int off = 0;
        for (int tuple = 0; tuple < _values.length / nCol; ++tuple) {
            int scale = scaling[tuple];
            for (int v = 0; v < nCol; ++v) {
                scaledValues[off] = _values[off] * (double)scale;
                ++off;
            }
        }
        DenseBlockFP64 db = new DenseBlockFP64(new int[]{this._data.getNumRows(), this._data.getNumColumns()}, scaledValues);
        MatrixBlock retBlock = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), db);
        retBlock.setNonZeros(this._data.getNonZeros());
        return MatrixBlockDictionary.create(retBlock);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        out.writeByte(DictionaryFactory.Type.MATRIX_BLOCK_DICT.ordinal());
        this._data.write(out);
    }

    public static MatrixBlockDictionary read(DataInput in) throws IOException {
        MatrixBlock ret = new MatrixBlock();
        ret.readFields(in);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public long getExactSizeOnDisk() {
        return 1L + this._data.getExactSizeOnDisk();
    }

    @Override
    public MatrixBlockDictionary preaggValuesFromDense(int numVals, IColIndex colIndexes, IColIndex aggregateColumns, double[] b, int cut) {
        double[] ret = new double[numVals * aggregateColumns.size()];
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < this._data.getNumRows(); ++i) {
                if (sb.isEmpty(i)) continue;
                int off = aggregateColumns.size() * i;
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                double[] avals = sb.values(i);
                int[] aix = sb.indexes(i);
                for (int j = apos; j < alen; ++j) {
                    int idb = colIndexes.get(aix[j]) * cut;
                    double v = avals[j];
                    for (int h = 0; h < aggregateColumns.size(); ++h) {
                        int n = off + h;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns.get(h)];
                    }
                }
            }
        } else {
            int cz = colIndexes.size();
            int az = aggregateColumns.size();
            double[] values = this._data.getDenseBlockValues();
            int k = 0;
            int off = 0;
            while (k < numVals * cz) {
                for (int h = 0; h < cz; ++h) {
                    int idb = colIndexes.get(h) * cut;
                    double v = values[k + h];
                    if (v == 0.0) continue;
                    for (int i = 0; i < az; ++i) {
                        int n = off + i;
                        ret[n] = ret[n] + v * b[idb + aggregateColumns.get(i)];
                    }
                }
                k += cz;
                off += az;
            }
        }
        DenseBlockFP64 dictV = new DenseBlockFP64(new int[]{numVals, aggregateColumns.size()}, ret);
        MatrixBlock r = new MatrixBlock(numVals, aggregateColumns.size(), dictV);
        r.recomputeNonZeros();
        r.examSparsity();
        return MatrixBlockDictionary.create(r);
    }

    @Override
    public IDictionary replace(double pattern, double replace, int nCol) {
        MatrixBlock ret = this._data.replaceOperations(new MatrixBlock(), pattern, replace);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary replaceWithReference(double pattern, double replace, double[] reference) {
        if (Util.eq(pattern, Double.NaN)) {
            throw new NotImplementedException();
        }
        int nRow = this._data.getNumRows();
        int nCol = this._data.getNumColumns();
        MatrixBlock ret = new MatrixBlock(nRow, nCol, false);
        ret.allocateDenseBlock();
        double[] retV = ret.getDenseBlockValues();
        int off = 0;
        if (this._data.isInSparseFormat()) {
            SparseBlock sb = this._data.getSparseBlock();
            for (int i = 0; i < nRow; ++i) {
                int j;
                if (sb.isEmpty(i)) {
                    for (int j2 = 0; j2 < nCol; ++j2) {
                        retV[off++] = pattern == reference[j2] ? replace - reference[j2] : 0.0;
                    }
                    continue;
                }
                int apos = sb.pos(i);
                int alen = sb.size(i) + apos;
                int[] aix = sb.indexes(i);
                double[] avals = sb.values(i);
                int k = apos;
                for (j = 0; j < nCol && k < alen; ++j) {
                    double v = aix[k] == j ? avals[k++] + reference[j] : reference[j];
                    retV[off++] = Math.abs(v - pattern) < 1.0E-5 ? replace - reference[j] : v - reference[j];
                }
                while (j < nCol) {
                    retV[off++] = pattern == reference[j] ? replace - reference[j] : 0.0;
                    ++j;
                }
            }
        } else {
            double[] values = this._data.getDenseBlockValues();
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off];
                    retV[off++] = Math.abs(v + reference[j] - pattern) < 1.0E-5 ? replace - reference[j] : v;
                }
            }
        }
        ret.recomputeNonZeros();
        ret.examSparsity();
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public void product(double[] ret, int[] counts, int nCol) {
        if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithDefault(double[] ret, int[] counts, double[] def, int defCount) {
        if (this._data.isInSparseFormat()) {
            ret[0] = 0.0;
        } else if (this._data.getNonZeros() < (long)(this._data.getNumColumns() * this._data.getNumRows())) {
            ret[0] = 0.0;
        } else {
            MathContext cont = MathContext.DECIMAL128;
            int nRow = this._data.getNumRows();
            int nCol = def.length;
            double[] values = this._data.getDenseBlockValues();
            BigDecimal tmp = BigDecimal.ONE;
            int off = 0;
            for (int i = 0; i < nRow; ++i) {
                for (int j = 0; j < nCol; ++j) {
                    double v = values[off++];
                    tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
                }
            }
            for (int x = 0; x < def.length; ++x) {
                tmp = tmp.multiply(new BigDecimal(def[x]).pow(defCount, cont), cont);
            }
            if (Math.abs(tmp.doubleValue()) == 0.0) {
                ret[0] = 0.0;
            } else if (!Double.isInfinite(ret[0])) {
                ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
            }
        }
    }

    @Override
    public void productWithReference(double[] ret, int[] counts, double[] reference, int refCount) {
        MathContext cont = MathContext.DECIMAL128;
        int nCol = this._data.getNumColumns();
        int nRow = this._data.getNumRows();
        this._data.sparseToDense();
        double[] values = this._data.getDenseBlockValues();
        BigDecimal tmp = BigDecimal.ONE;
        int off = 0;
        for (int i = 0; i < nRow; ++i) {
            for (int j = 0; j < nCol; ++j) {
                double v;
                if ((v = values[off++] + reference[j]) == 0.0) {
                    ret[0] = 0.0;
                    return;
                }
                tmp = tmp.multiply(new BigDecimal(v).pow(counts[i], cont), cont);
            }
        }
        for (int x = 0; x < reference.length; ++x) {
            tmp = tmp.multiply(new BigDecimal(reference[x]).pow(refCount, cont), cont);
        }
        if (Math.abs(tmp.doubleValue()) == 0.0) {
            ret[0] = 0.0;
        } else if (!Double.isInfinite(ret[0])) {
            ret[0] = new BigDecimal(ret[0]).multiply(tmp, MathContext.DECIMAL128).doubleValue();
        }
    }

    @Override
    public CM_COV_Object centralMoment(CM_COV_Object ret, ValueFunction fn, int[] counts, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, 0.0, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithDefault(CM_COV_Object ret, ValueFunction fn, int[] counts, double def, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i], counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, def, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public CM_COV_Object centralMomentWithReference(CM_COV_Object ret, ValueFunction fn, int[] counts, double reference, int nRows) {
        if (this._data.isInSparseFormat()) {
            throw new DMLCompressionException("The dictionary should not be sparse with one column");
        }
        double[] vals = this._data.getDenseBlockValues();
        for (int i = 0; i < vals.length; ++i) {
            fn.execute(ret, vals[i] + reference, counts[i]);
        }
        if (ret.getWeight() < (double)nRows) {
            fn.execute(ret, reference, (double)nRows - ret.getWeight());
        }
        return ret;
    }

    @Override
    public IDictionary rexpandCols(int max, boolean ignore, boolean cast, int nCol) {
        if (nCol > 1) {
            throw new DMLCompressionException("Invalid to rexpand the column groups if more than one column");
        }
        MatrixBlock ret = LibMatrixReorg.rexpand(this._data, new MatrixBlock(), max, false, cast, ignore, 1);
        return MatrixBlockDictionary.create(ret);
    }

    @Override
    public IDictionary rexpandColsWithReference(int max, boolean ignore, boolean cast, int reference) {
        IDictionary a = this.applyScalarOp(new LeftScalarOperator(Plus.getPlusFnObject(), reference));
        return a == null ? null : a.rexpandCols(max, ignore, cast, 1);
    }

    @Override
    public double getSparsity() {
        return this._data.getSparsity();
    }

    @Override
    public void multiplyScalar(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        if (this._data.isInSparseFormat()) {
            this.multiplyScalarSparse(v, ret, off, dictIdx, cols);
        } else {
            this.multiplyScalarDense(v, ret, off, dictIdx, cols);
        }
    }

    private void multiplyScalarSparse(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        SparseBlock sb = this._data.getSparseBlock();
        if (sb.isEmpty(dictIdx)) {
            return;
        }
        int apos = sb.pos(dictIdx);
        int alen = sb.size(dictIdx) + apos;
        int[] aix = sb.indexes(dictIdx);
        double[] aval = sb.values(dictIdx);
        for (int i = apos; i < alen; ++i) {
            int n = off + cols.get(aix[i]);
            ret[n] = ret[n] + v * aval[i];
        }
    }

    private void multiplyScalarDense(double v, double[] ret, int off, int dictIdx, IColIndex cols) {
        double[] dV = this._data.getDenseBlockValues();
        int offD = dictIdx * cols.size();
        for (int i = 0; i < cols.size(); ++i) {
            int n = off + cols.get(i);
            ret[n] = ret[n] + v * dV[offD + i];
        }
    }

    @Override
    public void TSMMWithScaling(int[] counts, IColIndex rows, IColIndex cols, MatrixBlock ret) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMDictsSparseWithScaling(this._data.getSparseBlock(), rows, cols, counts, ret);
        } else {
            DictLibMatrixMult.TSMMDictsDenseWithScaling(this._data.getDenseBlockValues(), rows, cols, counts, ret);
        }
    }

    @Override
    public void MMDict(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.MMDictSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.MMDictDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            right.MMDictScalingSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            right.MMDictScalingDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void MMDictDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScalingDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsScalingDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            DictLibMatrixMult.MMDictsScalingDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void MMDictSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMDictsSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void MMDictScalingSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result, int[] scaling) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMDictsScalingSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result, scaling);
        } else {
            DictLibMatrixMult.MMDictsScalingSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result, scaling);
        }
    }

    @Override
    public void TSMMToUpperTriangle(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparse(this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            right.TSMMToUpperTriangleDense(this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleDense(double[] left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleDenseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleDenseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleSparse(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.MMToUpperTriangleSparseSparse(left, this._data.getSparseBlock(), rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleSparseDense(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleScaling(IDictionary right, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            right.TSMMToUpperTriangleSparseScaling(this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            right.TSMMToUpperTriangleDenseScaling(this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleDenseScaling(double[] left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleDenseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleDenseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public void TSMMToUpperTriangleSparseScaling(SparseBlock left, IColIndex rowsLeft, IColIndex colsRight, int[] scale, MatrixBlock result) {
        if (this._data.isInSparseFormat()) {
            DictLibMatrixMult.TSMMToUpperTriangleSparseSparseScaling(left, this._data.getSparseBlock(), rowsLeft, colsRight, scale, result);
        } else {
            DictLibMatrixMult.TSMMToUpperTriangleSparseDenseScaling(left, this._data.getDenseBlockValues(), rowsLeft, colsRight, scale, result);
        }
    }

    @Override
    public boolean equals(IDictionary o) {
        if (o instanceof MatrixBlockDictionary) {
            return this._data.equals(((MatrixBlockDictionary)o)._data);
        }
        if (o instanceof Dictionary) {
            if (this._data.isInSparseFormat()) {
                return this._data.getSparseBlock().equals(((Dictionary)o)._values, this._data.getNumColumns());
            }
            double[] dv = this._data.getDenseBlockValues();
            return Arrays.equals(dv, ((Dictionary)o)._values);
        }
        return false;
    }

    @Override
    public IDictionary cbind(IDictionary that, int nCol) {
        return this.cbind(that.getMBDict(nCol).getMatrixBlock());
    }

    private IDictionary cbind(MatrixBlock that) {
        return new MatrixBlockDictionary(this._data.append(that));
    }

    @Override
    public IDictionary reorder(int[] reorder) {
        MatrixBlock ret = new MatrixBlock(this._data.getNumRows(), this._data.getNumColumns(), this._data.getNonZeros());
        for (int r = 0; r < this._data.getNumRows(); ++r) {
            for (int c = 0; c < this._data.getNumColumns(); ++c) {
                ret.quickSetValue(r, c, this._data.quickGetValue(r, reorder[c]));
            }
        }
        return MatrixBlockDictionary.create(ret, false);
    }
}

