/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor.opt;

import org.apache.sysds.hops.Hop;
import org.apache.sysds.runtime.controlprogram.ProgramBlock;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptNode;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMappingAbstract;
import org.apache.sysds.runtime.controlprogram.parfor.opt.OptTreePlanMappingRuntime;
import org.apache.sysds.runtime.controlprogram.parfor.opt.Optimizer;

public class OptTree {
    private final OptTreePlanMappingAbstract _hlMap;
    private final OptTreePlanMappingRuntime _rtMap;
    private int _ck;
    private double _cm;
    private Optimizer.PlanInputType _type = null;
    private OptNode _root = null;

    public OptTree(int ck, double cm, OptNode node) {
        this(ck, cm, Optimizer.PlanInputType.RUNTIME_PLAN, node, null, null);
    }

    public OptTree(int ck, double cm, Optimizer.PlanInputType type, OptNode node, OptTreePlanMappingAbstract hlMap, OptTreePlanMappingRuntime rtMap) {
        this._ck = ck;
        this._cm = cm;
        this._type = type;
        this._root = node;
        this._hlMap = hlMap;
        this._rtMap = rtMap;
    }

    public OptTreePlanMappingAbstract getAbstractPlanMapping() {
        return this._hlMap;
    }

    public OptTreePlanMappingRuntime getRuntimePlanMapping() {
        return this._rtMap;
    }

    public Hop getMappedHop(long id) {
        return this._hlMap.getMappedHop(id);
    }

    public Object[] getMappedProg(long id) {
        return this._hlMap.getMappedProg(id);
    }

    public ProgramBlock getMappedProgramBlock(long id) {
        return this._hlMap.getMappedProgramBlock(id);
    }

    public int getCK() {
        return this._ck;
    }

    public double getCM() {
        return this._cm;
    }

    public Optimizer.PlanInputType getPlanInputType() {
        return this._type;
    }

    public void setPlanInputType(Optimizer.PlanInputType type) {
        this._type = type;
    }

    public OptNode getRoot() {
        return this._root;
    }

    public void setRoot(OptNode n) {
        this._root = n;
    }

    public String explain(boolean withDetails) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n");
        sb.append("----------------------------\n");
        sb.append(" EXPLAIN OPT TREE (type=");
        sb.append((Object)this._type);
        sb.append(", size=");
        sb.append(this._root.size());
        sb.append(")\n");
        sb.append("----------------------------\n");
        sb.append(this._root.explain(1, withDetails));
        sb.append("----------------------------\n");
        return sb.toString();
    }
}

